/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.resource;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.AmountResourcePhaseStorage;
import org.mars_sim.msp.core.resource.AmountResourceTypeStorage;
import org.mars_sim.msp.core.resource.Phase;

public class AmountResourceStorage
implements Serializable {
    private static Logger logger = Logger.getLogger(AmountResourceStorage.class.getName());
    private AmountResourceTypeStorage typeStorage = null;
    private AmountResourcePhaseStorage phaseStorage = null;
    private transient Set<AmountResource> allStoredResourcesCache = null;
    private transient boolean allStoredResourcesCacheDirty = true;
    private transient double totalResourcesStored = 0.0;
    private transient boolean totalResourcesStoredDirty = true;

    public void addAmountResourceTypeCapacity(AmountResource resource, double capacity) {
        if (this.typeStorage == null) {
            this.typeStorage = new AmountResourceTypeStorage();
        }
        this.typeStorage.addAmountResourceTypeCapacity(resource, capacity);
    }

    public void removeAmountResourceTypeCapacity(AmountResource resource, double capacity) {
        if (this.typeStorage == null) {
            this.typeStorage = new AmountResourceTypeStorage();
        }
        this.typeStorage.removeAmountResourceTypeCapacity(resource, capacity);
    }

    public Map<AmountResource, Double> getAmountResourceTypeCapacities() {
        HashMap<AmountResource, Double> typeCapacities = new HashMap<AmountResource, Double>();
        if (this.typeStorage != null) {
            for (AmountResource resource : AmountResource.getAmountResources()) {
                double capacity = this.typeStorage.getAmountResourceTypeCapacity(resource);
                if (!(capacity > 0.0)) continue;
                typeCapacities.put(resource, capacity);
            }
        }
        return typeCapacities;
    }

    public void addAmountResourcePhaseCapacity(Phase phase, double capacity) {
        if (this.phaseStorage == null) {
            this.phaseStorage = new AmountResourcePhaseStorage();
        }
        this.phaseStorage.addAmountResourcePhaseCapacity(phase, capacity);
    }

    public Map<Phase, Double> getAmountResourcePhaseCapacities() {
        HashMap<Phase, Double> phaseCapacities = new HashMap<Phase, Double>();
        if (this.phaseStorage != null) {
            for (Phase phase : Phase.getPhases()) {
                double capacity = this.phaseStorage.getAmountResourcePhaseCapacity(phase);
                if (!(capacity > 0.0)) continue;
                phaseCapacities.put(phase, capacity);
            }
        }
        return phaseCapacities;
    }

    public boolean hasAmountResourceCapacity(AmountResource resource) {
        boolean result = false;
        if (this.typeStorage != null && this.typeStorage.hasAmountResourceTypeCapacity(resource)) {
            result = true;
        } else if (this.phaseStorage != null && this.phaseStorage.hasAmountResourcePhaseCapacity(resource.getPhase())) {
            result = true;
        }
        return result;
    }

    public double getAmountResourceCapacity(AmountResource resource) {
        double result = 0.0;
        if (this.typeStorage != null && this.typeStorage.hasAmountResourceTypeCapacity(resource)) {
            result = this.typeStorage.getAmountResourceTypeCapacity(resource);
        }
        if (this.phaseStorage != null && this.phaseStorage.hasAmountResourcePhaseCapacity(resource.getPhase()) && (this.phaseStorage.getAmountResourcePhaseType(resource.getPhase()) == null || this.phaseStorage.getAmountResourcePhaseType(resource.getPhase()).equals(resource))) {
            result += this.phaseStorage.getAmountResourcePhaseCapacity(resource.getPhase());
        }
        return result;
    }

    public double getAmountResourceStored(AmountResource resource) {
        double result = 0.0;
        if (this.typeStorage != null) {
            result = this.typeStorage.getAmountResourceTypeStored(resource);
        }
        if (this.phaseStorage != null && resource.equals(this.phaseStorage.getAmountResourcePhaseType(resource.getPhase()))) {
            result += this.phaseStorage.getAmountResourcePhaseStored(resource.getPhase());
        }
        return result;
    }

    public Set<AmountResource> getAllAmountResourcesStored(boolean allowDirty) {
        if (this.allStoredResourcesCache == null) {
            this.allStoredResourcesCache = new HashSet<AmountResource>();
        }
        if (this.allStoredResourcesCacheDirty && !allowDirty) {
            this.updateAllAmountResourcesStored();
        }
        return new HashSet<AmountResource>(this.allStoredResourcesCache);
    }

    private void updateAllAmountResourcesStored() {
        HashSet<AmountResource> tempResources = new HashSet<AmountResource>();
        if (this.typeStorage != null) {
            tempResources.addAll(this.typeStorage.getAllAmountResourcesStored());
        }
        if (this.phaseStorage != null) {
            for (Phase phase : Phase.getPhases()) {
                if (!(this.phaseStorage.getAmountResourcePhaseStored(phase) > 0.0)) continue;
                tempResources.add(this.phaseStorage.getAmountResourcePhaseType(phase));
            }
        }
        this.allStoredResourcesCache = tempResources;
        this.allStoredResourcesCacheDirty = false;
    }

    public double getTotalAmountResourcesStored(boolean allowDirty) {
        if (this.totalResourcesStoredDirty && !allowDirty) {
            this.updateTotalResourcesStored();
        }
        return this.totalResourcesStored;
    }

    private void updateTotalResourcesStored() {
        double tempTotalResources = 0.0;
        if (this.typeStorage != null) {
            tempTotalResources += this.typeStorage.getTotalAmountResourceTypesStored(false);
        }
        if (this.phaseStorage != null) {
            tempTotalResources += this.phaseStorage.getTotalAmountResourcePhasesStored(false);
        }
        this.totalResourcesStored = tempTotalResources;
        this.totalResourcesStoredDirty = false;
    }

    public double getAmountResourceRemainingCapacity(AmountResource resource) {
        double result = 0.0;
        if (this.hasAmountResourceCapacity(resource)) {
            result = this.getAmountResourceCapacity(resource) - this.getAmountResourceStored(resource);
        }
        return result;
    }

    public void storeAmountResource(AmountResource resource, double amount) {
        if (amount < 0.0) {
            throw new IllegalStateException("Cannot store negative amount of resource: " + amount);
        }
        if (amount > 0.0) {
            boolean storable = false;
            if (this.hasAmountResourceCapacity(resource) && this.getAmountResourceRemainingCapacity(resource) >= amount) {
                double remainingPhaseCapacity;
                double remainingTypeCapacity;
                double remainingAmount = amount;
                if (this.typeStorage != null && (remainingTypeCapacity = this.typeStorage.getAmountResourceTypeRemainingCapacity(resource)) > 0.0) {
                    double typeStore = remainingAmount;
                    if (typeStore > remainingTypeCapacity) {
                        typeStore = remainingTypeCapacity;
                    }
                    this.typeStorage.storeAmountResourceType(resource, typeStore);
                    remainingAmount -= typeStore;
                }
                if (this.phaseStorage != null && remainingAmount > 0.0 && (remainingPhaseCapacity = this.phaseStorage.getAmountResourcePhaseRemainingCapacity(resource.getPhase())) >= remainingAmount) {
                    AmountResource resourceTypeStored = this.phaseStorage.getAmountResourcePhaseType(resource.getPhase());
                    if (resourceTypeStored == null || resource.equals(resourceTypeStored)) {
                        this.phaseStorage.storeAmountResourcePhase(resource, remainingAmount);
                    }
                    remainingAmount = 0.0;
                }
                if (remainingAmount == 0.0) {
                    storable = true;
                    this.allStoredResourcesCacheDirty = true;
                    this.totalResourcesStoredDirty = true;
                } else {
                    logger.severe("Amount resource " + resource + " of amount: " + amount + " to store.  Amount remaining capacity: " + this.getAmountResourceRemainingCapacity(resource) + " remaining: " + remainingAmount);
                }
            }
            if (!storable) {
                throw new IllegalStateException("Amount resource: " + resource + " of amount: " + amount + " could not be stored in inventory.");
            }
        }
    }

    public void retrieveAmountResource(AmountResource resource, double amount) {
        if (amount < 0.0) {
            throw new IllegalStateException("Cannot retrieve negative amount of resource: " + amount);
        }
        boolean retrievable = false;
        double amountStored = this.getAmountResourceStored(resource);
        if (amountStored >= amount) {
            double remainingTypeStored;
            this.allStoredResourcesCacheDirty = true;
            this.totalResourcesStoredDirty = true;
            double remainingAmount = amount;
            if (this.phaseStorage != null) {
                AmountResource resourceTypeStored;
                double retrieveAmount = remainingAmount;
                double phaseStored = this.phaseStorage.getAmountResourcePhaseStored(resource.getPhase());
                if (retrieveAmount > phaseStored) {
                    retrieveAmount = phaseStored;
                }
                if (resource.equals(resourceTypeStored = this.phaseStorage.getAmountResourcePhaseType(resource.getPhase()))) {
                    this.phaseStorage.retrieveAmountResourcePhase(resource.getPhase(), retrieveAmount);
                }
                remainingAmount -= retrieveAmount;
            }
            if (this.typeStorage != null && remainingAmount > 0.0 && (remainingTypeStored = this.typeStorage.getAmountResourceTypeStored(resource)) >= remainingAmount) {
                this.typeStorage.retrieveAmountResourceType(resource, remainingAmount);
                remainingAmount = 0.0;
            }
            if (remainingAmount == 0.0) {
                retrievable = true;
            } else {
                logger.severe("Amount resource " + resource + " of amount: " + amount + " needed to retrieve.  Amount stored: " + amountStored + " remaining: " + remainingAmount);
            }
        } else {
            logger.severe("Amount resource " + resource + " of amount: " + amount + " needed to retrieve.  Amount stored: " + amountStored);
        }
        if (!retrievable) {
            throw new IllegalStateException("Amount resource: " + resource + " of amount: " + amount + " could not be retrieved from inventory.");
        }
    }

    public void destroy() {
        if (this.typeStorage != null) {
            this.typeStorage.destroy();
        }
        this.typeStorage = null;
        if (this.phaseStorage != null) {
            this.phaseStorage.destroy();
        }
        this.phaseStorage = null;
        if (this.allStoredResourcesCache != null) {
            this.allStoredResourcesCache.clear();
        }
        this.allStoredResourcesCache = null;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.allStoredResourcesCacheDirty = true;
        this.totalResourcesStoredDirty = true;
    }
}

