/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.resource;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.resource.Resource;

public class ItemResource
implements Resource,
Serializable {
    private String name;
    private double massPerItem;

    private ItemResource() {
        throw new UnsupportedOperationException("invalid constructor");
    }

    protected ItemResource(String name, double massPerItem) {
        this.name = name;
        this.massPerItem = massPerItem;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public double getMassPerItem() {
        return this.massPerItem;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ItemResource other = (ItemResource)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return Double.doubleToLongBits(this.massPerItem) == Double.doubleToLongBits(other.massPerItem);
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 19 * hash + (int)(Double.doubleToLongBits(this.massPerItem) ^ Double.doubleToLongBits(this.massPerItem) >>> 32);
        return hash;
    }

    public static ItemResource findItemResource(String name) {
        ItemResource result = null;
        for (ItemResource resource : ItemResource.getItemResources()) {
            if (!resource.name.equals(name)) continue;
            result = resource;
        }
        if (result != null) {
            return result;
        }
        throw new UnknownResourceName(name);
    }

    public static Set<ItemResource> getItemResources() {
        Set<ItemResource> resources = SimulationConfig.instance().getPartConfiguration().getItemResources();
        return Collections.unmodifiableSet(resources);
    }

    public static ItemResource createItemResource(String resourceName, double massPerItem) {
        return new ItemResource(resourceName, massPerItem);
    }

    @Override
    public int compareTo(Resource o) {
        return this.name.compareTo(o.getName());
    }

    private static class UnknownResourceName
    extends RuntimeException {
        private String name;

        public UnknownResourceName(String name) {
            super("Unknown resource name : " + name);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

