/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.resource;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.mars_sim.msp.core.resource.Part;

public class PartPackageConfig
implements Serializable {
    private static final String PART_PACKAGE = "part-package";
    private static final String PART = "part";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String NUMBER = "number";
    private Collection<PartPackage> partPackages = new ArrayList<PartPackage>();

    public PartPackageConfig(Document partPackageDoc) {
        this.loadPartPackages(partPackageDoc);
    }

    private void loadPartPackages(Document partPackageDoc) {
        Element root = partPackageDoc.getRootElement();
        List partPackageNodes = root.getChildren(PART_PACKAGE);
        for (Element partPackageElement : partPackageNodes) {
            PartPackage partPackage = new PartPackage();
            partPackage.name = partPackageElement.getAttributeValue(NAME);
            List partNodes = partPackageElement.getChildren(PART);
            for (Element partElement : partNodes) {
                String partType = partElement.getAttributeValue(TYPE);
                Part part = (Part)Part.findItemResource(partType);
                int partNumber = Integer.parseInt(partElement.getAttributeValue(NUMBER));
                partPackage.parts.put(part, partNumber);
            }
            this.partPackages.add(partPackage);
        }
    }

    public Map<Part, Integer> getPartsInPackage(String name) {
        HashMap<Part, Integer> result = null;
        PartPackage foundPartPackage = null;
        for (PartPackage partPackage : this.partPackages) {
            if (!partPackage.name.equals(name)) continue;
            foundPartPackage = partPackage;
            break;
        }
        if (foundPartPackage == null) {
            throw new IllegalStateException("name: " + name + " does not match any part packages.");
        }
        result = new HashMap<Part, Integer>(foundPartPackage.parts);
        return result;
    }

    public void destroy() {
        Iterator<PartPackage> i = this.partPackages.iterator();
        while (i.hasNext()) {
            i.next().parts.clear();
        }
        this.partPackages.clear();
    }

    private static class PartPackage
    implements Serializable {
        private String name;
        private Map<Part, Integer> parts = new HashMap<Part, Integer>();

        private PartPackage() {
        }
    }
}

