/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.science;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.social.Relationship;
import org.mars_sim.msp.core.person.ai.social.RelationshipManager;
import org.mars_sim.msp.core.science.Science;
import org.mars_sim.msp.core.science.ScienceUtil;
import org.mars_sim.msp.core.science.ScientificStudy;
import org.mars_sim.msp.core.structure.Settlement;

public class ScientificStudyUtil {
    private ScientificStudyUtil() {
    }

    public static List<Person> getAvailableCollaboratorsForInvite(ScientificStudy study) {
        ArrayList<Person> result = new ArrayList<Person>();
        Collection<Person> allPeople = Simulation.instance().getUnitManager().getPeople();
        for (Person person : allPeople) {
            Science jobScience;
            Job job;
            boolean available = false;
            if (!person.equals(study.getPrimaryResearcher()) && !study.hasResearcherBeenInvited(person) && (job = person.getMind().getJob()) != null && (jobScience = ScienceUtil.getAssociatedScience(job)) != null) {
                if (jobScience.equals(study.getScience())) {
                    available = true;
                } else if (ScienceUtil.isCollaborativeScience(study.getScience(), jobScience)) {
                    available = true;
                }
            }
            if (person.getPhysicalCondition().isDead()) {
                available = false;
            }
            if (!available) continue;
            result.add(person);
        }
        return result;
    }

    static boolean determinePeerReviewResults(ScientificStudy study) {
        double baseChance = 50.0;
        int academicAptitude = study.getPrimaryResearcher().getNaturalAttributeManager().getAttribute("Academic Aptitude");
        double academicAptitudeModifier = (double)(academicAptitude - 50) / 2.0;
        baseChance += academicAptitudeModifier;
        for (Person researcher : study.getCollaborativeResearchers().keySet()) {
            double collaboratorModifier = 10.0;
            Science collaborativeScience = study.getCollaborativeResearchers().get(researcher);
            String skillName = ScienceUtil.getAssociatedSkill(collaborativeScience);
            int skillLevel = researcher.getMind().getSkillManager().getSkillLevel(skillName);
            collaboratorModifier *= (double)skillLevel / (double)study.getDifficultyLevel();
            int collaboratorAcademicAptitude = researcher.getNaturalAttributeManager().getAttribute("Academic Aptitude");
            double collaboratorAcademicAptitudeModifier = (double)(collaboratorAcademicAptitude - 50) / 10.0;
            collaboratorModifier += collaboratorAcademicAptitudeModifier;
            if (!collaborativeScience.equals(study.getScience())) {
                collaboratorModifier /= 2.0;
            }
            baseChance += collaboratorModifier;
        }
        return RandomUtil.getRandomDouble(100.0) < baseChance;
    }

    static void provideCompletionAchievements(ScientificStudy study) {
        double baseAchievement = study.getDifficultyLevel();
        Science primaryScience = study.getScience();
        Person primaryResearcher = study.getPrimaryResearcher();
        primaryResearcher.addScientificAchievement(baseAchievement, primaryScience);
        study.setPrimaryResearchEarnedScientificAchievement(baseAchievement);
        ScientificStudyUtil.modifyScientistRelationshipsFromAchievement(primaryResearcher, primaryScience, baseAchievement);
        Settlement primarySettlement = study.getPrimarySettlement();
        primarySettlement.addScientificAchievement(baseAchievement, primaryScience);
        double collaborativeAchievement = baseAchievement / 3.0;
        for (Person researcher : study.getCollaborativeResearchers().keySet()) {
            Science collaborativeScience = study.getCollaborativeResearchers().get(researcher);
            researcher.addScientificAchievement(collaborativeAchievement, collaborativeScience);
            study.setCollaborativeResearcherEarnedScientificAchievement(researcher, collaborativeAchievement);
            ScientificStudyUtil.modifyScientistRelationshipsFromAchievement(researcher, collaborativeScience, collaborativeAchievement);
            Settlement collaboratorSettlement = researcher.getAssociatedSettlement();
            if (collaboratorSettlement == null) continue;
            collaboratorSettlement.addScientificAchievement(collaborativeAchievement, collaborativeScience);
        }
    }

    private static void modifyScientistRelationshipsFromAchievement(Person researcher, Science science, double achievement) {
        RelationshipManager manager = Simulation.instance().getRelationshipManager();
        for (Person person : manager.getAllKnownPeople(researcher)) {
            Relationship relationship;
            if (!science.equals(ScienceUtil.getAssociatedScience(person.getMind().getJob())) || (relationship = manager.getRelationship(researcher, person)) == null) continue;
            double currentOpinion = relationship.getPersonOpinion(person);
            relationship.setPersonOpinion(person, currentOpinion + achievement);
        }
    }
}

