/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.building.function.PowerGeneration;
import org.mars_sim.msp.core.structure.building.function.PowerStorage;
import org.mars_sim.msp.core.time.MarsClock;

public class PowerGrid
implements Serializable {
    private static String CLASS_NAME = "org.mars_sim.msp.simulation.structure.PowerGrid";
    private static Logger logger = Logger.getLogger(CLASS_NAME);
    public static final String POWER_MODE_EVENT = "power mode";
    public static final String GENERATED_POWER_EVENT = "generated power";
    public static final String STORED_POWER_EVENT = "stored power";
    public static final String STORED_POWER_CAPACITY_EVENT = "stored power capacity";
    public static final String REQUIRED_POWER_EVENT = "required power";
    public static final String POWER_VALUE_EVENT = "power value";
    public static final String POWER_UP_MODE = "Power up";
    public static final String POWER_DOWN_MODE = "Power down";
    private String powerMode;
    private double powerGenerated;
    private double powerStored;
    private double powerStorageCapacity;
    private double powerRequired;
    private boolean sufficientPower;
    private Settlement settlement;
    private double powerValue;

    public PowerGrid(Settlement settlement) {
        this.settlement = settlement;
        this.powerMode = POWER_UP_MODE;
        this.powerGenerated = 0.0;
        this.powerStored = 0.0;
        this.powerStorageCapacity = 0.0;
        this.powerRequired = 0.0;
        this.sufficientPower = true;
    }

    public String getPowerMode() {
        return this.powerMode;
    }

    public void setPowerMode(String newPowerMode) {
        if (!this.powerMode.equals(newPowerMode)) {
            if (POWER_UP_MODE.equals(newPowerMode)) {
                this.powerMode = POWER_UP_MODE;
            } else if (POWER_DOWN_MODE.equals(newPowerMode)) {
                this.powerMode = POWER_DOWN_MODE;
            }
            this.settlement.fireUnitUpdate(POWER_MODE_EVENT);
        }
    }

    public double getGeneratedPower() {
        return this.powerGenerated;
    }

    private void setGeneratedPower(double newGeneratedPower) {
        if (this.powerGenerated != newGeneratedPower) {
            this.powerGenerated = newGeneratedPower;
            this.settlement.fireUnitUpdate(GENERATED_POWER_EVENT);
        }
    }

    public double getStoredPower() {
        return this.powerStored;
    }

    public void setStoredPower(double newPowerStored) {
        if (this.powerStored != newPowerStored) {
            this.powerStored = newPowerStored;
            this.settlement.fireUnitUpdate(STORED_POWER_EVENT);
        }
    }

    public double getStoredPowerCapacity() {
        return this.powerStorageCapacity;
    }

    public void setStoredPowerCapacity(double newPowerStorageCapacity) {
        if (this.powerStorageCapacity != newPowerStorageCapacity) {
            this.powerStorageCapacity = newPowerStorageCapacity;
            this.settlement.fireUnitUpdate(STORED_POWER_CAPACITY_EVENT);
        }
    }

    public double getRequiredPower() {
        return this.powerRequired;
    }

    private void setRequiredPower(double newRequiredPower) {
        if (this.powerRequired != newRequiredPower) {
            this.powerRequired = newRequiredPower;
            this.settlement.fireUnitUpdate(REQUIRED_POWER_EVENT);
        }
    }

    public boolean isSufficientPower() {
        return this.sufficientPower;
    }

    public void timePassing(double time) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.settlement.getName() + " power situation: ");
        }
        this.updateTotalPowerGenerated();
        this.updateTotalStoredPower();
        this.updateTotalPowerStorageCapacity();
        this.updateTotalRequiredPower();
        if (this.powerRequired <= this.powerGenerated) {
            this.sufficientPower = true;
            double timeHr = MarsClock.convertMillisolsToSeconds(time) / 60.0 / 60.0;
            double excessPower = (this.powerGenerated - this.powerRequired) * timeHr;
            this.storeExcessPower(excessPower);
        } else {
            Iterator<Building> iNoPower;
            Building building;
            this.sufficientPower = false;
            double neededPower = this.powerRequired - this.powerGenerated;
            double timeHr = MarsClock.convertMillisolsToSeconds(time) / 60.0 / 60.0;
            double neededPowerHr = neededPower * timeHr;
            neededPowerHr = this.retrieveStoredPower(neededPowerHr);
            neededPower = neededPowerHr / timeHr;
            BuildingManager manager = this.settlement.getBuildingManager();
            List<Building> buildings = manager.getBuildings();
            if (!this.powerMode.equals(POWER_DOWN_MODE)) {
                Iterator<Building> iLowPower = buildings.iterator();
                while (iLowPower.hasNext() && neededPower > 0.0) {
                    building = iLowPower.next();
                    if (this.powerSurplus(building, "Full Power")) continue;
                    building.setPowerMode("Power Down");
                    neededPower -= building.getFullPowerRequired() - building.getPoweredDownPowerRequired();
                }
            }
            if (neededPower > 0.0) {
                iNoPower = buildings.iterator();
                while (iNoPower.hasNext() && neededPower > 0.0) {
                    building = iNoPower.next();
                    if (this.powerSurplus(building, "Power Down") || building.hasFunction("Life Support")) continue;
                    building.setPowerMode("No Power");
                    neededPower -= building.getPoweredDownPowerRequired();
                }
            }
            if (neededPower > 0.0) {
                iNoPower = buildings.iterator();
                while (iNoPower.hasNext() && neededPower > 0.0) {
                    building = iNoPower.next();
                    if (this.powerSurplus(building, "Power Down") || !building.hasFunction("Life Support")) continue;
                    building.setPowerMode("No Power");
                    neededPower -= building.getPoweredDownPowerRequired();
                }
            }
        }
        this.determinePowerValue();
    }

    private void updateTotalPowerGenerated() {
        double tempPowerGenerated = 0.0;
        BuildingManager manager = this.settlement.getBuildingManager();
        for (Building building : manager.getBuildings("Power Generation")) {
            PowerGeneration gen = (PowerGeneration)building.getFunction("Power Generation");
            tempPowerGenerated += gen.getGeneratedPower();
        }
        this.setGeneratedPower(tempPowerGenerated);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Total power generated: " + this.powerGenerated);
        }
    }

    private void updateTotalStoredPower() {
        double tempPowerStored = 0.0;
        BuildingManager manager = this.settlement.getBuildingManager();
        for (Building building : manager.getBuildings("Power Storage")) {
            PowerStorage store = (PowerStorage)building.getFunction("Power Storage");
            tempPowerStored += store.getPowerStored();
        }
        this.setStoredPower(tempPowerStored);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Total power stored: " + this.powerStored);
        }
    }

    private void updateTotalRequiredPower() {
        double tempPowerRequired = 0.0;
        boolean powerUp = this.powerMode.equals(POWER_UP_MODE);
        BuildingManager manager = this.settlement.getBuildingManager();
        List<Building> buildings = manager.getBuildings();
        for (Building building : buildings) {
            if (powerUp) {
                building.setPowerMode("Full Power");
                tempPowerRequired += building.getFullPowerRequired();
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.fine(building.getName() + " full power used: " + building.getFullPowerRequired());
                continue;
            }
            building.setPowerMode("Power Down");
            tempPowerRequired += building.getPoweredDownPowerRequired();
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine(building.getName() + " power down power used: " + building.getPoweredDownPowerRequired());
        }
        this.setRequiredPower(tempPowerRequired);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Total power required: " + this.powerRequired);
        }
    }

    private void updateTotalPowerStorageCapacity() {
        double tempPowerStorageCapacity = 0.0;
        BuildingManager manager = this.settlement.getBuildingManager();
        for (Building building : manager.getBuildings("Power Storage")) {
            PowerStorage store = (PowerStorage)building.getFunction("Power Storage");
            tempPowerStorageCapacity += store.getPowerStorageCapacity();
        }
        this.setStoredPowerCapacity(tempPowerStorageCapacity);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Total power storage capacity: " + this.powerStorageCapacity);
        }
    }

    private boolean powerSurplus(Building building, String mode) {
        double generated = 0.0;
        if (building.hasFunction("Power Generation")) {
            PowerGeneration powerGeneration = (PowerGeneration)building.getFunction("Power Generation");
            generated = powerGeneration.getGeneratedPower();
        }
        double used = 0.0;
        if (mode.equals("Full Power")) {
            used = building.getFullPowerRequired();
        } else if (mode.equals("Power Down")) {
            used = building.getPoweredDownPowerRequired();
        }
        return generated > used;
    }

    private void storeExcessPower(double excessPower) {
        BuildingManager manager = this.settlement.getBuildingManager();
        for (Building building : manager.getBuildings("Power Storage")) {
            PowerStorage storage = (PowerStorage)building.getFunction("Power Storage");
            double remainingCapacity = storage.getPowerStorageCapacity() - storage.getPowerStored();
            if (!(remainingCapacity > 0.0)) continue;
            double powerToStore = excessPower;
            if (remainingCapacity < powerToStore) {
                powerToStore = remainingCapacity;
            }
            storage.setPowerStored(storage.getPowerStored() + powerToStore);
            excessPower -= powerToStore;
        }
    }

    private double retrieveStoredPower(double neededPower) {
        BuildingManager manager = this.settlement.getBuildingManager();
        for (Building building : manager.getBuildings("Power Storage")) {
            PowerStorage storage = (PowerStorage)building.getFunction("Power Storage");
            if (!(storage.getPowerStored() > 0.0) || !(neededPower > 0.0)) continue;
            double retrievedPower = neededPower;
            if (storage.getPowerStored() < retrievedPower) {
                retrievedPower = storage.getPowerStored();
            }
            storage.setPowerStored(storage.getPowerStored() - retrievedPower);
            neededPower -= retrievedPower;
        }
        return neededPower;
    }

    public double getPowerValue() {
        return this.powerValue;
    }

    private void determinePowerValue() {
        double demand = this.powerRequired;
        double supply = this.powerGenerated + this.powerStored / 2.0;
        double newPowerValue = demand / (supply + 1.0);
        if (newPowerValue != this.powerValue) {
            this.powerValue = newPowerValue;
            this.settlement.fireUnitUpdate(POWER_VALUE_EVENT);
        }
    }

    public void destroy() {
        this.powerMode = null;
        this.settlement = null;
    }
}

