/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.mars_sim.msp.core.interplanetary.transport.resupply.ResupplyMissionTemplate;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.resource.PartPackageConfig;
import org.mars_sim.msp.core.structure.BuildingTemplate;
import org.mars_sim.msp.core.structure.SettlementTemplate;

public class SettlementConfig
implements Serializable {
    private static final String SETTLEMENT_TEMPLATE_LIST = "settlement-template-list";
    private static final String TEMPLATE = "template";
    private static final String NAME = "name";
    private static final String DEFAULT_POPULATION = "default-population";
    private static final String BUILDING = "building";
    private static final String TYPE = "type";
    private static final String X_LOCATION = "x-location";
    private static final String Y_LOCATION = "y-location";
    private static final String FACING = "facing";
    private static final String NUMBER = "number";
    private static final String VEHICLE = "vehicle";
    private static final String EQUIPMENT = "equipment";
    private static final String INITIAL_SETTLEMENT_LIST = "initial-settlement-list";
    private static final String SETTLEMENT = "settlement";
    private static final String LOCATION = "location";
    private static final String LONGITUDE = "longitude";
    private static final String LATITUDE = "latitude";
    private static final String POPULATION = "population";
    private static final String SETTLEMENT_NAME_LIST = "settlement-name-list";
    private static final String SETTLEMENT_NAME = "settlement-name";
    private static final String VALUE = "value";
    private static final String RESUPPLY = "resupply";
    private static final String RESUPPLY_MISSION = "resupply-mission";
    private static final String ARRIVAL_TIME = "arrival-time";
    private static final String RESOURCE = "resource";
    private static final String AMOUNT = "amount";
    private static final String PART = "part";
    private static final String PART_PACKAGE = "part-package";
    private static final String NEW_ARRIVING_SETTLEMENT_LIST = "new-arriving-settlement-list";
    private static final String ARRIVING_SETTLEMENT = "arriving-settlement";
    public static final String RANDOM = "random";
    private Collection<SettlementTemplate> settlementTemplates = new ArrayList<SettlementTemplate>();
    private List<InitialSettlement> initialSettlements = new ArrayList<InitialSettlement>();
    private List<NewArrivingSettlement> newArrivingSettlements = new ArrayList<NewArrivingSettlement>();
    private List<String> settlementNames = new ArrayList<String>();

    public SettlementConfig(Document settlementDoc, PartPackageConfig partPackageConfig) {
        this.loadSettlementTemplates(settlementDoc, partPackageConfig);
        this.loadInitialSettlements(settlementDoc);
        this.loadNewArrivingSettlements(settlementDoc);
        this.loadSettlementNames(settlementDoc);
    }

    private void loadSettlementTemplates(Document settlementDoc, PartPackageConfig partPackageConfig) {
        Element root = settlementDoc.getRootElement();
        Element templateList = root.getChild(SETTLEMENT_TEMPLATE_LIST);
        List templateNodes = templateList.getChildren(TEMPLATE);
        for (Element templateElement : templateNodes) {
            String name = templateElement.getAttributeValue(NAME);
            int defaultPopulation = Integer.parseInt(templateElement.getAttributeValue(DEFAULT_POPULATION));
            SettlementTemplate template = new SettlementTemplate(name, defaultPopulation);
            this.settlementTemplates.add(template);
            List buildingNodes = templateElement.getChildren(BUILDING);
            for (Element buildingElement : buildingNodes) {
                String buildingType = buildingElement.getAttributeValue(TYPE);
                double xLoc = Double.parseDouble(buildingElement.getAttributeValue(X_LOCATION));
                double yLoc = Double.parseDouble(buildingElement.getAttributeValue(Y_LOCATION));
                double facing = Double.parseDouble(buildingElement.getAttributeValue(FACING));
                template.addBuildingTemplate(new BuildingTemplate(buildingType, xLoc, yLoc, facing));
            }
            List vehicleNodes = templateElement.getChildren(VEHICLE);
            for (Element vehicleElement : vehicleNodes) {
                String vehicleType = vehicleElement.getAttributeValue(TYPE);
                int vehicleNumber = Integer.parseInt(vehicleElement.getAttributeValue(NUMBER));
                template.addVehicles(vehicleType, vehicleNumber);
            }
            List equipmentNodes = templateElement.getChildren(EQUIPMENT);
            for (Element equipmentElement : equipmentNodes) {
                String equipmentType = equipmentElement.getAttributeValue(TYPE);
                int equipmentNumber = Integer.parseInt(equipmentElement.getAttributeValue(NUMBER));
                template.addEquipment(equipmentType, equipmentNumber);
            }
            List resourceNodes = templateElement.getChildren(RESOURCE);
            for (Element resourceElement : resourceNodes) {
                String resourceType = resourceElement.getAttributeValue(TYPE);
                AmountResource resource = AmountResource.findAmountResource(resourceType);
                double resourceAmount = Double.parseDouble(resourceElement.getAttributeValue(AMOUNT));
                template.addAmountResource(resource, resourceAmount);
            }
            List partNodes = templateElement.getChildren(PART);
            for (Element partElement : partNodes) {
                String partType = partElement.getAttributeValue(TYPE);
                Part part = (Part)Part.findItemResource(partType);
                int partNumber = Integer.parseInt(partElement.getAttributeValue(NUMBER));
                template.addPart(part, partNumber);
            }
            List partPackageNodes = templateElement.getChildren(PART_PACKAGE);
            for (Element partPackageElement : partPackageNodes) {
                String packageName = partPackageElement.getAttributeValue(NAME);
                int packageNumber = Integer.parseInt(partPackageElement.getAttributeValue(NUMBER));
                if (packageNumber <= 0) continue;
                for (int z = 0; z < packageNumber; ++z) {
                    Map<Part, Integer> partPackage = partPackageConfig.getPartsInPackage(packageName);
                    for (Part part : partPackage.keySet()) {
                        int partNumber = partPackage.get(part);
                        template.addPart(part, partNumber);
                    }
                }
            }
            Element resupplyList = templateElement.getChild(RESUPPLY);
            if (resupplyList == null) continue;
            List resupplyNodes = resupplyList.getChildren(RESUPPLY_MISSION);
            for (Element resupplyMissionElement : resupplyNodes) {
                String resupplyName = resupplyMissionElement.getAttributeValue(NAME);
                double arrivalTime = Double.parseDouble(resupplyMissionElement.getAttributeValue(ARRIVAL_TIME));
                ResupplyMissionTemplate resupplyMissionTemplate = new ResupplyMissionTemplate(resupplyName, arrivalTime);
                template.addResupplyMissionTemplate(resupplyMissionTemplate);
            }
        }
    }

    private void loadInitialSettlements(Document settlementDoc) {
        Element root = settlementDoc.getRootElement();
        Element initialSettlementList = root.getChild(INITIAL_SETTLEMENT_LIST);
        List settlementNodes = initialSettlementList.getChildren(SETTLEMENT);
        for (Element settlementElement : settlementNodes) {
            InitialSettlement initialSettlement = new InitialSettlement();
            String settlementName = settlementElement.getAttributeValue(NAME);
            if (settlementName.equals(RANDOM)) {
                initialSettlement.randomName = true;
            } else {
                initialSettlement.name = settlementName;
            }
            initialSettlement.template = settlementElement.getAttributeValue(TEMPLATE);
            List locationNodes = settlementElement.getChildren(LOCATION);
            if (locationNodes.size() > 0) {
                Element locationElement = (Element)locationNodes.get(0);
                String longitudeString = locationElement.getAttributeValue(LONGITUDE);
                if (longitudeString.equals(RANDOM)) {
                    initialSettlement.randomLongitude = true;
                } else {
                    initialSettlement.longitude = longitudeString;
                }
                String latitudeString = locationElement.getAttributeValue(LATITUDE);
                if (latitudeString.equals(RANDOM)) {
                    initialSettlement.randomLatitude = true;
                } else {
                    initialSettlement.latitude = latitudeString;
                }
            } else {
                initialSettlement.randomLongitude = true;
                initialSettlement.randomLatitude = true;
            }
            Element populationElement = settlementElement.getChild(POPULATION);
            String numberStr = populationElement.getAttributeValue(NUMBER);
            int number = Integer.parseInt(numberStr);
            if (number < 0) {
                throw new IllegalStateException("populationNumber cannot be less than zero: " + number);
            }
            initialSettlement.populationNumber = number;
            this.initialSettlements.add(initialSettlement);
        }
    }

    private void loadNewArrivingSettlements(Document settlementDoc) {
        Element root = settlementDoc.getRootElement();
        Element arrivingSettlementList = root.getChild(NEW_ARRIVING_SETTLEMENT_LIST);
        List settlementNodes = arrivingSettlementList.getChildren(ARRIVING_SETTLEMENT);
        for (Element settlementElement : settlementNodes) {
            NewArrivingSettlement arrivingSettlement = new NewArrivingSettlement();
            String settlementName = settlementElement.getAttributeValue(NAME);
            if (settlementName.equals(RANDOM)) {
                arrivingSettlement.randomName = true;
            } else {
                arrivingSettlement.name = settlementName;
            }
            arrivingSettlement.template = settlementElement.getAttributeValue(TEMPLATE);
            arrivingSettlement.arrivalTime = Double.parseDouble(settlementElement.getAttributeValue(ARRIVAL_TIME));
            List locationNodes = settlementElement.getChildren(LOCATION);
            if (locationNodes.size() > 0) {
                Element locationElement = (Element)locationNodes.get(0);
                String longitudeString = locationElement.getAttributeValue(LONGITUDE);
                if (longitudeString.equals(RANDOM)) {
                    arrivingSettlement.randomLongitude = true;
                } else {
                    arrivingSettlement.longitude = longitudeString;
                }
                String latitudeString = locationElement.getAttributeValue(LATITUDE);
                if (latitudeString.equals(RANDOM)) {
                    arrivingSettlement.randomLatitude = true;
                } else {
                    arrivingSettlement.latitude = latitudeString;
                }
            } else {
                arrivingSettlement.randomLongitude = true;
                arrivingSettlement.randomLatitude = true;
            }
            Element populationElement = settlementElement.getChild(POPULATION);
            String numberStr = populationElement.getAttributeValue(NUMBER);
            int number = Integer.parseInt(numberStr);
            if (number < 0) {
                throw new IllegalStateException("populationNumber cannot be less than zero: " + number);
            }
            arrivingSettlement.populationNumber = number;
            this.newArrivingSettlements.add(arrivingSettlement);
        }
    }

    private void loadSettlementNames(Document settlementDoc) {
        Element root = settlementDoc.getRootElement();
        Element settlementNameList = root.getChild(SETTLEMENT_NAME_LIST);
        List settlementNameNodes = settlementNameList.getChildren(SETTLEMENT_NAME);
        for (Element settlementNameElement : settlementNameNodes) {
            this.settlementNames.add(settlementNameElement.getAttributeValue(VALUE));
        }
    }

    public SettlementTemplate getSettlementTemplate(String templateName) {
        SettlementTemplate result = null;
        for (SettlementTemplate template : this.settlementTemplates) {
            if (!template.getTemplateName().equals(templateName)) continue;
            result = template;
        }
        if (result == null) {
            throw new IllegalArgumentException("templateName: " + templateName + " not found.");
        }
        return result;
    }

    public List<SettlementTemplate> getSettlementTemplates() {
        return new ArrayList<SettlementTemplate>(this.settlementTemplates);
    }

    public int getNumberOfNewArrivingSettlements() {
        return this.newArrivingSettlements.size();
    }

    public String getNewArrivingSettlementName(int index) {
        if (index >= 0 && index < this.newArrivingSettlements.size()) {
            NewArrivingSettlement settlement = this.newArrivingSettlements.get(index);
            if (settlement.randomName) {
                return RANDOM;
            }
            return settlement.name;
        }
        throw new IllegalArgumentException("index: " + index + "is out of bounds");
    }

    public String getNewArrivingSettlementTemplate(int index) {
        if (index >= 0 && index < this.newArrivingSettlements.size()) {
            return this.newArrivingSettlements.get(index).template;
        }
        throw new IllegalArgumentException("index: " + index + "is out of bounds");
    }

    public double getNewArrivingSettlementArrivalTime(int index) {
        if (index >= 0 && index < this.newArrivingSettlements.size()) {
            return this.newArrivingSettlements.get(index).arrivalTime;
        }
        throw new IllegalArgumentException("index: " + index + "is out of bounds");
    }

    public String getNewArrivingSettlementLongitude(int index) {
        if (index >= 0 && index < this.newArrivingSettlements.size()) {
            NewArrivingSettlement settlement = this.newArrivingSettlements.get(index);
            if (settlement.randomLongitude) {
                return RANDOM;
            }
            return settlement.longitude;
        }
        throw new IllegalArgumentException("index: " + index + "is out of bounds");
    }

    public String getNewArrivingSettlementLatitude(int index) {
        if (index >= 0 && index < this.newArrivingSettlements.size()) {
            NewArrivingSettlement settlement = this.newArrivingSettlements.get(index);
            if (settlement.randomLatitude) {
                return RANDOM;
            }
            return settlement.latitude;
        }
        throw new IllegalArgumentException("index: " + index + "is out of bounds");
    }

    public int getNewArrivingSettlementPopulationNumber(int index) {
        if (index >= 0 && index < this.newArrivingSettlements.size()) {
            NewArrivingSettlement settlement = this.newArrivingSettlements.get(index);
            return settlement.populationNumber;
        }
        throw new IllegalArgumentException("index: " + index + "is out of bounds");
    }

    public int getNumberOfInitialSettlements() {
        return this.initialSettlements.size();
    }

    public String getInitialSettlementName(int index) {
        if (index >= 0 && index < this.initialSettlements.size()) {
            InitialSettlement settlement = this.initialSettlements.get(index);
            if (settlement.randomName) {
                return RANDOM;
            }
            return settlement.name;
        }
        throw new IllegalArgumentException("index: " + index + "is out of bounds");
    }

    public String getInitialSettlementTemplate(int index) {
        if (index >= 0 && index < this.initialSettlements.size()) {
            return this.initialSettlements.get(index).template;
        }
        throw new IllegalArgumentException("index: " + index + "is out of bounds");
    }

    public String getInitialSettlementLongitude(int index) {
        if (index >= 0 && index < this.initialSettlements.size()) {
            InitialSettlement settlement = this.initialSettlements.get(index);
            if (settlement.randomLongitude) {
                return RANDOM;
            }
            return settlement.longitude;
        }
        throw new IllegalArgumentException("index: " + index + "is out of bounds");
    }

    public String getInitialSettlementLatitude(int index) {
        if (index >= 0 && index < this.initialSettlements.size()) {
            InitialSettlement settlement = this.initialSettlements.get(index);
            if (settlement.randomLatitude) {
                return RANDOM;
            }
            return settlement.latitude;
        }
        throw new IllegalArgumentException("index: " + index + "is out of bounds");
    }

    public int getInitialSettlementPopulationNumber(int index) {
        if (index >= 0 && index < this.initialSettlements.size()) {
            InitialSettlement settlement = this.initialSettlements.get(index);
            return settlement.populationNumber;
        }
        throw new IllegalArgumentException("index: " + index + "is out of bounds");
    }

    public List<String> getSettlementNameList() {
        return new ArrayList<String>(this.settlementNames);
    }

    public void clearInitialSettlements() {
        this.initialSettlements.clear();
    }

    public void addInitialSettlement(String name, String template, int populationNum, String latitude, String longitude) {
        InitialSettlement settlement = new InitialSettlement();
        settlement.name = name;
        settlement.template = template;
        settlement.populationNumber = populationNum;
        settlement.latitude = latitude;
        settlement.longitude = longitude;
        this.initialSettlements.add(settlement);
    }

    public void destroy() {
        Iterator<SettlementTemplate> i = this.settlementTemplates.iterator();
        while (i.hasNext()) {
            i.next().destroy();
        }
        this.settlementTemplates.clear();
        this.settlementTemplates = null;
        this.initialSettlements.clear();
        this.initialSettlements = null;
        this.settlementNames.clear();
        this.settlementNames = null;
    }

    private static class NewArrivingSettlement
    implements Serializable {
        private String name;
        private boolean randomName = false;
        private String template;
        private double arrivalTime;
        private String longitude;
        private boolean randomLongitude = false;
        private String latitude;
        private boolean randomLatitude = false;
        private int populationNumber;

        private NewArrivingSettlement() {
        }
    }

    private static class InitialSettlement
    implements Serializable {
        private String name;
        private boolean randomName = false;
        private String template;
        private String longitude;
        private boolean randomLongitude = false;
        private String latitude;
        private boolean randomLatitude = false;
        private int populationNumber;

        private InitialSettlement() {
        }
    }
}

