/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.building;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.LocalBoundedObject;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.malfunction.MalfunctionManager;
import org.mars_sim.msp.core.malfunction.Malfunctionable;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.task.Maintenance;
import org.mars_sim.msp.core.person.ai.task.Repair;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.structure.BuildingTemplate;
import org.mars_sim.msp.core.structure.building.BuildingConfig;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.building.function.AstronomicalObservation;
import org.mars_sim.msp.core.structure.building.function.Communication;
import org.mars_sim.msp.core.structure.building.function.Cooking;
import org.mars_sim.msp.core.structure.building.function.Dining;
import org.mars_sim.msp.core.structure.building.function.EVA;
import org.mars_sim.msp.core.structure.building.function.EarthReturn;
import org.mars_sim.msp.core.structure.building.function.Exercise;
import org.mars_sim.msp.core.structure.building.function.Farming;
import org.mars_sim.msp.core.structure.building.function.Function;
import org.mars_sim.msp.core.structure.building.function.GroundVehicleMaintenance;
import org.mars_sim.msp.core.structure.building.function.LifeSupport;
import org.mars_sim.msp.core.structure.building.function.LivingAccommodations;
import org.mars_sim.msp.core.structure.building.function.Management;
import org.mars_sim.msp.core.structure.building.function.Manufacture;
import org.mars_sim.msp.core.structure.building.function.MedicalCare;
import org.mars_sim.msp.core.structure.building.function.PowerGeneration;
import org.mars_sim.msp.core.structure.building.function.PowerStorage;
import org.mars_sim.msp.core.structure.building.function.Recreation;
import org.mars_sim.msp.core.structure.building.function.Research;
import org.mars_sim.msp.core.structure.building.function.ResourceProcessing;
import org.mars_sim.msp.core.structure.building.function.Storage;

public class Building
implements Malfunctionable,
Serializable,
Comparable<Building>,
LocalBoundedObject {
    public static final String FULL_POWER = "Full Power";
    public static final String POWER_DOWN = "Power Down";
    public static final String NO_POWER = "No Power";
    private static final double WEAR_LIFETIME = 3340000.0;
    private static final double MAINTENANCE_TIME = 500.0;
    protected BuildingManager manager;
    protected String name;
    protected double width;
    protected double length;
    protected double xLoc;
    protected double yLoc;
    protected double facing;
    protected String powerMode;
    protected MalfunctionManager malfunctionManager;
    protected List<Function> functions;
    protected double basePowerRequirement;
    protected double basePowerDownPowerRequirement;

    public Building(BuildingTemplate template, BuildingManager manager) {
        this(template.getType(), template.getXLoc(), template.getYLoc(), template.getFacing(), manager);
    }

    public Building(String name, double xLoc, double yLoc, double facing, BuildingManager manager) {
        this.name = name;
        this.manager = manager;
        this.powerMode = FULL_POWER;
        this.xLoc = xLoc;
        this.yLoc = yLoc;
        this.facing = facing;
        this.functions = this.determineFunctions();
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        this.basePowerRequirement = config.getBasePowerRequirement(name);
        this.basePowerDownPowerRequirement = config.getBasePowerDownPowerRequirement(name);
        this.width = config.getWidth(name);
        this.length = config.getLength(name);
        this.malfunctionManager = new MalfunctionManager(this, 3340000.0, 500.0);
        this.malfunctionManager.addScopeString("Building");
        for (Function function : this.functions) {
            for (int x = 0; x < function.getMalfunctionScopeStrings().length; ++x) {
                this.malfunctionManager.addScopeString(function.getMalfunctionScopeStrings()[x]);
            }
        }
    }

    protected Building() {
    }

    private List<Function> determineFunctions() {
        ArrayList<Function> buildingFunctions = new ArrayList<Function>();
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        if (config.hasPowerGeneration(this.name)) {
            buildingFunctions.add(new PowerGeneration(this));
        }
        if (config.hasLifeSupport(this.name)) {
            buildingFunctions.add(new LifeSupport(this));
        }
        if (config.hasLivingAccommodations(this.name)) {
            buildingFunctions.add(new LivingAccommodations(this));
        }
        if (config.hasResearchLab(this.name)) {
            buildingFunctions.add(new Research(this));
        }
        if (config.hasCommunication(this.name)) {
            buildingFunctions.add(new Communication(this));
        }
        if (config.hasEVA(this.name)) {
            buildingFunctions.add(new EVA(this));
        }
        if (config.hasRecreation(this.name)) {
            buildingFunctions.add(new Recreation(this));
        }
        if (config.hasDining(this.name)) {
            buildingFunctions.add(new Dining(this));
        }
        if (config.hasResourceProcessing(this.name)) {
            buildingFunctions.add(new ResourceProcessing(this));
        }
        if (config.hasStorage(this.name)) {
            buildingFunctions.add(new Storage(this));
        }
        if (config.hasMedicalCare(this.name)) {
            buildingFunctions.add(new MedicalCare(this));
        }
        if (config.hasFarming(this.name)) {
            buildingFunctions.add(new Farming(this));
        }
        if (config.hasExercise(this.name)) {
            buildingFunctions.add(new Exercise(this));
        }
        if (config.hasGroundVehicleMaintenance(this.name)) {
            buildingFunctions.add(new GroundVehicleMaintenance(this));
        }
        if (config.hasCooking(this.name)) {
            buildingFunctions.add(new Cooking(this));
        }
        if (config.hasManufacture(this.name)) {
            buildingFunctions.add(new Manufacture(this));
        }
        if (config.hasPowerStorage(this.name)) {
            buildingFunctions.add(new PowerStorage(this));
        }
        if (config.hasAstronomicalObservation(this.name)) {
            buildingFunctions.add(new AstronomicalObservation(this));
        }
        if (config.hasManagement(this.name)) {
            buildingFunctions.add(new Management(this));
        }
        if (config.hasEarthReturn(this.name)) {
            buildingFunctions.add(new EarthReturn(this));
        }
        return buildingFunctions;
    }

    public boolean hasFunction(String functionName) {
        boolean result = false;
        Iterator<Function> i = this.functions.iterator();
        while (i.hasNext()) {
            if (!i.next().getName().equals(functionName)) continue;
            result = true;
        }
        return result;
    }

    public Function getFunction(String functionName) {
        Function result = null;
        for (Function function : this.functions) {
            if (!function.getName().equals(functionName)) continue;
            result = function;
        }
        if (result != null) {
            return result;
        }
        throw new IllegalStateException(this.name + " does not have " + functionName);
    }

    public void removeFunctionsFromSettlement() {
        Iterator<Function> i = this.functions.iterator();
        while (i.hasNext()) {
            i.next().removeFromSettlement();
        }
    }

    public BuildingManager getBuildingManager() {
        return this.manager;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getLength() {
        return this.length;
    }

    @Override
    public double getXLocation() {
        return this.xLoc;
    }

    @Override
    public double getYLocation() {
        return this.yLoc;
    }

    @Override
    public double getFacing() {
        return this.facing;
    }

    public void timePassing(double time) {
        if (time < 0.0) {
            throw new IllegalArgumentException("Time must be > 0D");
        }
        Iterator<Function> i = this.functions.iterator();
        while (i.hasNext()) {
            i.next().timePassing(time);
        }
        this.malfunctionManager.timePassing(time);
        if (this.powerMode.equals(FULL_POWER)) {
            this.malfunctionManager.activeTimePassing(time);
        }
    }

    public double getFullPowerRequired() {
        double result = this.basePowerRequirement;
        Iterator<Function> i = this.functions.iterator();
        while (i.hasNext()) {
            result += i.next().getFullPowerRequired();
        }
        return result;
    }

    public double getPoweredDownPowerRequired() {
        double result = this.basePowerDownPowerRequirement;
        Iterator<Function> i = this.functions.iterator();
        while (i.hasNext()) {
            result += i.next().getPowerDownPowerRequired();
        }
        return result;
    }

    public String getPowerMode() {
        return this.powerMode;
    }

    public void setPowerMode(String powerMode) {
        this.powerMode = powerMode;
    }

    @Override
    public MalfunctionManager getMalfunctionManager() {
        return this.malfunctionManager;
    }

    @Override
    public Collection<Person> getAffectedPeople() {
        ConcurrentLinkedQueue<Person> people = new ConcurrentLinkedQueue<Person>();
        if (this.hasFunction("Life Support")) {
            LifeSupport lifeSupport = (LifeSupport)this.getFunction("Life Support");
            for (Person occupant : lifeSupport.getOccupants()) {
                if (people.contains(occupant)) continue;
                people.add(occupant);
            }
        }
        for (Person person : this.manager.getSettlement().getInhabitants()) {
            Task task = person.getMind().getTaskManager().getTask();
            if (task instanceof Maintenance && ((Maintenance)task).getEntity() == this && !people.contains(person)) {
                people.add(person);
            }
            if (!(task instanceof Repair) || ((Repair)((Object)task)).getEntity() != this || people.contains(person)) continue;
            people.add(person);
        }
        return people;
    }

    @Override
    public Inventory getInventory() {
        return this.manager.getSettlement().getInventory();
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(Building o) {
        return this.name.compareToIgnoreCase(o.name);
    }

    public void destroy() {
        this.name = null;
        this.manager = null;
        this.powerMode = null;
        this.malfunctionManager.destroy();
        this.malfunctionManager = null;
        Iterator<Function> i = this.functions.iterator();
        while (i.hasNext()) {
            i.next().destroy();
        }
    }
}

