/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.building;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.DataConversionException;
import org.jdom.Document;
import org.jdom.Element;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.structure.building.function.AreothermalPowerSource;
import org.mars_sim.msp.core.structure.building.function.FuelPowerSource;
import org.mars_sim.msp.core.structure.building.function.PowerSource;
import org.mars_sim.msp.core.structure.building.function.ResourceProcess;
import org.mars_sim.msp.core.structure.building.function.SolarPowerSource;
import org.mars_sim.msp.core.structure.building.function.SolarThermalPowerSource;
import org.mars_sim.msp.core.structure.building.function.StandardPowerSource;
import org.mars_sim.msp.core.structure.building.function.WindPowerSource;

public class BuildingConfig
implements Serializable {
    private static final String BUILDING = "building";
    private static final String NAME = "name";
    private static final String WIDTH = "width";
    private static final String LENGTH = "length";
    private static final String POWER_REQUIRED = "power-required";
    private static final String BASE_POWER = "base-power";
    private static final String BASE_POWER_DOWN_POWER = "base-power-down-power";
    private static final String FUNCTIONS = "functions";
    private static final String LIFE_SUPPORT = "life-support";
    private static final String CAPACITY = "capacity";
    private static final String LIVING_ACCOMMODATIONS = "living-accommodations";
    private static final String RESEARCH = "research";
    private static final String TECH_LEVEL = "tech-level";
    private static final String RESEARCH_SPECIALITY = "research-speciality";
    private static final String COMMUNICATION = "communication";
    private static final String EVA = "EVA";
    private static final String AIRLOCK_CAPACITY = "airlock-capacity";
    private static final String RECREATION = "recreation";
    private static final String DINING = "dining";
    private static final String RESOURCE_PROCESSING = "resource-processing";
    private static final String POWER_DOWN_LEVEL = "power-down-level";
    private static final String PROCESS = "process";
    private static final String INPUT = "input";
    private static final String OUTPUT = "output";
    private static final String RATE = "rate";
    private static final String AMBIENT = "ambient";
    private static final String STORAGE = "storage";
    private static final String RESOURCE_STORAGE = "resource-storage";
    private static final String RESOURCE_INITIAL = "resource-initial";
    private static final String RESOURCE = "resource";
    private static final String AMOUNT = "amount";
    private static final String POWER_GENERATION = "power-generation";
    private static final String POWER_SOURCE = "power-source";
    private static final String TYPE = "type";
    private static final String POWER = "power";
    private static final String MEDICAL_CARE = "medical-care";
    private static final String BEDS = "beds";
    private static final String FARMING = "farming";
    private static final String CROPS = "crops";
    private static final String POWER_GROWING_CROP = "power-growing-crop";
    private static final String POWER_SUSTAINING_CROP = "power-sustaining-crop";
    private static final String GROWING_AREA = "growing-area";
    private static final String EXERCISE = "exercise";
    private static final String GROUND_VEHICLE_MAINTENANCE = "ground-vehicle-maintenance";
    private static final String PARKING_LOCATION = "parking-location";
    private static final String X_LOCATION = "xloc";
    private static final String Y_LOCATION = "yloc";
    private static final String VEHICLE_CAPACITY = "vehicle-capacity";
    private static final String COOKING = "cooking";
    private static final String DEFAULT = "default";
    private static final String MANUFACTURE = "manufacture";
    private static final String CONCURRENT_PROCESSES = "concurrent-processes";
    private static final String FUEL_TYPE = "fuel-type";
    private static final String COMSUMPTION_RATE = "consumption-rate";
    private static final String TOGGLE = "toggle";
    private static final String POWER_STORAGE = "power-storage";
    private static final String ASTRONOMICAL_OBSERVATION = "astronomical-observation";
    private static final String EARTH_RETURN = "earth-return";
    private static final String CREW_CAPACITY = "crew-capacity";
    private static final String MANAGEMENT = "management";
    private static final String POPULATION_SUPPORT = "population-support";
    private static final String STANDARD_POWER_SOURCE = "Standard Power Source";
    private static final String SOLAR_POWER_SOURCE = "Solar Power Source";
    private static final String SOLAR_THERMAL_POWER_SOURCE = "Solar Thermal Power Source";
    private static final String FUEL_POWER_SOURCE = "Fuel Power Source";
    private static final String WIND_POWER_SOURCE = "Wind Power Source";
    private static final String AREOTHERMAL_POWER_SOURCE = "Areothermal Power Source";
    private Document buildingDoc;
    private Set<String> buildingNames;

    public BuildingConfig(Document buildingDoc) {
        this.buildingDoc = buildingDoc;
    }

    public Set<String> getBuildingNames() {
        if (this.buildingNames == null) {
            this.buildingNames = new HashSet<String>();
            Element root = this.buildingDoc.getRootElement();
            List buildingNodes = root.getChildren(BUILDING);
            for (Element buildingElement : buildingNodes) {
                this.buildingNames.add(buildingElement.getAttributeValue(NAME));
            }
        }
        return this.buildingNames;
    }

    private Element getBuildingElement(String buildingName) {
        Element result = null;
        Element root = this.buildingDoc.getRootElement();
        List buildingNodes = root.getChildren(BUILDING);
        for (Element buildingElement : buildingNodes) {
            String name = buildingElement.getAttributeValue(NAME);
            if (!buildingName.equalsIgnoreCase(name)) continue;
            result = buildingElement;
            break;
        }
        if (result == null) {
            throw new IllegalStateException("Building type: " + buildingName + " could not be found in buildings.xml.");
        }
        return result;
    }

    public double getWidth(String buildingName) {
        Element buildingElement = this.getBuildingElement(buildingName);
        return Double.parseDouble(buildingElement.getAttributeValue(WIDTH));
    }

    public double getLength(String buildingName) {
        Element buildingElement = this.getBuildingElement(buildingName);
        return Double.parseDouble(buildingElement.getAttributeValue(LENGTH));
    }

    public double getBasePowerRequirement(String buildingName) {
        Element buildingElement = this.getBuildingElement(buildingName);
        Element powerElement = buildingElement.getChild(POWER_REQUIRED);
        return Double.parseDouble(powerElement.getAttributeValue(BASE_POWER));
    }

    public double getBasePowerDownPowerRequirement(String buildingName) {
        Element buildingElement = this.getBuildingElement(buildingName);
        Element powerElement = buildingElement.getChild(POWER_REQUIRED);
        return Double.parseDouble(powerElement.getAttributeValue(BASE_POWER_DOWN_POWER));
    }

    public boolean hasLifeSupport(String buildingName) {
        return this.hasElements(buildingName, FUNCTIONS, LIFE_SUPPORT);
    }

    public int getLifeSupportCapacity(String buildingName) {
        return this.getValueAsInteger(buildingName, FUNCTIONS, LIFE_SUPPORT, CAPACITY);
    }

    public double getLifeSupportPowerRequirement(String buildingName) {
        return this.getValueAsDouble(buildingName, FUNCTIONS, LIFE_SUPPORT, POWER_REQUIRED);
    }

    public boolean hasLivingAccommodations(String buildingName) {
        return this.hasElements(buildingName, FUNCTIONS, LIVING_ACCOMMODATIONS);
    }

    public int getLivingAccommodationBeds(String buildingName) {
        return this.getValueAsInteger(buildingName, FUNCTIONS, LIVING_ACCOMMODATIONS, BEDS);
    }

    public boolean hasResearchLab(String buildingName) {
        return this.hasElements(buildingName, FUNCTIONS, RESEARCH);
    }

    public int getResearchTechLevel(String buildingName) {
        return this.getValueAsInteger(buildingName, FUNCTIONS, RESEARCH, TECH_LEVEL);
    }

    public int getResearchCapacity(String buildingName) {
        return this.getValueAsInteger(buildingName, FUNCTIONS, RESEARCH, CAPACITY);
    }

    public List<String> getResearchSpecialities(String buildingName) {
        ArrayList<String> result = new ArrayList<String>();
        Element buildingElement = this.getBuildingElement(buildingName);
        Element functionsElement = buildingElement.getChild(FUNCTIONS);
        Element researchElement = functionsElement.getChild(RESEARCH);
        List researchSpecialities = researchElement.getChildren(RESEARCH_SPECIALITY);
        for (Element researchSpecialityElement : researchSpecialities) {
            result.add(researchSpecialityElement.getAttributeValue(NAME));
        }
        return result;
    }

    public boolean hasCommunication(String buildingName) {
        return this.hasElements(buildingName, FUNCTIONS, COMMUNICATION);
    }

    public boolean hasEVA(String buildingName) {
        return this.hasElements(buildingName, FUNCTIONS, EVA);
    }

    public int getAirlockCapacity(String buildingName) {
        return this.getValueAsInteger(buildingName, FUNCTIONS, EVA, AIRLOCK_CAPACITY);
    }

    public boolean hasRecreation(String buildingName) {
        return this.hasElements(buildingName, FUNCTIONS, RECREATION);
    }

    public int getRecreationPopulationSupport(String buildingName) {
        return this.getValueAsInteger(buildingName, FUNCTIONS, RECREATION, POPULATION_SUPPORT);
    }

    public boolean hasDining(String buildingName) {
        return this.hasElements(buildingName, FUNCTIONS, DINING);
    }

    public int getDiningCapacity(String buildingName) {
        return this.getValueAsInteger(buildingName, FUNCTIONS, DINING, CAPACITY);
    }

    public boolean hasResourceProcessing(String buildingName) {
        return this.hasElements(buildingName, FUNCTIONS, RESOURCE_PROCESSING);
    }

    public double getResourceProcessingPowerDown(String buildingName) {
        return this.getValueAsDouble(buildingName, FUNCTIONS, RESOURCE_PROCESSING, POWER_DOWN_LEVEL);
    }

    public List<ResourceProcess> getResourceProcesses(String buildingName) {
        ArrayList<ResourceProcess> resourceProcesses = new ArrayList<ResourceProcess>();
        Element buildingElement = this.getBuildingElement(buildingName);
        Element functionsElement = buildingElement.getChild(FUNCTIONS);
        Element resourceProcessingElement = functionsElement.getChild(RESOURCE_PROCESSING);
        List resourceProcessNodes = resourceProcessingElement.getChildren(PROCESS);
        for (Element processElement : resourceProcessNodes) {
            String defaultString = processElement.getAttributeValue(DEFAULT);
            boolean defaultOn = true;
            if (defaultString.equals("off")) {
                defaultOn = false;
            }
            double powerRequired = Double.parseDouble(processElement.getAttributeValue(POWER_REQUIRED));
            ResourceProcess process = new ResourceProcess(processElement.getAttributeValue(NAME), powerRequired, defaultOn);
            List inputNodes = processElement.getChildren(INPUT);
            for (Element inputElement : inputNodes) {
                String resourceName = inputElement.getAttributeValue(RESOURCE).toLowerCase();
                AmountResource resource = AmountResource.findAmountResource(resourceName);
                double rate = Double.parseDouble(inputElement.getAttributeValue(RATE)) / 1000.0;
                boolean ambient = Boolean.valueOf(inputElement.getAttributeValue(AMBIENT));
                process.addMaxInputResourceRate(resource, rate, ambient);
            }
            List outputNodes = processElement.getChildren(OUTPUT);
            for (Element outputElement : outputNodes) {
                String resourceName = outputElement.getAttributeValue(RESOURCE).toLowerCase();
                AmountResource resource = AmountResource.findAmountResource(resourceName);
                double rate = Double.parseDouble(outputElement.getAttributeValue(RATE)) / 1000.0;
                boolean ambient = Boolean.valueOf(outputElement.getAttributeValue(AMBIENT));
                process.addMaxOutputResourceRate(resource, rate, ambient);
            }
            resourceProcesses.add(process);
        }
        return resourceProcesses;
    }

    public boolean hasStorage(String buildingName) {
        return this.hasElements(buildingName, FUNCTIONS, STORAGE);
    }

    public Map<AmountResource, Double> getStorageCapacities(String buildingName) {
        HashMap<AmountResource, Double> capacities = new HashMap<AmountResource, Double>();
        Element buildingElement = this.getBuildingElement(buildingName);
        Element functionsElement = buildingElement.getChild(FUNCTIONS);
        Element storageElement = functionsElement.getChild(STORAGE);
        List resourceStorageNodes = storageElement.getChildren(RESOURCE_STORAGE);
        for (Element resourceStorageElement : resourceStorageNodes) {
            String resourceName = resourceStorageElement.getAttributeValue(RESOURCE).toLowerCase();
            AmountResource resource = AmountResource.findAmountResource(resourceName);
            Double capacity = new Double(resourceStorageElement.getAttributeValue(CAPACITY));
            capacities.put(resource, capacity);
        }
        return capacities;
    }

    public Map<AmountResource, Double> getInitialStorage(String buildingName) {
        HashMap<AmountResource, Double> resourceMap = new HashMap<AmountResource, Double>();
        Element buildingElement = this.getBuildingElement(buildingName);
        Element functionsElement = buildingElement.getChild(FUNCTIONS);
        Element storageElement = functionsElement.getChild(STORAGE);
        List resourceInitialNodes = storageElement.getChildren(RESOURCE_INITIAL);
        for (Element resourceInitialElement : resourceInitialNodes) {
            String resourceName = resourceInitialElement.getAttributeValue(RESOURCE).toLowerCase();
            AmountResource resource = AmountResource.findAmountResource(resourceName);
            Double amount = new Double(resourceInitialElement.getAttributeValue(AMOUNT));
            resourceMap.put(resource, amount);
        }
        return resourceMap;
    }

    public boolean hasPowerGeneration(String buildingName) {
        return this.hasElements(buildingName, FUNCTIONS, POWER_GENERATION);
    }

    public List<PowerSource> getPowerSources(String buildingName) {
        ArrayList<PowerSource> powerSourceList = new ArrayList<PowerSource>();
        Element buildingElement = this.getBuildingElement(buildingName);
        Element functionsElement = buildingElement.getChild(FUNCTIONS);
        Element powerGenerationElement = functionsElement.getChild(POWER_GENERATION);
        List powerSourceNodes = powerGenerationElement.getChildren(POWER_SOURCE);
        for (Element powerSourceElement : powerSourceNodes) {
            String type = powerSourceElement.getAttributeValue(TYPE);
            double power = Double.parseDouble(powerSourceElement.getAttributeValue(POWER));
            PowerSource powerSource = null;
            if (type.equalsIgnoreCase(STANDARD_POWER_SOURCE)) {
                powerSource = new StandardPowerSource(power);
            } else if (type.equalsIgnoreCase(SOLAR_POWER_SOURCE)) {
                powerSource = new SolarPowerSource(power);
            } else if (type.equalsIgnoreCase(SOLAR_THERMAL_POWER_SOURCE)) {
                powerSource = new SolarThermalPowerSource(power);
            } else if (type.equalsIgnoreCase(FUEL_POWER_SOURCE)) {
                boolean toggleStafe = Boolean.parseBoolean(powerSourceElement.getAttributeValue(TOGGLE));
                String fuelType = powerSourceElement.getAttributeValue(FUEL_TYPE);
                double consumptionSpeed = Double.parseDouble(powerSourceElement.getAttributeValue(COMSUMPTION_RATE));
                powerSource = new FuelPowerSource(power, toggleStafe, fuelType, consumptionSpeed);
            } else if (type.equalsIgnoreCase(WIND_POWER_SOURCE)) {
                powerSource = new WindPowerSource(power);
            } else if (type.equalsIgnoreCase(AREOTHERMAL_POWER_SOURCE)) {
                powerSource = new AreothermalPowerSource(power);
            } else {
                throw new IllegalStateException("Power source: " + type + " not a valid power source.");
            }
            powerSourceList.add(powerSource);
        }
        return powerSourceList;
    }

    public boolean hasPowerStorage(String buildingName) {
        return this.hasElements(buildingName, FUNCTIONS, POWER_STORAGE);
    }

    public double getPowerStorageCapacity(String buildingName) {
        return this.getValueAsDouble(buildingName, FUNCTIONS, POWER_STORAGE, CAPACITY);
    }

    public boolean hasMedicalCare(String buildingName) {
        return this.hasElements(buildingName, FUNCTIONS, MEDICAL_CARE);
    }

    public int getMedicalCareTechLevel(String buildingName) {
        return this.getValueAsInteger(buildingName, FUNCTIONS, MEDICAL_CARE, TECH_LEVEL);
    }

    public int getMedicalCareBeds(String buildingName) {
        return this.getValueAsInteger(buildingName, FUNCTIONS, MEDICAL_CARE, BEDS);
    }

    public boolean hasFarming(String buildingName) {
        return this.hasElements(buildingName, FUNCTIONS, FARMING);
    }

    public int getCropNum(String buildingName) {
        return this.getValueAsInteger(buildingName, FUNCTIONS, FARMING, CROPS);
    }

    public double getPowerForGrowingCrop(String buildingName) {
        return this.getValueAsDouble(buildingName, FUNCTIONS, FARMING, POWER_GROWING_CROP);
    }

    public double getPowerForSustainingCrop(String buildingName) {
        return this.getValueAsDouble(buildingName, FUNCTIONS, FARMING, POWER_SUSTAINING_CROP);
    }

    public double getCropGrowingArea(String buildingName) {
        return this.getValueAsDouble(buildingName, FUNCTIONS, FARMING, GROWING_AREA);
    }

    public boolean hasExercise(String buildingName) {
        return this.hasElements(buildingName, FUNCTIONS, EXERCISE);
    }

    public int getExerciseCapacity(String buildingName) {
        return this.getValueAsInteger(buildingName, FUNCTIONS, EXERCISE, CAPACITY);
    }

    public boolean hasGroundVehicleMaintenance(String buildingName) {
        return this.hasElements(buildingName, FUNCTIONS, GROUND_VEHICLE_MAINTENANCE);
    }

    public int getVehicleCapacity(String buildingName) {
        return this.getValueAsInteger(buildingName, FUNCTIONS, GROUND_VEHICLE_MAINTENANCE, VEHICLE_CAPACITY);
    }

    public int getParkingLocationNumber(String buildingName) {
        Element buildingElement = this.getBuildingElement(buildingName);
        Element functionsElement = buildingElement.getChild(FUNCTIONS);
        Element groundVehicleMaintenanceElement = functionsElement.getChild(GROUND_VEHICLE_MAINTENANCE);
        return groundVehicleMaintenanceElement.getChildren(PARKING_LOCATION).size();
    }

    public Point2D.Double getParkingLocation(String buildingName, int parkingIndex) {
        Element buildingElement = this.getBuildingElement(buildingName);
        Element functionsElement = buildingElement.getChild(FUNCTIONS);
        Element groundVehicleMaintenanceElement = functionsElement.getChild(GROUND_VEHICLE_MAINTENANCE);
        List parkingLocations = groundVehicleMaintenanceElement.getChildren(PARKING_LOCATION);
        if (parkingIndex >= 0 && parkingIndex < parkingLocations.size()) {
            Element parkingLocation = (Element)parkingLocations.get(parkingIndex);
            try {
                Point2D.Double point = new Point2D.Double();
                double xLocation = parkingLocation.getAttribute(X_LOCATION).getDoubleValue();
                double yLocation = parkingLocation.getAttribute(Y_LOCATION).getDoubleValue();
                point.setLocation(xLocation, yLocation);
                return point;
            }
            catch (DataConversionException e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    public boolean hasCooking(String buildingName) {
        return this.hasElements(buildingName, FUNCTIONS, COOKING);
    }

    public int getCookCapacity(String buildingName) {
        return this.getValueAsInteger(buildingName, FUNCTIONS, COOKING, CAPACITY);
    }

    public boolean hasManufacture(String buildingName) {
        return this.hasElements(buildingName, FUNCTIONS, MANUFACTURE);
    }

    public int getManufactureTechLevel(String buildingName) {
        return this.getValueAsInteger(buildingName, FUNCTIONS, MANUFACTURE, TECH_LEVEL);
    }

    public boolean hasAstronomicalObservation(String buildingName) {
        return this.hasElements(buildingName, FUNCTIONS, ASTRONOMICAL_OBSERVATION);
    }

    public int getAstronomicalObservationTechLevel(String buildingName) {
        return this.getValueAsInteger(buildingName, FUNCTIONS, ASTRONOMICAL_OBSERVATION, TECH_LEVEL);
    }

    public int getAstronomicalObservationCapacity(String buildingName) {
        return this.getValueAsInteger(buildingName, FUNCTIONS, ASTRONOMICAL_OBSERVATION, CAPACITY);
    }

    public double getAstronomicalObservationPowerRequirement(String buildingName) {
        return this.getValueAsDouble(buildingName, FUNCTIONS, ASTRONOMICAL_OBSERVATION, POWER_REQUIRED);
    }

    public int getManufactureConcurrentProcesses(String buildingName) {
        return this.getValueAsInteger(buildingName, FUNCTIONS, MANUFACTURE, CONCURRENT_PROCESSES);
    }

    public boolean hasManagement(String buildingName) {
        return this.hasElements(buildingName, FUNCTIONS, MANAGEMENT);
    }

    public int getManagementPopulationSupport(String buildingName) {
        return this.getValueAsInteger(buildingName, FUNCTIONS, MANAGEMENT, POPULATION_SUPPORT);
    }

    public boolean hasEarthReturn(String buildingName) {
        return this.hasElements(buildingName, FUNCTIONS, EARTH_RETURN);
    }

    public int getEarthReturnCrewCapacity(String buildingName) {
        return this.getValueAsInteger(buildingName, FUNCTIONS, EARTH_RETURN, CREW_CAPACITY);
    }

    private int getValueAsInteger(String buildingName, String child, String subchild, String param) {
        Element element1 = this.getBuildingElement(buildingName);
        Element element2 = element1.getChild(child);
        Element element3 = element2.getChild(subchild);
        return Integer.parseInt(element3.getAttributeValue(param));
    }

    private double getValueAsDouble(String buildingName, String child, String subchild, String param) {
        Element element1 = this.getBuildingElement(buildingName);
        Element element2 = element1.getChild(child);
        Element element3 = element2.getChild(subchild);
        return Double.parseDouble(element3.getAttributeValue(param));
    }

    private boolean hasElements(String buildingName, String child, String children) {
        Element element1 = this.getBuildingElement(buildingName);
        Element element2 = element1.getChild(child);
        List elements = element2.getChildren(children);
        return elements.size() > 0;
    }

    public void destroy() {
        this.buildingDoc = null;
    }
}

