/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.building.function;

import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.function.PowerSource;

public class AreothermalPowerSource
extends PowerSource {
    private static final String TYPE = "Areothermal Power Source";

    public AreothermalPowerSource(double maxPower) {
        super(TYPE, maxPower);
    }

    @Override
    public double getCurrentPower(Building building) {
        Coordinates location = building.getBuildingManager().getSettlement().getCoordinates();
        double areothermalHeat = Simulation.instance().getMars().getSurfaceFeatures().getAreothermalPotential(location);
        return this.getMaxPower() * (areothermalHeat / 100.0);
    }

    @Override
    public double getAveragePower(Settlement settlement) {
        Coordinates location = settlement.getCoordinates();
        double areothermalHeat = Simulation.instance().getMars().getSurfaceFeatures().getAreothermalPotential(location);
        return this.getMaxPower() * (areothermalHeat / 100.0);
    }
}

