/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.building.function;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.science.Science;
import org.mars_sim.msp.core.science.ScienceUtil;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingConfig;
import org.mars_sim.msp.core.structure.building.function.Function;
import org.mars_sim.msp.core.time.MarsClock;

public class AstronomicalObservation
extends Function {
    private static String CLASS_NAME = "org.mars_sim.msp.simulation.structure.building.function.AstronomicalObservation";
    private static Logger logger = Logger.getLogger(CLASS_NAME);
    public static String NAME = "Astronomical Observations";
    private double powerRequired;
    private int techLevel;
    private int observatoryCapacity;
    private int observerNum;

    public AstronomicalObservation(Building building) {
        super(NAME, building);
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        try {
            this.powerRequired = config.getAstronomicalObservationPowerRequirement(building.getName());
            this.techLevel = config.getAstronomicalObservationTechLevel(building.getName());
            this.observatoryCapacity = config.getAstronomicalObservationCapacity(building.getName());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Constructor(): " + e.getMessage());
            throw new IllegalStateException("AstronomicalObservation.constructor: " + e.getMessage());
        }
    }

    @Override
    public double getFullPowerRequired() {
        return this.powerRequired;
    }

    @Override
    public double getPowerDownPowerRequired() {
        return 0.0;
    }

    @Override
    public void timePassing(double time) {
    }

    public void addObserver() {
        ++this.observerNum;
        if (this.observerNum > this.observatoryCapacity) {
            this.observerNum = this.observatoryCapacity;
            logger.log(Level.SEVERE, "addObserver(): Observatory is already full of observers.");
            throw new IllegalStateException("Observatory is already full of observers.");
        }
    }

    public void removeObserver() {
        --this.observerNum;
        if (this.observerNum < 0) {
            this.observerNum = 0;
            logger.log(Level.SEVERE, "addObserver(): Observatory is already empty of observers.");
            throw new IllegalStateException("Observatory is already empty of observers.");
        }
    }

    public int getObserverNum() {
        return this.observerNum;
    }

    public int getObservatoryCapacity() {
        return this.observatoryCapacity;
    }

    public int getTechnologyLevel() {
        return this.techLevel;
    }

    public static double getFunctionValue(String buildingName, boolean newBuilding, Settlement settlement) {
        double hoursInSol;
        double observatoryDemand = 0.0;
        Science astronomyScience = ScienceUtil.getScience("Astronomy");
        String astronomySkill = ScienceUtil.getAssociatedSkill(astronomyScience);
        Iterator<Person> j = settlement.getAllAssociatedPeople().iterator();
        while (j.hasNext()) {
            observatoryDemand += (double)j.next().getMind().getSkillManager().getSkillLevel(astronomySkill);
        }
        double observatorySupply = 0.0;
        boolean removedBuilding = false;
        for (Building building : settlement.getBuildingManager().getBuildings(NAME)) {
            if (!newBuilding && building.getName().equalsIgnoreCase(buildingName) && !removedBuilding) {
                removedBuilding = true;
                continue;
            }
            AstronomicalObservation astroFunction = (AstronomicalObservation)building.getFunction(NAME);
            int techLevel = astroFunction.techLevel;
            int observatorySize = astroFunction.observatoryCapacity;
            double wearModifier = building.getMalfunctionManager().getWearCondition() / 100.0 * 0.75 + 0.25;
            observatorySupply += (double)(techLevel * observatorySize) * wearModifier;
        }
        double existingObservatoryValue = observatoryDemand / (observatorySupply + 1.0);
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        int techLevel = config.getAstronomicalObservationTechLevel(buildingName);
        int observatorySize = config.getAstronomicalObservationCapacity(buildingName);
        double buildingObservatorySupply = techLevel * observatorySize;
        double result = buildingObservatorySupply * existingObservatoryValue;
        double power = config.getAstronomicalObservationPowerRequirement(buildingName);
        double powerPerSol = power * (hoursInSol = MarsClock.convertMillisolsToSeconds(1000.0) / 60.0 / 60.0);
        double powerValue = powerPerSol * settlement.getPowerGrid().getPowerValue();
        if ((result -= powerValue) < 0.0) {
            result = 0.0;
        }
        return result;
    }
}

