/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.building.function;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.mars.SurfaceFeatures;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.function.CropConfig;
import org.mars_sim.msp.core.structure.building.function.CropType;
import org.mars_sim.msp.core.structure.building.function.Farming;

public class Crop
implements Serializable {
    private static Logger logger = Logger.getLogger(Crop.class.getName());
    public static final double WASTE_WATER_NEEDED = 5.0;
    public static final double CARBON_DIOXIDE_NEEDED = 2.0;
    public static final String PLANTING = "Planting";
    public static final String GROWING = "Growing";
    public static final String HARVESTING = "Harvesting";
    public static final String FINISHED = "Finished";
    private CropType cropType;
    private double maxHarvest;
    private Farming farm;
    private Settlement settlement;
    private String phase;
    private double plantingWorkRequired;
    private double dailyTendingWorkRequired;
    private double harvestingWorkRequired;
    private double currentPhaseWorkCompleted;
    private double actualHarvest;
    private double growingTimeCompleted;
    private int currentSol;

    public Crop(CropType cropType, double maxHarvest, Farming farm, Settlement settlement, boolean newCrop) {
        this.cropType = cropType;
        this.maxHarvest = maxHarvest;
        this.farm = farm;
        this.settlement = settlement;
        this.plantingWorkRequired = maxHarvest;
        this.dailyTendingWorkRequired = maxHarvest;
        this.harvestingWorkRequired = maxHarvest * 5.0;
        if (newCrop) {
            this.phase = PLANTING;
            this.actualHarvest = 0.0;
        } else {
            this.phase = GROWING;
            this.growingTimeCompleted = RandomUtil.getRandomDouble(cropType.getGrowingTime());
            this.actualHarvest = maxHarvest * (this.growingTimeCompleted / cropType.getGrowingTime());
        }
    }

    public CropType getCropType() {
        return this.cropType;
    }

    public String getPhase() {
        return this.phase;
    }

    public double getMaxHarvest() {
        return this.maxHarvest;
    }

    public double getGrowingTimeCompleted() {
        return this.growingTimeCompleted;
    }

    public boolean requiresWork() {
        boolean result = false;
        if (this.phase.equals(PLANTING) || this.phase.equals(HARVESTING)) {
            result = true;
        }
        if (this.phase.equals(GROWING) && this.dailyTendingWorkRequired > this.currentPhaseWorkCompleted) {
            result = true;
        }
        return result;
    }

    public double getCondition() {
        double result = 0.0;
        if (this.phase.equals(PLANTING)) {
            result = 1.0;
        } else if (this.phase.equals(GROWING)) {
            result = this.maxHarvest == 0.0 || this.growingTimeCompleted == 0.0 ? 1.0 : this.actualHarvest * this.cropType.getGrowingTime() / (this.maxHarvest * this.growingTimeCompleted);
        } else if (this.phase.equals(HARVESTING) || this.phase.equals(FINISHED)) {
            result = this.actualHarvest / this.maxHarvest;
        }
        if (result > 1.0) {
            result = 1.0;
        } else if (result < 0.0) {
            result = 0.0;
        }
        return result;
    }

    public double addWork(double workTime) {
        double remainingWorkTime = workTime;
        if (this.phase.equals(PLANTING)) {
            this.currentPhaseWorkCompleted += remainingWorkTime;
            if (this.currentPhaseWorkCompleted >= this.plantingWorkRequired) {
                remainingWorkTime = this.currentPhaseWorkCompleted - this.plantingWorkRequired;
                this.currentPhaseWorkCompleted = 0.0;
                this.currentSol = Simulation.instance().getMasterClock().getMarsClock().getSolOfMonth();
                this.phase = GROWING;
            } else {
                remainingWorkTime = 0.0;
            }
        }
        if (this.phase.equals(GROWING)) {
            this.currentPhaseWorkCompleted += remainingWorkTime;
            if (this.currentPhaseWorkCompleted >= this.dailyTendingWorkRequired) {
                remainingWorkTime = this.currentPhaseWorkCompleted - this.dailyTendingWorkRequired;
                this.currentPhaseWorkCompleted = this.dailyTendingWorkRequired;
            } else {
                remainingWorkTime = 0.0;
            }
        }
        if (this.phase.equals(HARVESTING)) {
            this.currentPhaseWorkCompleted += remainingWorkTime;
            if (this.currentPhaseWorkCompleted >= this.harvestingWorkRequired) {
                double overWorkTime = this.currentPhaseWorkCompleted - this.harvestingWorkRequired;
                this.farm.addHarvest(this.actualHarvest * (remainingWorkTime - overWorkTime) / this.harvestingWorkRequired);
                remainingWorkTime = overWorkTime;
                this.phase = FINISHED;
            } else {
                this.farm.addHarvest(this.actualHarvest * workTime / this.harvestingWorkRequired);
                remainingWorkTime = 0.0;
            }
        }
        return remainingWorkTime;
    }

    public void timePassing(double time) {
        if (time > 0.0 && this.phase.equals(GROWING)) {
            this.growingTimeCompleted += time;
            if (this.growingTimeCompleted > this.cropType.getGrowingTime()) {
                this.phase = HARVESTING;
                this.currentPhaseWorkCompleted = 0.0;
            } else {
                double oxygenCapacity;
                double oxygenAmount;
                double waterCapacity;
                double waterAmount;
                int newSol = Simulation.instance().getMasterClock().getMarsClock().getSolOfMonth();
                if (newSol != this.currentSol) {
                    double maxDailyHarvest = this.maxHarvest / (this.cropType.getGrowingTime() / 1000.0);
                    double dailyWorkCompleted = this.currentPhaseWorkCompleted / this.dailyTendingWorkRequired;
                    this.actualHarvest += maxDailyHarvest * (dailyWorkCompleted - 0.5);
                    this.currentSol = newSol;
                    this.currentPhaseWorkCompleted = 0.0;
                }
                double maxPeriodHarvest = this.maxHarvest * (time / this.cropType.getGrowingTime());
                double harvestModifier = 1.0;
                SurfaceFeatures surface = Simulation.instance().getMars().getSurfaceFeatures();
                double sunlight = surface.getSurfaceSunlight(this.settlement.getCoordinates());
                harvestModifier *= sunlight * 0.5 + 0.5;
                Inventory inv = this.settlement.getInventory();
                double wasteWaterRequired = maxPeriodHarvest * 5.0;
                AmountResource wasteWater = AmountResource.findAmountResource("waste water");
                AmountResource water = AmountResource.findAmountResource("water");
                double wasteWaterUsed = wasteWaterRequired;
                double wasteWaterAvailable = inv.getAmountResourceStored(wasteWater, false);
                if (wasteWaterUsed > wasteWaterAvailable) {
                    wasteWaterUsed = wasteWaterAvailable;
                }
                if ((waterAmount = wasteWaterUsed * 0.8) > (waterCapacity = inv.getAmountResourceRemainingCapacity(water, false, false))) {
                    waterAmount = waterCapacity;
                }
                inv.retrieveAmountResource(wasteWater, wasteWaterUsed);
                inv.storeAmountResource(water, waterAmount, false);
                harvestModifier *= wasteWaterUsed / wasteWaterRequired * 0.5 + 0.5;
                AmountResource carbonDioxide = AmountResource.findAmountResource("carbon dioxide");
                AmountResource oxygen = AmountResource.findAmountResource("oxygen");
                double carbonDioxideRequired = maxPeriodHarvest * 2.0;
                double carbonDioxideAvailable = inv.getAmountResourceStored(carbonDioxide, false);
                double carbonDioxideUsed = carbonDioxideRequired;
                if (carbonDioxideUsed > carbonDioxideAvailable) {
                    carbonDioxideUsed = carbonDioxideAvailable;
                }
                if ((oxygenAmount = carbonDioxideUsed * 0.9) > (oxygenCapacity = inv.getAmountResourceRemainingCapacity(oxygen, false, false))) {
                    oxygenAmount = oxygenCapacity;
                }
                inv.retrieveAmountResource(carbonDioxide, carbonDioxideUsed);
                inv.storeAmountResource(oxygen, oxygenAmount, false);
                this.actualHarvest += maxPeriodHarvest * (harvestModifier *= carbonDioxideUsed / carbonDioxideRequired * 0.5 + 0.5);
                if (this.growingTimeCompleted / this.cropType.getGrowingTime() > 0.25 && this.getCondition() < 0.1) {
                    this.phase = FINISHED;
                    logger.info("Crop " + this.cropType.getName() + " at " + this.settlement.getName() + " died.");
                }
            }
        }
    }

    public static CropType getRandomCropType() {
        CropConfig cropConfig = SimulationConfig.instance().getCropConfiguration();
        List<CropType> cropTypes = cropConfig.getCropList();
        int r = RandomUtil.getRandomInt(cropTypes.size() - 1);
        return cropTypes.get(r);
    }

    public static double getAverageCropGrowingTime() {
        CropConfig cropConfig = SimulationConfig.instance().getCropConfiguration();
        double totalGrowingTime = 0.0;
        List<CropType> cropTypes = cropConfig.getCropList();
        Iterator<CropType> i = cropTypes.iterator();
        while (i.hasNext()) {
            totalGrowingTime += i.next().getGrowingTime();
        }
        return totalGrowingTime / (double)cropTypes.size();
    }

    public void destroy() {
        this.cropType = null;
        this.farm = null;
        this.settlement = null;
        this.phase = null;
    }
}

