/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.building.function;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.mars_sim.msp.core.structure.building.function.CropType;

public class CropConfig
implements Serializable {
    private static final String CROP = "crop";
    private static final String NAME = "name";
    private static final String GROWING_TIME = "growing-time";
    private Document cropDoc;
    private List<CropType> cropList;

    public CropConfig(Document cropDoc) {
        this.cropDoc = cropDoc;
    }

    public List<CropType> getCropList() {
        if (this.cropList == null) {
            this.cropList = new ArrayList<CropType>();
            Element root = this.cropDoc.getRootElement();
            List crops = root.getChildren(CROP);
            for (Element crop : crops) {
                String name = "";
                name = crop.getAttributeValue(NAME);
                String growingTimeStr = crop.getAttributeValue(GROWING_TIME);
                double growingTime = Double.parseDouble(growingTimeStr);
                CropType cropType = new CropType(name, growingTime * 1000.0);
                this.cropList.add(cropType);
            }
        }
        return this.cropList;
    }

    public void destroy() {
        this.cropDoc = null;
        if (this.cropList != null) {
            this.cropList.clear();
            this.cropList = null;
        }
    }
}

