/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.building.function;

import java.io.Serializable;
import org.mars_sim.msp.core.Airlock;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingConfig;
import org.mars_sim.msp.core.structure.building.function.BuildingAirlock;
import org.mars_sim.msp.core.structure.building.function.Function;

public class EVA
extends Function
implements Serializable {
    public static final String NAME = "EVA";
    private Airlock airlock;

    public EVA(Building building) {
        super(NAME, building);
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        int airlockCapacity = config.getAirlockCapacity(building.getName());
        this.airlock = new BuildingAirlock(building, airlockCapacity);
    }

    public static double getFunctionValue(String buildingName, boolean newBuilding, Settlement settlement) {
        double demand = (double)settlement.getAllAssociatedPeople().size() / 4.0;
        double supply = 0.0;
        boolean removedBuilding = false;
        for (Building building : settlement.getBuildingManager().getBuildings(NAME)) {
            if (!newBuilding && building.getName().equalsIgnoreCase(buildingName) && !removedBuilding) {
                removedBuilding = true;
                continue;
            }
            EVA evaFunction = (EVA)building.getFunction(NAME);
            double wearModifier = building.getMalfunctionManager().getWearCondition() / 100.0 * 0.75 + 0.25;
            supply += (double)evaFunction.airlock.getCapacity() * wearModifier;
        }
        double airlockCapacityValue = demand / (supply + 1.0);
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        double airlockCapacity = config.getAirlockCapacity(buildingName);
        return airlockCapacity * airlockCapacityValue;
    }

    public Airlock getAirlock() {
        return this.airlock;
    }

    @Override
    public void timePassing(double time) {
        this.airlock.timePassing(time);
    }

    @Override
    public double getFullPowerRequired() {
        return 0.0;
    }

    @Override
    public double getPowerDownPowerRequired() {
        return 0.0;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.airlock = null;
    }
}

