/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.building.function;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.person.ai.task.TendGreenhouse;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingConfig;
import org.mars_sim.msp.core.structure.building.function.Crop;
import org.mars_sim.msp.core.structure.building.function.Function;
import org.mars_sim.msp.core.structure.building.function.LifeSupport;

public class Farming
extends Function
implements Serializable {
    public static final String CROP_EVENT = "crop event";
    public static final String NAME = "Farming";
    public static final double HARVEST_MULTIPLIER = 10.0;
    private int cropNum;
    private double powerGrowingCrop;
    private double powerSustainingCrop;
    private double growingArea;
    private double maxHarvest;
    private List<Crop> crops;

    public Farming(Building building) {
        super(NAME, building);
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        this.cropNum = config.getCropNum(building.getName());
        this.powerGrowingCrop = config.getPowerForGrowingCrop(building.getName());
        this.powerSustainingCrop = config.getPowerForSustainingCrop(building.getName());
        this.growingArea = config.getCropGrowingArea(building.getName());
        this.maxHarvest = this.growingArea * 10.0;
        this.crops = new ArrayList<Crop>();
        Settlement settlement = building.getBuildingManager().getSettlement();
        for (int x = 0; x < this.cropNum; ++x) {
            Crop crop = new Crop(Crop.getRandomCropType(), this.maxHarvest / (double)this.cropNum, this, settlement, false);
            this.crops.add(crop);
            building.getBuildingManager().getSettlement().fireUnitUpdate(CROP_EVENT, crop);
        }
    }

    public static double getFunctionValue(String buildingName, boolean newBuilding, Settlement settlement) {
        double foodPerSol = SimulationConfig.instance().getPersonConfiguration().getFoodConsumptionRate();
        int solsInOrbit = 668;
        double foodPerOrbit = foodPerSol * (double)solsInOrbit;
        double demand = foodPerOrbit * (double)settlement.getAllAssociatedPeople().size();
        double supply = 0.0;
        boolean removedBuilding = false;
        for (Building building : settlement.getBuildingManager().getBuildings(NAME)) {
            if (!newBuilding && building.getName().equalsIgnoreCase(buildingName) && !removedBuilding) {
                removedBuilding = true;
                continue;
            }
            Farming farmingFunction = (Farming)building.getFunction(NAME);
            double wearModifier = building.getMalfunctionManager().getWearCondition() / 100.0 * 0.75 + 0.25;
            supply += farmingFunction.getEstimatedHarvestPerOrbit() * wearModifier;
        }
        AmountResource food = AmountResource.findAmountResource("food");
        double growingAreaValue = demand / ((supply += settlement.getInventory().getAmountResourceStored(food, false)) + 1.0);
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        double growingArea = config.getCropGrowingArea(buildingName);
        return growingArea * growingAreaValue;
    }

    public List<Crop> getCrops() {
        return this.crops;
    }

    public boolean requiresWork() {
        boolean result = false;
        Iterator<Crop> i = this.crops.iterator();
        while (i.hasNext()) {
            if (!i.next().requiresWork()) continue;
            result = true;
        }
        return result;
    }

    public double addWork(double workTime) {
        double workTimeRemaining = workTime;
        Crop needyCrop = null;
        while ((needyCrop = this.getNeedyCrop()) != null && workTimeRemaining > 1.0) {
            workTimeRemaining = needyCrop.addWork(workTimeRemaining);
        }
        return workTimeRemaining;
    }

    private Crop getNeedyCrop() {
        Crop result = null;
        ArrayList<Crop> needyCrops = new ArrayList<Crop>(this.crops.size());
        for (Crop crop : this.crops) {
            if (!crop.requiresWork()) continue;
            needyCrops.add(crop);
        }
        if (needyCrops.size() > 0) {
            result = (Crop)needyCrops.get(RandomUtil.getRandomInt(needyCrops.size() - 1));
        }
        return result;
    }

    public void addHarvest(double harvest) {
        try {
            Inventory inv = this.getBuilding().getInventory();
            AmountResource food = AmountResource.findAmountResource("food");
            double remainingCapacity = inv.getAmountResourceRemainingCapacity(food, false, false);
            if (remainingCapacity < harvest) {
                harvest = remainingCapacity;
            }
            inv.storeAmountResource(food, harvest, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getFarmerNum() {
        int result = 0;
        if (this.getBuilding().hasFunction("Life Support")) {
            try {
                LifeSupport lifeSupport = (LifeSupport)this.getBuilding().getFunction("Life Support");
                Iterator<Person> i = lifeSupport.getOccupants().iterator();
                while (i.hasNext()) {
                    Task task = i.next().getMind().getTaskManager().getTask();
                    if (!(task instanceof TendGreenhouse)) continue;
                    ++result;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public void timePassing(double time) {
        double productionLevel = 0.0;
        if (this.getBuilding().getPowerMode().equals("Full Power")) {
            productionLevel = 1.0;
        } else if (this.getBuilding().getPowerMode().equals("Power Down")) {
            productionLevel = 0.5;
        }
        Iterator<Crop> i = this.crops.iterator();
        int newCrops = 0;
        while (i.hasNext()) {
            Crop crop = i.next();
            crop.timePassing(time * productionLevel);
            if (!crop.getPhase().equals("Finished")) continue;
            i.remove();
            ++newCrops;
        }
        Settlement settlement = this.getBuilding().getBuildingManager().getSettlement();
        for (int x = 0; x < newCrops; ++x) {
            Crop crop = new Crop(Crop.getRandomCropType(), this.maxHarvest / (double)this.cropNum, this, settlement, true);
            this.crops.add(crop);
            this.getBuilding().getBuildingManager().getSettlement().fireUnitUpdate(CROP_EVENT, crop);
        }
    }

    @Override
    public double getFullPowerRequired() {
        double powerRequired = 0.0;
        for (Crop crop : this.crops) {
            if (!crop.getPhase().equals("Growing")) continue;
            powerRequired += crop.getMaxHarvest() * this.powerGrowingCrop;
        }
        return powerRequired;
    }

    @Override
    public double getPowerDownPowerRequired() {
        double powerRequired = 0.0;
        for (Crop crop : this.crops) {
            if (!crop.getPhase().equals("Growing") && !crop.getPhase().equals("Harvesting")) continue;
            powerRequired += crop.getMaxHarvest() * this.powerSustainingCrop;
        }
        return powerRequired;
    }

    public double getGrowingArea() {
        return this.growingArea;
    }

    public double getEstimatedHarvestPerOrbit() {
        double aveGrowingTime = Crop.getAverageCropGrowingTime();
        int solsInOrbit = 668;
        double aveGrowingCyclesPerOrbit = (double)solsInOrbit * 1000.0 / aveGrowingTime;
        return this.maxHarvest * aveGrowingCyclesPerOrbit;
    }

    @Override
    public void destroy() {
        super.destroy();
        Iterator<Crop> i = this.crops.iterator();
        while (i.hasNext()) {
            i.next().destroy();
        }
    }
}

