/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.building.function;

import java.awt.geom.Point2D;
import java.io.Serializable;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingConfig;
import org.mars_sim.msp.core.structure.building.function.VehicleMaintenance;

public class GroundVehicleMaintenance
extends VehicleMaintenance
implements Serializable {
    public static final String NAME = "Ground Vehicle Maintenance";

    public GroundVehicleMaintenance(Building building) {
        super(NAME, building);
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        this.vehicleCapacity = config.getVehicleCapacity(building.getName());
        int parkingLocationNum = config.getParkingLocationNumber(building.getName());
        for (int x = 0; x < parkingLocationNum; ++x) {
            Point2D.Double parkingLocationPoint = config.getParkingLocation(building.getName(), x);
            this.addParkingLocation(parkingLocationPoint.getX(), parkingLocationPoint.getY());
        }
    }

    public static double getFunctionValue(String buildingName, boolean newBuilding, Settlement settlement) {
        double demand = settlement.getAllAssociatedVehicles().size();
        double supply = 0.0;
        boolean removedBuilding = false;
        for (Building building : settlement.getBuildingManager().getBuildings(NAME)) {
            if (!newBuilding && building.getName().equals(buildingName) && !removedBuilding) {
                removedBuilding = true;
                continue;
            }
            GroundVehicleMaintenance maintFunction = (GroundVehicleMaintenance)building.getFunction(NAME);
            double wearModifier = building.getMalfunctionManager().getWearCondition() / 100.0 * 0.75 + 0.25;
            supply += (double)maintFunction.getVehicleCapacity() * wearModifier;
        }
        double vehicleCapacityValue = demand / (supply + 1.0);
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        double vehicleCapacity = config.getVehicleCapacity(buildingName);
        return vehicleCapacity * vehicleCapacityValue;
    }
}

