/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.building.function;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.PhysicalCondition;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingConfig;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.building.function.Function;
import org.mars_sim.msp.core.time.MarsClock;

public class LifeSupport
extends Function
implements Serializable {
    private static Logger logger = Logger.getLogger(LifeSupport.class.getName());
    public static final String NAME = "Life Support";
    private int occupantCapacity;
    private double powerRequired;
    private Collection<Person> occupants = new ConcurrentLinkedQueue<Person>();

    public LifeSupport(Building building) {
        super(NAME, building);
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        this.occupantCapacity = config.getLifeSupportCapacity(building.getName());
        this.powerRequired = config.getLifeSupportPowerRequirement(building.getName());
    }

    public LifeSupport(Building building, int occupantCapacity, double powerRequired) {
        super(NAME, building);
        this.occupantCapacity = occupantCapacity;
        this.powerRequired = powerRequired;
    }

    public static double getFunctionValue(String buildingName, boolean newBuilding, Settlement settlement) {
        double hoursInSol;
        double demand = (double)settlement.getAllAssociatedPeople().size() * 2.0;
        double supply = 0.0;
        boolean removedBuilding = false;
        for (Building building : settlement.getBuildingManager().getBuildings(NAME)) {
            if (!newBuilding && building.getName().equalsIgnoreCase(buildingName) && !removedBuilding) {
                removedBuilding = true;
                continue;
            }
            LifeSupport lsFunction = (LifeSupport)building.getFunction(NAME);
            double wearModifier = building.getMalfunctionManager().getWearCondition() / 100.0 * 0.75 + 0.25;
            supply += (double)lsFunction.occupantCapacity * wearModifier;
        }
        double occupantCapacityValue = demand / (supply + 1.0);
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        double occupantCapacity = config.getLifeSupportCapacity(buildingName);
        double result = occupantCapacity * occupantCapacityValue;
        double power = config.getLifeSupportPowerRequirement(buildingName);
        double powerPerSol = power * (hoursInSol = MarsClock.convertMillisolsToSeconds(1000.0) / 60.0 / 60.0);
        double powerValue = powerPerSol * settlement.getPowerGrid().getPowerValue() / 1000.0;
        if ((result -= powerValue) < 0.0) {
            result = 0.0;
        }
        return result;
    }

    public int getOccupantCapacity() {
        return this.occupantCapacity;
    }

    public int getOccupantNumber() {
        return this.occupants.size();
    }

    public int getAvailableOccupancy() {
        int available = this.occupantCapacity - this.getOccupantNumber();
        if (available > 0) {
            return available;
        }
        return 0;
    }

    public boolean containsPerson(Person person) {
        return this.occupants.contains(person);
    }

    public Collection<Person> getOccupants() {
        return new ConcurrentLinkedQueue<Person>(this.occupants);
    }

    public void addPerson(Person person) {
        if (!this.occupants.contains(person)) {
            for (Building building : this.getBuilding().getBuildingManager().getBuildings()) {
                if (!building.hasFunction(NAME)) continue;
                BuildingManager.removePersonFromBuilding(person, building);
            }
        } else {
            throw new IllegalStateException("Person already occupying building.");
        }
        this.occupants.add(person);
    }

    public void removePerson(Person occupant) {
        if (!this.occupants.contains(occupant)) {
            throw new IllegalStateException("Person does not occupy building.");
        }
        this.occupants.remove(occupant);
    }

    @Override
    public void timePassing(double time) {
        Inventory inv = this.getBuilding().getInventory();
        Iterator<Person> i = this.occupants.iterator();
        while (i.hasNext()) {
            if (inv.containsUnit(i.next())) continue;
            i.remove();
        }
        int overcrowding = this.getOccupantNumber() - this.occupantCapacity;
        if (overcrowding > 0) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Overcrowding at " + this.getBuilding());
            }
            double stressModifier = 0.1 * (double)overcrowding * time;
            Iterator<Person> j = this.getOccupants().iterator();
            while (j.hasNext()) {
                PhysicalCondition condition = j.next().getPhysicalCondition();
                condition.setStress(condition.getStress() + stressModifier);
            }
        }
    }

    @Override
    public double getFullPowerRequired() {
        return this.powerRequired;
    }

    @Override
    public double getPowerDownPowerRequired() {
        return 0.0;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.occupants.clear();
        this.occupants = null;
    }
}

