/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.building.function;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.task.MedicalAssistance;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.person.medical.HealthProblem;
import org.mars_sim.msp.core.person.medical.MedicalAid;
import org.mars_sim.msp.core.person.medical.MedicalStation;
import org.mars_sim.msp.core.person.medical.Treatment;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingConfig;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.building.function.Function;
import org.mars_sim.msp.core.structure.building.function.LifeSupport;

public class MedicalCare
extends Function
implements MedicalAid,
Serializable {
    public static final String NAME = "Medical Care";
    private MedicalStation medicalStation;

    public MedicalCare(Building building) {
        super(NAME, building);
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        int techLevel = config.getMedicalCareTechLevel(building.getName());
        int beds = config.getMedicalCareBeds(building.getName());
        this.medicalStation = new MedicalStation(techLevel, beds);
    }

    public static double getFunctionValue(String buildingName, boolean newBuilding, Settlement settlement) {
        double demand = (double)settlement.getAllAssociatedPeople().size() * 5.0;
        double supply = 0.0;
        boolean removedBuilding = false;
        for (Building building : settlement.getBuildingManager().getBuildings(NAME)) {
            if (!newBuilding && building.getName().equalsIgnoreCase(buildingName) && !removedBuilding) {
                removedBuilding = true;
                continue;
            }
            MedicalCare medFunction = (MedicalCare)building.getFunction(NAME);
            double tech = medFunction.getTechLevel();
            double beds = medFunction.getSickBedNum();
            double wearModifier = building.getMalfunctionManager().getWearCondition() / 100.0 * 0.75 + 0.25;
            supply += tech * tech * beds * wearModifier;
        }
        double medicalPointValue = demand / (supply + 1.0) / 10.0;
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        double tech = config.getMedicalCareTechLevel(buildingName);
        double beds = config.getMedicalCareBeds(buildingName);
        double medicalPoints = tech * tech * beds;
        return medicalPoints * medicalPointValue;
    }

    public int getSickBedNum() {
        return this.medicalStation.getSickBedNum();
    }

    public int getPatientNum() {
        return this.medicalStation.getPatientNum();
    }

    public Collection<Person> getPatients() {
        return this.medicalStation.getPatients();
    }

    public int getPhysicianNum() {
        int result = 0;
        if (this.getBuilding().hasFunction("Life Support")) {
            try {
                LifeSupport lifeSupport = (LifeSupport)this.getBuilding().getFunction("Life Support");
                Iterator<Person> i = lifeSupport.getOccupants().iterator();
                while (i.hasNext()) {
                    MedicalAid aid;
                    Task task = i.next().getMind().getTaskManager().getTask();
                    if (!(task instanceof MedicalAssistance) || (aid = ((MedicalAssistance)task).getMedicalAid()) == null || aid != this) continue;
                    ++result;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public List<HealthProblem> getProblemsAwaitingTreatment() {
        return this.medicalStation.getProblemsAwaitingTreatment();
    }

    @Override
    public List<HealthProblem> getProblemsBeingTreated() {
        return this.medicalStation.getProblemsBeingTreated();
    }

    @Override
    public List<Treatment> getSupportedTreatments() {
        return this.medicalStation.getSupportedTreatments();
    }

    @Override
    public boolean canTreatProblem(HealthProblem problem) {
        return this.medicalStation.canTreatProblem(problem);
    }

    @Override
    public void requestTreatment(HealthProblem problem) {
        this.medicalStation.requestTreatment(problem);
        if (this.getBuilding().hasFunction("Life Support")) {
            BuildingManager.addPersonToBuilding(problem.getSufferer(), this.getBuilding());
        }
    }

    @Override
    public void startTreatment(HealthProblem problem, double treatmentDuration) {
        this.medicalStation.startTreatment(problem, treatmentDuration);
        if (this.getBuilding().hasFunction("Life Support")) {
            BuildingManager.addPersonToBuilding(problem.getSufferer(), this.getBuilding());
        }
    }

    @Override
    public void stopTreatment(HealthProblem problem) {
        this.medicalStation.stopTreatment(problem);
    }

    @Override
    public void timePassing(double time) {
    }

    @Override
    public double getFullPowerRequired() {
        return 0.0;
    }

    @Override
    public double getPowerDownPowerRequired() {
        return 0.0;
    }

    public int getTechLevel() {
        return this.medicalStation.getTreatmentLevel();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.medicalStation = null;
    }
}

