/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.building.function;

import java.io.Serializable;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.structure.PowerGrid;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingConfig;
import org.mars_sim.msp.core.structure.building.function.Function;
import org.mars_sim.msp.core.time.MarsClock;

public class PowerStorage
extends Function
implements Serializable {
    public static final String NAME = "Power Storage";
    private double powerStorageCapacity;
    private double powerStored;

    public PowerStorage(Building building) {
        super(NAME, building);
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        this.powerStorageCapacity = config.getPowerStorageCapacity(building.getName());
    }

    public static double getFunctionValue(String buildingName, boolean newBuilding, Settlement settlement) {
        PowerGrid grid = settlement.getPowerGrid();
        double hrInSol = MarsClock.convertMillisolsToSeconds(1000.0) / 60.0 / 60.0;
        double demand = grid.getRequiredPower() * hrInSol;
        double supply = 0.0;
        for (Building building : settlement.getBuildingManager().getBuildings(NAME)) {
            PowerStorage store = (PowerStorage)building.getFunction(NAME);
            double wearModifier = building.getMalfunctionManager().getWearCondition() / 100.0 * 0.75 + 0.25;
            supply += store.powerStorageCapacity * wearModifier;
        }
        double existingPowerStorageValue = demand / (supply + 1.0);
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        double powerStorage = config.getPowerStorageCapacity(buildingName);
        double value = powerStorage * existingPowerStorageValue / hrInSol;
        if (value > 10.0) {
            value = 10.0;
        }
        return value;
    }

    public double getPowerStorageCapacity() {
        return this.powerStorageCapacity;
    }

    public double getPowerStored() {
        return this.powerStored;
    }

    public void setPowerStored(double powerStored) {
        if (powerStored > this.powerStorageCapacity) {
            powerStored = this.powerStorageCapacity;
        } else if (powerStored < 0.0) {
            powerStored = 0.0;
        }
        this.powerStored = powerStored;
    }

    @Override
    public double getFullPowerRequired() {
        return 0.0;
    }

    @Override
    public double getPowerDownPowerRequired() {
        return 0.0;
    }

    @Override
    public void timePassing(double time) {
    }
}

