/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.construction;

import java.io.Serializable;
import org.mars_sim.msp.core.structure.construction.ConstructionSite;
import org.mars_sim.msp.core.structure.construction.ConstructionStageInfo;

public class ConstructionStage
implements Serializable {
    public static final String ADD_CONSTRUCTION_WORK_EVENT = "adding construction work";
    public static final String ADD_SALVAGE_WORK_EVENT = "adding salvage work";
    private static final double SALVAGE_WORK_TIME_MODIFIER = 0.25;
    private ConstructionStageInfo info;
    private ConstructionSite site;
    private double completedWorkTime;
    private boolean isSalvaging;

    public ConstructionStage(ConstructionStageInfo info, ConstructionSite site) {
        this.info = info;
        this.site = site;
        this.completedWorkTime = 0.0;
        this.isSalvaging = false;
    }

    public ConstructionStageInfo getInfo() {
        return this.info;
    }

    public double getCompletedWorkTime() {
        return this.completedWorkTime;
    }

    public void setCompletedWorkTime(double completedWorkTime) {
        this.completedWorkTime = completedWorkTime;
    }

    public double getRequiredWorkTime() {
        double requiredWorkTime = this.info.getWorkTime();
        if (this.isSalvaging) {
            requiredWorkTime *= 0.25;
        }
        return requiredWorkTime;
    }

    public void addWorkTime(double workTime) {
        this.completedWorkTime += workTime;
        if (this.completedWorkTime > this.getRequiredWorkTime()) {
            this.completedWorkTime = this.getRequiredWorkTime();
        }
        if (this.isSalvaging) {
            this.site.fireConstructionUpdate(ADD_SALVAGE_WORK_EVENT, this);
        } else {
            this.site.fireConstructionUpdate(ADD_CONSTRUCTION_WORK_EVENT, this);
        }
    }

    public boolean isComplete() {
        return this.completedWorkTime >= this.getRequiredWorkTime();
    }

    public boolean isSalvaging() {
        return this.isSalvaging;
    }

    public void setSalvaging(boolean isSalvaging) {
        this.isSalvaging = isSalvaging;
    }

    public String toString() {
        String result = "";
        result = this.isSalvaging ? "salvaging " + this.info.getName() : "constructing " + this.info.getName();
        return result;
    }
}

