/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.construction;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.structure.construction.ConstructionVehicleType;

public class ConstructionStageInfo
implements Serializable {
    public static final String FOUNDATION = "foundation";
    public static final String FRAME = "frame";
    public static final String BUILDING = "building";
    private String name;
    private String type;
    private double width;
    private double length;
    private boolean unsetDimensions;
    private boolean constructable;
    private boolean salvagable;
    private double workTime;
    private int architectConstructionSkill;
    private String prerequisiteStage;
    private Map<Part, Integer> parts;
    private Map<AmountResource, Double> resources;
    private List<ConstructionVehicleType> vehicles;

    ConstructionStageInfo(String name, String type, double width, double length, boolean unsetDimensions, boolean constructable, boolean salvagable, double workTime, int architectConstructionSkill, String prerequisiteStage, Map<Part, Integer> parts, Map<AmountResource, Double> resources, List<ConstructionVehicleType> vehicles) {
        this.name = name;
        this.type = type;
        this.width = width;
        this.length = length;
        this.unsetDimensions = unsetDimensions;
        this.constructable = constructable;
        this.salvagable = salvagable;
        this.workTime = workTime;
        this.architectConstructionSkill = architectConstructionSkill;
        this.prerequisiteStage = prerequisiteStage;
        this.parts = parts;
        this.resources = resources;
        this.vehicles = vehicles;
    }

    public int getArchitectConstructionSkill() {
        return this.architectConstructionSkill;
    }

    public String getName() {
        return this.name;
    }

    public double getWidth() {
        return this.width;
    }

    public double getLength() {
        return this.length;
    }

    public boolean isUnsetDimensions() {
        return this.unsetDimensions;
    }

    public boolean isConstructable() {
        return this.constructable;
    }

    public boolean isSalvagable() {
        return this.salvagable;
    }

    public Map<Part, Integer> getParts() {
        return this.parts;
    }

    public String getPrerequisiteStage() {
        return this.prerequisiteStage;
    }

    public Map<AmountResource, Double> getResources() {
        return this.resources;
    }

    public String getType() {
        return this.type;
    }

    public List<ConstructionVehicleType> getVehicles() {
        return this.vehicles;
    }

    public double getWorkTime() {
        return this.workTime;
    }

    public void destroy() {
        this.name = null;
        this.type = null;
        this.prerequisiteStage = null;
        this.parts.clear();
        this.parts = null;
        this.resources.clear();
        this.resources = null;
        this.vehicles.clear();
        this.vehicles = null;
    }

    public String toString() {
        return this.name;
    }
}

