/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.construction;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.building.function.LivingAccommodations;
import org.mars_sim.msp.core.structure.construction.ConstructionManager;
import org.mars_sim.msp.core.structure.construction.ConstructionSite;
import org.mars_sim.msp.core.structure.construction.ConstructionStage;
import org.mars_sim.msp.core.structure.construction.ConstructionStageInfo;
import org.mars_sim.msp.core.structure.construction.ConstructionUtil;
import org.mars_sim.msp.core.structure.goods.GoodsManager;
import org.mars_sim.msp.core.structure.goods.GoodsUtil;
import org.mars_sim.msp.core.time.MarsClock;

public class SalvageValues
implements Serializable {
    private static final double FOUNDATION_SALVAGE_VALUE = 10.0;
    private Settlement settlement;
    private Map<Integer, Double> settlementSalvageValueCache;
    private MarsClock settlementSalvageValueCacheTime;

    SalvageValues(Settlement settlement) {
        this.settlement = settlement;
    }

    public double getSettlementSalvageProfit() {
        return this.getSettlementSalvageProfit(Integer.MAX_VALUE);
    }

    public double getSettlementSalvageProfit(int constructionSkill) {
        MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
        if (this.settlementSalvageValueCacheTime == null || MarsClock.getTimeDiff(currentTime, this.settlementSalvageValueCacheTime) > 1000.0) {
            if (this.settlementSalvageValueCache == null) {
                this.settlementSalvageValueCache = new HashMap<Integer, Double>();
            }
            this.settlementSalvageValueCache.clear();
            this.settlementSalvageValueCacheTime = (MarsClock)currentTime.clone();
        }
        if (!this.settlementSalvageValueCache.containsKey(constructionSkill)) {
            double newSiteProfit;
            double profit = 0.0;
            double existingSitesProfit = this.getAllSalvageSitesProfit(constructionSkill);
            if (existingSitesProfit > profit) {
                profit = existingSitesProfit;
            }
            if ((newSiteProfit = this.getNewSalvageSiteProfit(constructionSkill)) > profit) {
                profit = newSiteProfit;
            }
            this.settlementSalvageValueCache.put(constructionSkill, profit);
        }
        return this.settlementSalvageValueCache.get(constructionSkill);
    }

    public double getAllSalvageSitesProfit(int constructionSkill) {
        double result = 0.0;
        ConstructionManager manager = this.settlement.getConstructionManager();
        Iterator<ConstructionSite> i = manager.getConstructionSitesNeedingSalvageMission().iterator();
        while (i.hasNext()) {
            double profit = this.getSalvageSiteProfit(i.next(), constructionSkill);
            if (!(profit > result)) continue;
            result = profit;
        }
        return result;
    }

    public double getSalvageSiteProfit(ConstructionSite site) {
        return this.getSalvageSiteProfit(site, Integer.MAX_VALUE);
    }

    public double getSalvageSiteProfit(ConstructionSite site, int constructionSkill) {
        double result = 0.0;
        if (!site.isUndergoingSalvage()) {
            ConstructionStage stage = site.getCurrentConstructionStage();
            ConstructionStageInfo prerequisiteStage = ConstructionUtil.getPrerequisiteStage(stage.getInfo());
            if (site.hasUnfinishedStage()) {
                if (stage.getInfo().getArchitectConstructionSkill() <= constructionSkill) {
                    result = prerequisiteStage != null ? this.getSalvageStageValue(prerequisiteStage) : 10.0;
                    result += this.getEstimatedSalvagedPartsValue(stage.getInfo(), constructionSkill, 1.0);
                }
            } else {
                double currentValue = this.getSalvageStageValue(stage.getInfo());
                double preValue = 0.0;
                preValue = prerequisiteStage != null ? this.getSalvageStageValue(prerequisiteStage) : 10.0;
                double partsValue = this.getEstimatedSalvagedPartsValue(stage.getInfo(), constructionSkill, 1.0);
                result = preValue - currentValue + partsValue;
            }
        }
        return result;
    }

    public double getNewSalvageSiteProfit(int constructionSkill) {
        double result = 0.0;
        BuildingManager buildingManager = this.settlement.getBuildingManager();
        for (Building building : buildingManager.getBuildings()) {
            double salvageProfit = this.getNewBuildingSalvageProfit(building, constructionSkill);
            if (!(salvageProfit > result)) continue;
            result = salvageProfit;
        }
        return result;
    }

    public double getNewBuildingSalvageProfit(Building building, int constructionSkill) {
        double result = 0.0;
        BuildingManager buildingManager = this.settlement.getBuildingManager();
        double buildingValue = buildingManager.getBuildingValue(building);
        double frameStageValue = 0.0;
        ConstructionStageInfo buildingStage = ConstructionUtil.getConstructionStageInfo(building.getName());
        if (buildingStage != null && buildingStage.isSalvagable() && constructionSkill >= buildingStage.getArchitectConstructionSkill()) {
            double salvageProfit;
            ConstructionStageInfo frameStage = ConstructionUtil.getPrerequisiteStage(buildingStage);
            frameStageValue = this.getSalvageStageValue(frameStage);
            double buildingWear = building.getMalfunctionManager().getWearCondition();
            double partsValue = this.getEstimatedSalvagedPartsValue(buildingStage, constructionSkill, buildingWear / 100.0);
            result = salvageProfit = frameStageValue - buildingValue + partsValue;
        }
        if (building.hasFunction("Life Support") && this.settlement.getBuildingManager().getBuildings("Life Support").size() == 1) {
            result = 0.0;
        }
        if (building.hasFunction("Living Accommodations")) {
            LivingAccommodations livingAccommodations;
            int buildingPopCapacity;
            int popSize = this.settlement.getAllAssociatedPeople().size();
            int popCapacity = this.settlement.getPopulationCapacity();
            if (popCapacity - (buildingPopCapacity = (livingAccommodations = (LivingAccommodations)building.getFunction("Living Accommodations")).getBeds()) < popSize) {
                result = 0.0;
            }
        }
        if (building.hasFunction("EVA") && this.settlement.getAirlockNum() == 1) {
            result = 0.0;
        }
        return result;
    }

    private double getSalvageStageValue(ConstructionStageInfo stageInfo) {
        return this.settlement.getConstructionManager().getConstructionValues().getConstructionStageValue(stageInfo);
    }

    private double getEstimatedSalvagedPartsValue(ConstructionStageInfo stageInfo, int constructionSkill, double wearConditionModifier) {
        double result = 0.0;
        GoodsManager goodsManager = this.settlement.getGoodsManager();
        for (Part part : stageInfo.getParts().keySet()) {
            int number = stageInfo.getParts().get(part);
            double partValue = goodsManager.getGoodValuePerItem(GoodsUtil.getResourceGood(part));
            result += (double)number * partValue;
        }
        double valueModifier = 0.25 + wearConditionModifier * 0.25 + (double)constructionSkill * 0.05;
        return result *= valueModifier;
    }

    public void destroy() {
        this.settlement = null;
        if (this.settlementSalvageValueCache != null) {
            this.settlementSalvageValueCache.clear();
            this.settlementSalvageValueCache = null;
            this.settlementSalvageValueCacheTime = null;
        }
    }
}

