/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.goods;

import java.io.Serializable;

public class Good
implements Serializable,
Comparable<Good> {
    public static final String AMOUNT_RESOURCE = "amount resource";
    public static final String ITEM_RESOURCE = "item resource";
    public static final String EQUIPMENT = "equipment";
    public static final String VEHICLE = "vehicle";
    private String name;
    private Class classType;
    private Object object;
    private String category;

    Good(String name, Object object, String category) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        this.name = name.trim().toLowerCase();
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        this.object = object;
        this.classType = object.getClass();
        if (!Good.isValidCategory(category)) {
            throw new IllegalArgumentException("category: " + category + " not valid.");
        }
        this.category = category;
    }

    Good(String name, Class classType, String category) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        this.name = name.trim().toLowerCase();
        if (classType == null) {
            throw new IllegalArgumentException("classType cannot be null.");
        }
        this.classType = classType;
        if (!Good.isValidCategory(category)) {
            throw new IllegalArgumentException("category: " + category + " not valid.");
        }
        this.category = category;
    }

    private static boolean isValidCategory(String category) {
        boolean result = false;
        if (AMOUNT_RESOURCE.equals(category)) {
            result = true;
        } else if (ITEM_RESOURCE.equals(category)) {
            result = true;
        } else if (EQUIPMENT.equals(category)) {
            result = true;
        } else if (VEHICLE.equals(category)) {
            result = true;
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public Class getClassType() {
        return this.classType;
    }

    public Object getObject() {
        return this.object;
    }

    public String getCategory() {
        return this.category;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        boolean result = true;
        if (object instanceof Good) {
            Good good = (Good)object;
            if (!this.name.equals(good.name)) {
                result = false;
            }
            if (!this.classType.equals(good.classType)) {
                result = false;
            }
            if (this.object != null && !this.object.equals(good.object)) {
                result = false;
            }
            if (!this.category.equals(good.category)) {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        int hashCode = this.name.hashCode() * this.getClass().hashCode();
        if (this.object != null) {
            hashCode *= this.object.hashCode();
        }
        return hashCode *= this.category.hashCode();
    }

    @Override
    public int compareTo(Good o) {
        return this.name.compareTo(o.name);
    }
}

