/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.goods;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.equipment.Equipment;
import org.mars_sim.msp.core.equipment.EquipmentFactory;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.ItemResource;
import org.mars_sim.msp.core.resource.Resource;
import org.mars_sim.msp.core.structure.goods.Good;
import org.mars_sim.msp.core.vehicle.LightUtilityVehicle;
import org.mars_sim.msp.core.vehicle.Rover;
import org.mars_sim.msp.core.vehicle.VehicleConfig;

public class GoodsUtil {
    private static List<Good> goodsList;

    private GoodsUtil() {
    }

    public static List<Good> getGoodsList() {
        if (goodsList == null) {
            goodsList = new ArrayList<Good>();
            GoodsUtil.populateGoodsList();
        }
        return Collections.unmodifiableList(goodsList);
    }

    public static Good getResourceGood(Resource resource) {
        if (resource == null) {
            throw new IllegalArgumentException("resource cannot be null");
        }
        String category = null;
        if (resource instanceof AmountResource) {
            category = "amount resource";
        } else if (resource instanceof ItemResource) {
            category = "item resource";
        }
        return new Good(resource.getName(), resource, category);
    }

    public static Good getEquipmentGood(Class<? extends Unit> equipmentClass) {
        if (equipmentClass == null) {
            throw new IllegalArgumentException("goodClass cannot be null");
        }
        Good result = null;
        for (Good good : GoodsUtil.getGoodsList()) {
            if (good.getClassType() != equipmentClass) continue;
            result = new Good(good.getName(), equipmentClass, "equipment");
        }
        return result;
    }

    public static Good getVehicleGood(String vehicleType) {
        if (vehicleType == null || vehicleType.trim().length() == 0) {
            throw new IllegalArgumentException("vehicleType cannot be blank or null.");
        }
        Class vehicleClass = Rover.class;
        if ("Light Utility Vehicle".equalsIgnoreCase(vehicleType)) {
            vehicleClass = LightUtilityVehicle.class;
        }
        return new Good(vehicleType, vehicleClass, "vehicle");
    }

    public static boolean containsGood(Good good) {
        if (good == null) {
            throw new IllegalArgumentException("good cannot be null.");
        }
        return GoodsUtil.getGoodsList().contains(good);
    }

    private static void populateGoodsList() {
        GoodsUtil.populateAmountResources();
        GoodsUtil.populateItemResources();
        GoodsUtil.populateEquipment();
        GoodsUtil.populateVehicles();
        Collections.sort(goodsList);
    }

    private static void populateAmountResources() {
        Iterator<AmountResource> i = AmountResource.getAmountResources().iterator();
        while (i.hasNext()) {
            goodsList.add(GoodsUtil.getResourceGood(i.next()));
        }
    }

    private static void populateItemResources() {
        Iterator<ItemResource> i = ItemResource.getItemResources().iterator();
        while (i.hasNext()) {
            goodsList.add(GoodsUtil.getResourceGood(i.next()));
        }
    }

    private static void populateEquipment() {
        ArrayList<String> equipmentNames = new ArrayList<String>(EquipmentFactory.getEquipmentNames());
        Collections.sort(equipmentNames);
        for (String name : equipmentNames) {
            Class<? extends Equipment> equipmentClass = EquipmentFactory.getEquipmentClass(name);
            goodsList.add(new Good(name, equipmentClass, "equipment"));
        }
    }

    private static void populateVehicles() {
        VehicleConfig config = SimulationConfig.instance().getVehicleConfiguration();
        try {
            Iterator<String> i = config.getVehicleTypes().iterator();
            while (i.hasNext()) {
                goodsList.add(GoodsUtil.getVehicleGood(i.next()));
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public static double getGoodMassPerItem(Good good) {
        double result = 0.0;
        if ("amount resource".equals(good.getCategory())) {
            result = 1.0;
        } else if ("item resource".equals(good.getCategory())) {
            result = ((ItemResource)good.getObject()).getMassPerItem();
        } else if ("equipment".equals(good.getCategory())) {
            result = EquipmentFactory.getEquipmentMass(good.getName());
        } else if ("vehicle".equals(good.getCategory())) {
            VehicleConfig config = SimulationConfig.instance().getVehicleConfiguration();
            result = config.getEmptyMass(good.getName());
        }
        return result;
    }
}

