/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.vehicle;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.mars_sim.msp.core.Direction;
import org.mars_sim.msp.core.LocalAreaUtil;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.mars.SurfaceFeatures;
import org.mars_sim.msp.core.mars.TerrainElevation;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.vehicle.Vehicle;
import org.mars_sim.msp.core.vehicle.VehicleOperator;

public abstract class GroundVehicle
extends Vehicle
implements Serializable {
    public static final String STUCK = "Stuck - using winch";
    private double elevation;
    private double terrainHandlingCapability;
    private boolean isStuck;

    GroundVehicle(String name, String description, Settlement settlement) {
        super(name, description, settlement);
        this.malfunctionManager.addScopeString("GroundVehicle");
        this.setTerrainHandlingCapability(0.0);
        SurfaceFeatures surface = Simulation.instance().getMars().getSurfaceFeatures();
        this.elevation = surface.getSurfaceTerrain().getElevation(this.getCoordinates());
    }

    @Override
    public String getStatus() {
        String status = null;
        status = this.isStuck ? STUCK : super.getStatus();
        return status;
    }

    public double getElevation() {
        return this.elevation;
    }

    public void setElevation(double elevation) {
        this.elevation = elevation;
    }

    public double getTerrainHandlingCapability() {
        return this.terrainHandlingCapability;
    }

    public void setTerrainHandlingCapability(double c) {
        this.terrainHandlingCapability = c;
    }

    public double getTerrainGrade() {
        return this.getTerrainGrade(this.getDirection());
    }

    public double getTerrainGrade(Direction direction) {
        SurfaceFeatures surface = Simulation.instance().getMars().getSurfaceFeatures();
        TerrainElevation terrain = surface.getSurfaceTerrain();
        return terrain.determineTerrainDifficulty(this.getCoordinates(), direction);
    }

    public boolean isStuck() {
        return this.isStuck;
    }

    public void setStuck(boolean stuck) {
        this.isStuck = stuck;
        if (this.isStuck) {
            this.setSpeed(0.0);
            this.setParkedLocation(0.0, 0.0, this.getDirection().getDirection());
        }
    }

    public VehicleOperator getDriver() {
        return this.getOperator();
    }

    public void setDriver(VehicleOperator operator) {
        this.setOperator(operator);
    }

    @Override
    public void determinedSettlementParkedLocationAndFacing() {
        Settlement settlement = this.getSettlement();
        if (settlement == null) {
            throw new IllegalStateException("Vehicle not parked at a settlement");
        }
        double centerXLoc = 0.0;
        double centerYLoc = 0.0;
        List<Building> garageList = settlement.getBuildingManager().getBuildings("Ground Vehicle Maintenance");
        if (garageList.size() >= 1) {
            Collections.shuffle(garageList);
            Building garage = garageList.get(0);
            centerXLoc = garage.getXLocation();
            centerYLoc = garage.getYLocation();
        }
        double newXLoc = 0.0;
        double newYLoc = 0.0;
        double newFacing = 0.0;
        boolean foundGoodLocation = false;
        for (int x = 15; x < 500 && !foundGoodLocation; x += 10) {
            for (int y = 0; y < 10 && !foundGoodLocation; ++y) {
                double distance = RandomUtil.getRandomDouble(10.0) + (double)x;
                double radianDirection = RandomUtil.getRandomDouble(Math.PI * 2);
                newXLoc = centerXLoc - distance * Math.sin(radianDirection);
                newYLoc = centerYLoc + distance * Math.cos(radianDirection);
                newFacing = RandomUtil.getRandomDouble(360.0);
                foundGoodLocation = LocalAreaUtil.checkBoundedObjectNewLocationCollision(this, newXLoc, newYLoc, newFacing, this.getSettlement());
            }
        }
        this.setParkedLocation(newXLoc, newYLoc, newFacing);
    }
}

