/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.vehicle;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.mars_sim.msp.core.Lab;

public class MobileLaboratory
implements Lab,
Serializable {
    private int laboratorySize;
    private int technologyLevel;
    private List<String> techSpecialities;
    private int researcherNum;

    MobileLaboratory(int size, int techLevel, List<String> techSpecialities) {
        this.laboratorySize = size;
        this.technologyLevel = techLevel;
        this.techSpecialities = techSpecialities;
    }

    @Override
    public int getLaboratorySize() {
        return this.laboratorySize;
    }

    @Override
    public int getTechnologyLevel() {
        return this.technologyLevel;
    }

    @Override
    public String[] getTechSpecialities() {
        String[] result = new String[this.techSpecialities.size()];
        Iterator<String> i = this.techSpecialities.iterator();
        int count = 0;
        while (i.hasNext()) {
            result[count] = i.next();
            ++count;
        }
        return result;
    }

    @Override
    public boolean hasSpeciality(String speciality) {
        boolean result = false;
        Iterator<String> i = this.techSpecialities.iterator();
        while (i.hasNext()) {
            if (!speciality.equals(i.next())) continue;
            result = true;
        }
        return result;
    }

    @Override
    public int getResearcherNum() {
        return this.researcherNum;
    }

    @Override
    public void addResearcher() {
        ++this.researcherNum;
        if (this.researcherNum > this.laboratorySize) {
            this.researcherNum = this.laboratorySize;
            throw new IllegalStateException("Lab already full of researchers.");
        }
    }

    @Override
    public void removeResearcher() {
        --this.researcherNum;
        if (this.researcherNum < 0) {
            this.researcherNum = 0;
            throw new IllegalStateException("Lab is already empty of researchers.");
        }
    }

    @Override
    public void destroy() {
        this.techSpecialities.clear();
        this.techSpecialities = null;
    }
}

