/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.vehicle;

import java.awt.geom.Point2D;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Airlock;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.LifeSupport;
import org.mars_sim.msp.core.LocalAreaUtil;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.vehicle.Crewable;
import org.mars_sim.msp.core.vehicle.Vehicle;

public class VehicleAirlock
extends Airlock {
    private static Logger logger = Logger.getLogger(VehicleAirlock.class.getName());
    private Vehicle vehicle;

    public VehicleAirlock(Vehicle vehicle, int capacity) {
        super(capacity);
        if (vehicle == null) {
            throw new IllegalArgumentException("vehicle is null.");
        }
        if (!(vehicle instanceof Crewable)) {
            throw new IllegalArgumentException("vehicle not crewable.");
        }
        if (!(vehicle instanceof LifeSupport)) {
            throw new IllegalArgumentException("vehicle has no life support.");
        }
        this.vehicle = vehicle;
    }

    @Override
    protected void exitAirlock(Person person) {
        if (this.inAirlock(person)) {
            if ("pressurized".equals(this.getState())) {
                this.vehicle.getInventory().storeUnit(person);
                Point2D.Double vehicleLoc = LocalAreaUtil.getRandomInteriorLocation(this.vehicle);
                Point2D.Double settlementLoc = LocalAreaUtil.getLocalRelativeLocation(vehicleLoc.getX(), vehicleLoc.getY(), this.vehicle);
                person.setXLocation(settlementLoc.getX());
                person.setYLocation(settlementLoc.getY());
            } else if ("depressurized".equals(this.getState())) {
                this.vehicle.getInventory().retrieveUnit(person);
                Point2D.Double vehicleLoc = LocalAreaUtil.getRandomExteriorLocation(this.vehicle, 1.0);
                Point2D.Double settlementLoc = LocalAreaUtil.getLocalRelativeLocation(vehicleLoc.getX(), vehicleLoc.getY(), this.vehicle);
                person.setXLocation(settlementLoc.getX());
                person.setYLocation(settlementLoc.getY());
            } else {
                logger.severe("Vehicle airlock in incorrect state for exiting: " + this.getState());
            }
        } else {
            throw new IllegalStateException(person.getName() + " not in airlock of " + this.getEntityName());
        }
    }

    @Override
    public String getEntityName() {
        return this.vehicle.getName();
    }

    @Override
    public Inventory getEntityInventory() {
        return this.vehicle.getInventory();
    }

    @Override
    public Object getEntity() {
        return this.vehicle;
    }
}

