/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.ClassFabUtils;
import org.apache.tapestry5.services.UpdateListener;
import org.slf4j.Logger;

public abstract class AbstractReloadableObjectCreator
implements ObjectCreator,
UpdateListener {
    private final ClassLoader baseClassLoader;
    private final String implementationClassName;
    private final String classFilePath;
    private final Logger logger;
    private final OperationTracker tracker;
    private Object instance;
    private File classFile;
    private long lastModifiedTimestamp = 0L;
    private boolean firstTime = true;

    protected AbstractReloadableObjectCreator(ClassLoader baseClassLoader, String implementationClassName, Logger logger, OperationTracker tracker) {
        this.baseClassLoader = baseClassLoader;
        this.implementationClassName = implementationClassName;
        this.logger = logger;
        this.tracker = tracker;
        this.classFilePath = ClassFabUtils.getPathForClassNamed(implementationClassName);
    }

    public synchronized void checkForUpdates() {
        if (this.instance == null) {
            return;
        }
        if (this.classFile.lastModified() == this.lastModifiedTimestamp) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Implementation class %s has changed and will be reloaded on next use.", this.implementationClassName));
        }
        this.instance = null;
        this.classFile = null;
        this.lastModifiedTimestamp = 0L;
    }

    public synchronized Object createObject() {
        if (this.instance == null) {
            this.instance = this.createInstance();
        }
        return this.instance;
    }

    private Object createInstance() {
        return this.tracker.invoke(String.format("Reloading class %s.", this.implementationClassName), new Invokable<Object>(){

            @Override
            public Object invoke() {
                AbstractReloadableObjectCreator.this.updateTrackingInfo();
                Class reloadedClass = AbstractReloadableObjectCreator.this.reloadImplementationClass();
                return AbstractReloadableObjectCreator.this.createInstance(reloadedClass);
            }
        });
    }

    protected abstract Object createInstance(Class var1);

    private Class reloadImplementationClass() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("%s class %s.", this.firstTime ? "Loading" : "Reloading", this.implementationClassName));
        }
        ReloadingClassLoader reloadingClassLoader = new ReloadingClassLoader(this.baseClassLoader);
        try {
            Class<?> result = ((ClassLoader)reloadingClassLoader).loadClass(this.implementationClassName);
            this.firstTime = false;
            return result;
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(String.format("Unable to %s class %s: %s", this.firstTime ? "load" : "reload", this.implementationClassName, InternalUtils.toMessage(ex)), ex);
        }
    }

    private byte[] readClassData(String name) throws ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[10000];
        URL url = this.getURLForClass(name);
        InputStream in = null;
        try {
            int length;
            in = url.openStream();
            while ((length = in.read(buffer)) >= 0) {
                baos.write(buffer, 0, length);
            }
            in.close();
            in = null;
        }
        catch (IOException ex) {
            InternalUtils.close(in);
            throw new ClassNotFoundException(InternalUtils.toMessage(ex), ex);
        }
        return baos.toByteArray();
    }

    private URL getURLForClass(String className) throws ClassNotFoundException {
        String path = ClassFabUtils.getPathForClassNamed(className);
        URL result = this.baseClassLoader.getResource(path);
        if (result == null) {
            throw new ClassNotFoundException(String.format("Unable to locate URL for class %s.", className));
        }
        return result;
    }

    private void updateTrackingInfo() {
        URL url = this.baseClassLoader.getResource(this.classFilePath);
        if (url == null) {
            throw new RuntimeException(String.format("Unable to reload class %s as it has been deleted. You may need to restart the application.", this.implementationClassName));
        }
        this.classFile = ClassFabUtils.toFileFromFileProtocolURL(url);
        this.lastModifiedTimestamp = this.classFile.lastModified();
    }

    public long getLastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReloadingClassLoader
    extends ClassLoader {
        private ReloadingClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (this.isReloadingClass(name)) {
                byte[] classData = AbstractReloadableObjectCreator.this.readClassData(name);
                return this.defineClass(name, classData, 0, classData.length);
            }
            return super.loadClass(name);
        }

        private boolean isReloadingClass(String name) {
            return name.equals(AbstractReloadableObjectCreator.this.implementationClassName) || name.startsWith(AbstractReloadableObjectCreator.this.implementationClassName + "$");
        }
    }
}

