/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.internal.OperationTrackerImpl;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerThreadOperationTracker
implements OperationTracker {
    private final Logger logger;
    private final ThreadLocal<OperationTrackerImpl> perThread = new ThreadLocal<OperationTrackerImpl>(){

        @Override
        protected OperationTrackerImpl initialValue() {
            return new OperationTrackerImpl(PerThreadOperationTracker.this.logger);
        }
    };

    public PerThreadOperationTracker(Logger logger) {
        this.logger = logger;
    }

    synchronized OperationTracker get() {
        return this.perThread.get();
    }

    synchronized void cleanup() {
        if (this.perThread.get().isEmpty()) {
            this.perThread.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(String description, Runnable operation) {
        try {
            this.get().run(description, operation);
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T invoke(String description, Invokable<T> operation) {
        try {
            T t = this.get().invoke(description, operation);
            return t;
        }
        finally {
            this.cleanup();
        }
    }
}

