/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.tapestry5.ioc.ServiceBuilderResources;
import org.apache.tapestry5.ioc.internal.AbstractServiceCreator;
import org.apache.tapestry5.ioc.internal.IOCMessages;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;

public class ServiceBuilderMethodInvoker
extends AbstractServiceCreator {
    private final Method builderMethod;

    public ServiceBuilderMethodInvoker(ServiceBuilderResources resources, String creatorDescription, Method method) {
        super(resources, creatorDescription);
        this.builderMethod = method;
    }

    public Object createObject() {
        Object moduleInstance = InternalUtils.isStatic(this.builderMethod) ? null : this.resources.getModuleBuilder();
        Object result = null;
        Throwable failure = null;
        try {
            Object[] parameters = InternalUtils.calculateParametersForMethod(this.builderMethod, this.resources, this.createInjectionResources(), this.resources.getTracker());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(IOCMessages.invokingMethod(this.creatorDescription));
            }
            result = this.builderMethod.invoke(moduleInstance, parameters);
        }
        catch (InvocationTargetException ite) {
            failure = ite.getTargetException();
        }
        catch (Exception ex) {
            failure = ex;
        }
        if (failure != null) {
            throw new RuntimeException(IOCMessages.builderMethodError(this.creatorDescription, this.serviceId, failure), failure);
        }
        if (result == null) {
            throw new RuntimeException(IOCMessages.builderMethodReturnedNull(this.creatorDescription, this.serviceId));
        }
        return result;
    }

    public String toString() {
        return this.creatorDescription;
    }
}

