/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.tapestry5.ioc.ModuleBuilderSource;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.def.StartupDef;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.internal.util.MapInjectionResources;
import org.slf4j.Logger;

public class StartupDefImpl
implements StartupDef {
    private final Method startupMethod;

    public StartupDefImpl(Method startupMethod) {
        this.startupMethod = startupMethod;
    }

    public void startup(ModuleBuilderSource moduleSource, ObjectLocator locator, OperationTracker tracker, Logger logger) {
        Map<Class, Object> resourceMap = CollectionFactory.newMap();
        resourceMap.put(ObjectLocator.class, locator);
        resourceMap.put(Logger.class, logger);
        MapInjectionResources injectionResources = new MapInjectionResources(resourceMap);
        Throwable fail = null;
        Object moduleInstance = InternalUtils.isStatic(this.startupMethod) ? null : moduleSource.getModuleBuilder();
        try {
            Object[] parameters = InternalUtils.calculateParametersForMethod(this.startupMethod, locator, injectionResources, tracker);
            this.startupMethod.invoke(moduleInstance, parameters);
        }
        catch (InvocationTargetException ex) {
            fail = ex.getTargetException();
        }
        catch (Exception ex) {
            fail = ex;
        }
        if (fail != null) {
            throw new RuntimeException(String.format("Error invoking startup method %s: %s", InternalUtils.asString(this.startupMethod), InternalUtils.toMessage(fail)), fail);
        }
    }
}

