/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Formatter;
import java.util.Map;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.MemberValueVisitor;
import org.apache.tapestry5.ioc.internal.services.AbstractFab;
import org.apache.tapestry5.ioc.internal.services.AnnotationMemberValueVisitor;
import org.apache.tapestry5.ioc.internal.services.CtClassSource;
import org.apache.tapestry5.ioc.internal.services.ServiceMessages;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.ClassFab;
import org.apache.tapestry5.ioc.services.ClassFabUtils;
import org.apache.tapestry5.ioc.services.MethodIterator;
import org.apache.tapestry5.ioc.services.MethodSignature;
import org.slf4j.Logger;

public class ClassFabImpl
extends AbstractFab
implements ClassFab {
    private static final Map<Class, String> DEFAULT_RETURN = CollectionFactory.newMap();
    private final StringBuilder description = new StringBuilder();
    private final Formatter formatter = new Formatter(this.description);
    private final Set<MethodSignature> addedSignatures = CollectionFactory.newSet();

    public ClassFabImpl(CtClassSource source, CtClass ctClass, Logger logger) {
        super(source, ctClass, logger);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("ClassFab[\n");
        try {
            buffer.append(this.buildClassAndInheritance());
            buffer.append(this.description.toString());
        }
        catch (Exception ex) {
            buffer.append(" *** ");
            buffer.append(ex);
        }
        buffer.append("\n]");
        return buffer.toString();
    }

    private String buildClassAndInheritance() throws NotFoundException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(Modifier.toString(this.getCtClass().getModifiers()));
        buffer.append(" class ");
        buffer.append(this.getName());
        buffer.append(" extends ");
        buffer.append(this.getCtClass().getSuperclass().getName());
        buffer.append("\n");
        CtClass[] interfaces = this.getCtClass().getInterfaces();
        if (interfaces.length > 0) {
            buffer.append("  implements ");
            for (int i = 0; i < interfaces.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(interfaces[i].getName());
            }
            buffer.append("\n\n");
        }
        return buffer.toString();
    }

    String getName() {
        return this.getCtClass().getName();
    }

    public void addField(String name, Class type) {
        this.addField(name, 2, type);
    }

    public void addField(String name, int modifiers, Class type) {
        this.lock.check();
        CtClass ctType = this.toCtClass(type);
        try {
            CtField field = new CtField(ctType, name, this.getCtClass());
            field.setModifiers(modifiers);
            this.getCtClass().addField(field);
        }
        catch (CannotCompileException ex) {
            throw new RuntimeException(ServiceMessages.unableToAddField(name, this.getCtClass(), ex), ex);
        }
        this.formatter.format("%s %s %s;\n\n", Modifier.toString(modifiers), ClassFabUtils.toJavaClassName(type), name);
    }

    public void proxyMethodsToDelegate(Class serviceInterface, String delegateExpression, String toString) {
        this.lock.check();
        this.addInterface(serviceInterface);
        MethodIterator mi = new MethodIterator(serviceInterface);
        while (mi.hasNext()) {
            MethodSignature sig = mi.next();
            String body = String.format("return ($r) %s.%s($$);", delegateExpression, sig.getName());
            this.addMethod(1, sig, body);
        }
        if (!mi.getToString()) {
            this.addToString(toString);
        }
    }

    public void addToString(String toString) {
        this.lock.check();
        MethodSignature sig = new MethodSignature(String.class, "toString", null, null);
        this.addMethod(1, sig, String.format("return \"%s\";", toString));
    }

    public void addMethod(int modifiers, MethodSignature ms, String body) {
        this.lock.check();
        if (this.addedSignatures.contains(ms)) {
            throw new RuntimeException(ServiceMessages.duplicateMethodInClass(ms, this));
        }
        CtClass ctReturnType = this.toCtClass(ms.getReturnType());
        CtClass[] ctParameters = this.toCtClasses(ms.getParameterTypes());
        CtClass[] ctExceptions = this.toCtClasses(ms.getExceptionTypes());
        CtMethod method = new CtMethod(ctReturnType, ms.getName(), ctParameters, this.getCtClass());
        try {
            method.setModifiers(modifiers);
            method.setBody(body);
            method.setExceptionTypes(ctExceptions);
            this.getCtClass().addMethod(method);
        }
        catch (Exception ex) {
            throw new RuntimeException(ServiceMessages.unableToAddMethod(ms, this.getCtClass(), ex), ex);
        }
        this.addedSignatures.add(ms);
        this.formatter.format("%s %s %s", Modifier.toString(modifiers), ClassFabUtils.toJavaClassName(ms.getReturnType()), ms.getName());
        this.addMethodDetailsToDescription(ms.getParameterTypes(), ms.getExceptionTypes(), body);
        this.description.append("\n\n");
    }

    public void addNoOpMethod(MethodSignature signature) {
        this.lock.check();
        Class returnType = signature.getReturnType();
        if (returnType.equals(Void.TYPE)) {
            this.addMethod(1, signature, "return;");
            return;
        }
        String value = "null";
        if (returnType.isPrimitive() && (value = DEFAULT_RETURN.get(returnType)) == null) {
            value = "0";
        }
        this.addMethod(1, signature, "return " + value + ";");
    }

    public void addConstructor(Class[] parameterTypes, Class[] exceptions, String body) {
        assert (InternalUtils.isNonBlank(body));
        this.lock.check();
        CtClass[] ctParameters = this.toCtClasses(parameterTypes);
        CtClass[] ctExceptions = this.toCtClasses(exceptions);
        try {
            CtConstructor constructor = new CtConstructor(ctParameters, this.getCtClass());
            constructor.setExceptionTypes(ctExceptions);
            constructor.setBody(body);
            this.getCtClass().addConstructor(constructor);
        }
        catch (Exception ex) {
            throw new RuntimeException(ServiceMessages.unableToAddConstructor(this.getCtClass(), ex), ex);
        }
        this.description.append("public ");
        this.description.append(this.getName());
        this.addMethodDetailsToDescription(parameterTypes, exceptions, body);
        this.description.append("\n\n");
    }

    private void addMethodDetailsToDescription(Class[] parameterTypes, Class[] exceptions, String body) {
        int i;
        this.description.append("(");
        int count = InternalUtils.size(parameterTypes);
        for (i = 0; i < count; ++i) {
            if (i > 0) {
                this.description.append(", ");
            }
            this.description.append(ClassFabUtils.toJavaClassName(parameterTypes[i]));
            this.description.append(" $");
            this.description.append(i + 1);
        }
        this.description.append(")");
        count = InternalUtils.size(exceptions);
        for (i = 0; i < count; ++i) {
            if (i == 0) {
                this.description.append("\n  throws ");
            } else {
                this.description.append(", ");
            }
            this.description.append(exceptions[i].getName());
        }
        this.description.append("\n");
        this.description.append(body);
    }

    public void copyClassAnnotationsFromDelegate(Class delegateClass) {
        this.lock.check();
        for (Annotation annotation : delegateClass.getAnnotations()) {
            try {
                this.addAnnotation(annotation);
            }
            catch (RuntimeException ex) {
                this.getLogger().error(String.format("Failed to copy annotation '%s' from '%s'", annotation.annotationType(), delegateClass.getName()));
            }
        }
    }

    public void copyMethodAnnotationsFromDelegate(Class serviceInterface, Class delegateClass) {
        this.lock.check();
        for (MethodSignature sig : this.addedSignatures) {
            Annotation[] annotations;
            if (this.getMethod(sig, serviceInterface) == null) continue;
            Method method = this.getMethod(sig, delegateClass);
            assert (method != null);
            for (Annotation annotation : annotations = method.getAnnotations()) {
                try {
                    this.addMethodAnnotation(this.getCtMethod(sig), annotation);
                }
                catch (RuntimeException ex) {
                    this.getLogger().error(String.format("Failed to copy annotation '%s' from method '%s' of class '%s'", annotation.annotationType(), method.getName(), delegateClass.getName()));
                }
            }
        }
    }

    private CtMethod getCtMethod(MethodSignature sig) {
        try {
            return this.getCtClass().getDeclaredMethod(sig.getName(), this.toCtClasses(sig.getParameterTypes()));
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Method getMethod(MethodSignature sig, Class clazz) {
        try {
            return clazz.getMethod(sig.getName(), sig.getParameterTypes());
        }
        catch (Exception e) {
            return null;
        }
    }

    private void addAnnotation(Annotation annotation) {
        ClassFile classFile = this.getClassFile();
        AnnotationsAttribute attribute = (AnnotationsAttribute)classFile.getAttribute("RuntimeVisibleAnnotations");
        if (attribute == null) {
            attribute = new AnnotationsAttribute(this.getConstPool(), "RuntimeVisibleAnnotations");
        }
        javassist.bytecode.annotation.Annotation copy = this.toJavassistAnnotation(annotation);
        attribute.addAnnotation(copy);
        classFile.addAttribute((AttributeInfo)attribute);
    }

    private void addMethodAnnotation(CtMethod ctMethod, Annotation annotation) {
        MethodInfo methodInfo = ctMethod.getMethodInfo();
        AnnotationsAttribute attribute = (AnnotationsAttribute)methodInfo.getAttribute("RuntimeVisibleAnnotations");
        if (attribute == null) {
            attribute = new AnnotationsAttribute(this.getConstPool(), "RuntimeVisibleAnnotations");
        }
        javassist.bytecode.annotation.Annotation copy = this.toJavassistAnnotation(annotation);
        attribute.addAnnotation(copy);
        methodInfo.addAttribute((AttributeInfo)attribute);
    }

    private ClassFile getClassFile() {
        return this.getCtClass().getClassFile();
    }

    private ConstPool getConstPool() {
        return this.getClassFile().getConstPool();
    }

    private javassist.bytecode.annotation.Annotation toJavassistAnnotation(Annotation source) {
        Method[] methods;
        Class<? extends Annotation> annotationType = source.annotationType();
        ConstPool constPool = this.getConstPool();
        javassist.bytecode.annotation.Annotation copy = new javassist.bytecode.annotation.Annotation(annotationType.getName(), constPool);
        for (Method method : methods = annotationType.getDeclaredMethods()) {
            try {
                CtClass ctType = this.toCtClass(method.getReturnType());
                MemberValue memberValue = javassist.bytecode.annotation.Annotation.createMemberValue((ConstPool)constPool, (CtClass)ctType);
                Object value = method.invoke((Object)source, new Object[0]);
                memberValue.accept((MemberValueVisitor)new AnnotationMemberValueVisitor(constPool, this.getSource(), value));
                copy.addMemberValue(method.getName(), memberValue);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return copy;
    }

    static {
        DEFAULT_RETURN.put(Boolean.TYPE, "false");
        DEFAULT_RETURN.put(Long.TYPE, "0L");
        DEFAULT_RETURN.put(Float.TYPE, "0.0f");
        DEFAULT_RETURN.put(Double.TYPE, "0.0d");
    }
}

