/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import org.apache.tapestry5.ioc.Location;
import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.internal.services.ClassFabImpl;
import org.apache.tapestry5.ioc.internal.services.ClassFactoryClassPool;
import org.apache.tapestry5.ioc.internal.services.CtClassSource;
import org.apache.tapestry5.ioc.internal.services.CtClassSourceImpl;
import org.apache.tapestry5.ioc.internal.services.ServiceMessages;
import org.apache.tapestry5.ioc.internal.services.StringLocation;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.ClassFab;
import org.apache.tapestry5.ioc.services.ClassFabUtils;
import org.apache.tapestry5.ioc.services.ClassFactory;
import org.apache.tapestry5.ioc.services.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFactoryImpl
implements ClassFactory {
    private final Logger logger;
    private final ClassFactoryClassPool pool;
    private final CtClassSource classSource;
    private final ClassLoader loader;

    public ClassFactoryImpl(ClassLoader classLoader) {
        this(classLoader, LoggerFactory.getLogger(ClassFactoryImpl.class));
    }

    public ClassFactoryImpl() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ClassFactoryImpl(ClassLoader classLoader, Logger log) {
        this(classLoader, new ClassFactoryClassPool(classLoader), log);
    }

    public ClassFactoryImpl(ClassLoader classLoader, ClassFactoryClassPool pool, Logger logger) {
        this(classLoader, pool, new CtClassSourceImpl(pool, classLoader), logger);
    }

    public ClassFactoryImpl(ClassLoader classLoader, ClassFactoryClassPool pool, CtClassSource classSource, Logger logger) {
        this.loader = classLoader;
        this.pool = pool;
        this.classSource = classSource;
        this.logger = logger;
    }

    @Override
    public ClassFab newClass(Class serviceInterface) {
        String name = ClassFabUtils.generateClassName(serviceInterface);
        ClassFab cf = this.newClass(name, Object.class);
        cf.addInterface(serviceInterface);
        return cf;
    }

    @Override
    public ClassFab newClass(String name, Class superClass) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Create ClassFab for %s (extends %s)", name, superClass.getName()));
        }
        try {
            CtClass ctNewClass = this.classSource.newClass(name, superClass);
            return new ClassFabImpl(this.classSource, ctNewClass, this.logger);
        }
        catch (Exception ex) {
            throw new RuntimeException(ServiceMessages.unableToCreateClass(name, superClass, ex), ex);
        }
    }

    @Override
    public Class importClass(Class clazz) {
        return this.pool.importClass(clazz);
    }

    @Override
    public int getCreatedClassCount() {
        return this.classSource.getCreatedClassCount();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.loader;
    }

    @Override
    public Location getMethodLocation(Method method) {
        assert (method != null);
        Class<?> declaringClass = method.getDeclaringClass();
        Class effectiveClass = this.importClass(declaringClass);
        CtClass ctClass = this.classSource.toCtClass(effectiveClass);
        StringBuilder builder = new StringBuilder("(");
        for (Class<?> parameterType : method.getParameterTypes()) {
            builder.append(ClassFabUtils.getTypeCode(parameterType));
        }
        builder.append(")");
        builder.append(ClassFabUtils.getTypeCode(method.getReturnType()));
        try {
            CtMethod ctMethod = ctClass.getMethod(method.getName(), builder.toString());
            int lineNumber = ctMethod.getMethodInfo().getLineNumber(0);
            String sourceFile = ctMethod.getDeclaringClass().getClassFile2().getSourceFile();
            String description = String.format("%s (at %s:%d)", InternalUtils.asString(method), sourceFile, lineNumber);
            return new StringLocation(description, lineNumber);
        }
        catch (Exception ex) {
            return new StringLocation(InternalUtils.asString(method), 0);
        }
    }

    @Override
    public Location getConstructorLocation(Constructor constructor) {
        assert (constructor != null);
        StringBuilder builder = new StringBuilder();
        Class declaringClass = constructor.getDeclaringClass();
        builder.append(declaringClass.getName());
        builder.append("(");
        CtClass ctClass = this.classSource.toCtClass(declaringClass);
        StringBuilder descripton = new StringBuilder("(");
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(parameterType.getSimpleName());
            descripton.append(ClassFabUtils.getTypeCode(parameterType));
        }
        builder.append(")");
        descripton.append(")V");
        int lineNumber = 0;
        try {
            CtConstructor ctConstructor = ctClass.getConstructor(descripton.toString());
            lineNumber = ctConstructor.getMethodInfo().getLineNumber(0);
            String sourceFile = ctConstructor.getDeclaringClass().getClassFile2().getSourceFile();
            builder.append(String.format(" (at %s:%d)", sourceFile, lineNumber));
        }
        catch (Exception ex) {
            // empty catch block
        }
        return new StringLocation(builder.toString(), lineNumber);
    }

    @Override
    public <T> T createProxy(Class<T> proxyInterface, ObjectCreator delegateCreator, String description) {
        return this.createProxy(proxyInterface, null, delegateCreator, description);
    }

    @Override
    public <T> T createProxy(Class<T> proxyInterface, Class<? extends T> delegateClass, ObjectCreator delegateCreator, String description) {
        ClassFab classFab = this.newClass(proxyInterface);
        classFab.addField("_creator", 18, ObjectCreator.class);
        classFab.addConstructor(new Class[]{ObjectCreator.class}, null, "_creator = $1;");
        String body = String.format("return (%s) _creator.createObject();", proxyInterface.getName());
        MethodSignature sig = new MethodSignature(proxyInterface, "_delegate", null, null);
        classFab.addMethod(2, sig, body);
        classFab.proxyMethodsToDelegate(proxyInterface, "_delegate()", description);
        if (delegateClass != null) {
            classFab.copyClassAnnotationsFromDelegate(delegateClass);
            classFab.copyMethodAnnotationsFromDelegate(proxyInterface, delegateClass);
        }
        Class proxyClass = classFab.createClass();
        try {
            Object proxy = proxyClass.getConstructors()[0].newInstance(delegateCreator);
            return proxyInterface.cast(proxy);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }
}

