/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.config.model.building;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.mars_sim.msp.config.model.building.ParkingLocation;
import org.xml.sax.ContentHandler;

public class GroundVehicleMaintenance
implements Serializable {
    private long _vehicleCapacity;
    private boolean _has_vehicleCapacity;
    private List<ParkingLocation> _parkingLocationList = new ArrayList<ParkingLocation>();

    public void addParkingLocation(ParkingLocation vParkingLocation) throws IndexOutOfBoundsException {
        this._parkingLocationList.add(vParkingLocation);
    }

    public void addParkingLocation(int index, ParkingLocation vParkingLocation) throws IndexOutOfBoundsException {
        this._parkingLocationList.add(index, vParkingLocation);
    }

    public void deleteVehicleCapacity() {
        this._has_vehicleCapacity = false;
    }

    public Enumeration<? extends ParkingLocation> enumerateParkingLocation() {
        return Collections.enumeration(this._parkingLocationList);
    }

    public ParkingLocation getParkingLocation(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._parkingLocationList.size()) {
            throw new IndexOutOfBoundsException("getParkingLocation: Index value '" + index + "' not in range [0.." + (this._parkingLocationList.size() - 1) + "]");
        }
        return this._parkingLocationList.get(index);
    }

    public ParkingLocation[] getParkingLocation() {
        ParkingLocation[] array = new ParkingLocation[]{};
        return this._parkingLocationList.toArray(array);
    }

    public int getParkingLocationCount() {
        return this._parkingLocationList.size();
    }

    public long getVehicleCapacity() {
        return this._vehicleCapacity;
    }

    public boolean hasVehicleCapacity() {
        return this._has_vehicleCapacity;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<? extends ParkingLocation> iterateParkingLocation() {
        return this._parkingLocationList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllParkingLocation() {
        this._parkingLocationList.clear();
    }

    public boolean removeParkingLocation(ParkingLocation vParkingLocation) {
        boolean removed = this._parkingLocationList.remove(vParkingLocation);
        return removed;
    }

    public ParkingLocation removeParkingLocationAt(int index) {
        ParkingLocation obj = this._parkingLocationList.remove(index);
        return obj;
    }

    public void setParkingLocation(int index, ParkingLocation vParkingLocation) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._parkingLocationList.size()) {
            throw new IndexOutOfBoundsException("setParkingLocation: Index value '" + index + "' not in range [0.." + (this._parkingLocationList.size() - 1) + "]");
        }
        this._parkingLocationList.set(index, vParkingLocation);
    }

    public void setParkingLocation(ParkingLocation[] vParkingLocationArray) {
        this._parkingLocationList.clear();
        for (int i = 0; i < vParkingLocationArray.length; ++i) {
            this._parkingLocationList.add(vParkingLocationArray[i]);
        }
    }

    public void setVehicleCapacity(long vehicleCapacity) {
        this._vehicleCapacity = vehicleCapacity;
        this._has_vehicleCapacity = true;
    }

    public static GroundVehicleMaintenance unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (GroundVehicleMaintenance)Unmarshaller.unmarshal(GroundVehicleMaintenance.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

