/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.config.model.construction;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.mars_sim.msp.config.model.construction.Frame;
import org.xml.sax.ContentHandler;

public class FrameList
implements Serializable {
    private List<Frame> _frameList = new ArrayList<Frame>();

    public void addFrame(Frame vFrame) throws IndexOutOfBoundsException {
        this._frameList.add(vFrame);
    }

    public void addFrame(int index, Frame vFrame) throws IndexOutOfBoundsException {
        this._frameList.add(index, vFrame);
    }

    public Enumeration<? extends Frame> enumerateFrame() {
        return Collections.enumeration(this._frameList);
    }

    public Frame getFrame(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._frameList.size()) {
            throw new IndexOutOfBoundsException("getFrame: Index value '" + index + "' not in range [0.." + (this._frameList.size() - 1) + "]");
        }
        return this._frameList.get(index);
    }

    public Frame[] getFrame() {
        Frame[] array = new Frame[]{};
        return this._frameList.toArray(array);
    }

    public int getFrameCount() {
        return this._frameList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<? extends Frame> iterateFrame() {
        return this._frameList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllFrame() {
        this._frameList.clear();
    }

    public boolean removeFrame(Frame vFrame) {
        boolean removed = this._frameList.remove(vFrame);
        return removed;
    }

    public Frame removeFrameAt(int index) {
        Frame obj = this._frameList.remove(index);
        return obj;
    }

    public void setFrame(int index, Frame vFrame) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._frameList.size()) {
            throw new IndexOutOfBoundsException("setFrame: Index value '" + index + "' not in range [0.." + (this._frameList.size() - 1) + "]");
        }
        this._frameList.set(index, vFrame);
    }

    public void setFrame(Frame[] vFrameArray) {
        this._frameList.clear();
        for (int i = 0; i < vFrameArray.length; ++i) {
            this._frameList.add(vFrameArray[i]);
        }
    }

    public static FrameList unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (FrameList)Unmarshaller.unmarshal(FrameList.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

