/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.config.model.people;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.mars_sim.msp.config.model.people.Skill;
import org.xml.sax.ContentHandler;

public class SkillList
implements Serializable {
    private List<Skill> _skillList = new ArrayList<Skill>();

    public void addSkill(Skill vSkill) throws IndexOutOfBoundsException {
        this._skillList.add(vSkill);
    }

    public void addSkill(int index, Skill vSkill) throws IndexOutOfBoundsException {
        this._skillList.add(index, vSkill);
    }

    public Enumeration<? extends Skill> enumerateSkill() {
        return Collections.enumeration(this._skillList);
    }

    public Skill getSkill(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._skillList.size()) {
            throw new IndexOutOfBoundsException("getSkill: Index value '" + index + "' not in range [0.." + (this._skillList.size() - 1) + "]");
        }
        return this._skillList.get(index);
    }

    public Skill[] getSkill() {
        Skill[] array = new Skill[]{};
        return this._skillList.toArray(array);
    }

    public int getSkillCount() {
        return this._skillList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<? extends Skill> iterateSkill() {
        return this._skillList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllSkill() {
        this._skillList.clear();
    }

    public boolean removeSkill(Skill vSkill) {
        boolean removed = this._skillList.remove(vSkill);
        return removed;
    }

    public Skill removeSkillAt(int index) {
        Skill obj = this._skillList.remove(index);
        return obj;
    }

    public void setSkill(int index, Skill vSkill) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._skillList.size()) {
            throw new IndexOutOfBoundsException("setSkill: Index value '" + index + "' not in range [0.." + (this._skillList.size() - 1) + "]");
        }
        this._skillList.set(index, vSkill);
    }

    public void setSkill(Skill[] vSkillArray) {
        this._skillList.clear();
        for (int i = 0; i < vSkillArray.length; ++i) {
            this._skillList.add(vSkillArray[i]);
        }
    }

    public static SkillList unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (SkillList)Unmarshaller.unmarshal(SkillList.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

