/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.config.model.settlement;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.mars_sim.msp.config.model.settlement.Building;
import org.mars_sim.msp.config.model.settlement.Equipment;
import org.mars_sim.msp.config.model.settlement.Part;
import org.mars_sim.msp.config.model.settlement.PartPackage;
import org.mars_sim.msp.config.model.settlement.Resource;
import org.mars_sim.msp.config.model.settlement.Resupply;
import org.mars_sim.msp.config.model.settlement.Vehicle;
import org.xml.sax.ContentHandler;

public class Template
implements Serializable {
    private String _name;
    private long _defaultPopulation;
    private boolean _has_defaultPopulation;
    private List<Building> _buildingList = new ArrayList<Building>();
    private List<Vehicle> _vehicleList = new ArrayList<Vehicle>();
    private List<Equipment> _equipmentList = new ArrayList<Equipment>();
    private List<Resource> _resourceList = new ArrayList<Resource>();
    private List<Part> _partList = new ArrayList<Part>();
    private List<PartPackage> _partPackageList = new ArrayList<PartPackage>();
    private Resupply _resupply;

    public void addBuilding(Building vBuilding) throws IndexOutOfBoundsException {
        this._buildingList.add(vBuilding);
    }

    public void addBuilding(int index, Building vBuilding) throws IndexOutOfBoundsException {
        this._buildingList.add(index, vBuilding);
    }

    public void addEquipment(Equipment vEquipment) throws IndexOutOfBoundsException {
        this._equipmentList.add(vEquipment);
    }

    public void addEquipment(int index, Equipment vEquipment) throws IndexOutOfBoundsException {
        this._equipmentList.add(index, vEquipment);
    }

    public void addPart(Part vPart) throws IndexOutOfBoundsException {
        this._partList.add(vPart);
    }

    public void addPart(int index, Part vPart) throws IndexOutOfBoundsException {
        this._partList.add(index, vPart);
    }

    public void addPartPackage(PartPackage vPartPackage) throws IndexOutOfBoundsException {
        this._partPackageList.add(vPartPackage);
    }

    public void addPartPackage(int index, PartPackage vPartPackage) throws IndexOutOfBoundsException {
        this._partPackageList.add(index, vPartPackage);
    }

    public void addResource(Resource vResource) throws IndexOutOfBoundsException {
        this._resourceList.add(vResource);
    }

    public void addResource(int index, Resource vResource) throws IndexOutOfBoundsException {
        this._resourceList.add(index, vResource);
    }

    public void addVehicle(Vehicle vVehicle) throws IndexOutOfBoundsException {
        this._vehicleList.add(vVehicle);
    }

    public void addVehicle(int index, Vehicle vVehicle) throws IndexOutOfBoundsException {
        this._vehicleList.add(index, vVehicle);
    }

    public void deleteDefaultPopulation() {
        this._has_defaultPopulation = false;
    }

    public Enumeration<? extends Building> enumerateBuilding() {
        return Collections.enumeration(this._buildingList);
    }

    public Enumeration<? extends Equipment> enumerateEquipment() {
        return Collections.enumeration(this._equipmentList);
    }

    public Enumeration<? extends Part> enumeratePart() {
        return Collections.enumeration(this._partList);
    }

    public Enumeration<? extends PartPackage> enumeratePartPackage() {
        return Collections.enumeration(this._partPackageList);
    }

    public Enumeration<? extends Resource> enumerateResource() {
        return Collections.enumeration(this._resourceList);
    }

    public Enumeration<? extends Vehicle> enumerateVehicle() {
        return Collections.enumeration(this._vehicleList);
    }

    public Building getBuilding(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._buildingList.size()) {
            throw new IndexOutOfBoundsException("getBuilding: Index value '" + index + "' not in range [0.." + (this._buildingList.size() - 1) + "]");
        }
        return this._buildingList.get(index);
    }

    public Building[] getBuilding() {
        Building[] array = new Building[]{};
        return this._buildingList.toArray(array);
    }

    public int getBuildingCount() {
        return this._buildingList.size();
    }

    public long getDefaultPopulation() {
        return this._defaultPopulation;
    }

    public Equipment getEquipment(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._equipmentList.size()) {
            throw new IndexOutOfBoundsException("getEquipment: Index value '" + index + "' not in range [0.." + (this._equipmentList.size() - 1) + "]");
        }
        return this._equipmentList.get(index);
    }

    public Equipment[] getEquipment() {
        Equipment[] array = new Equipment[]{};
        return this._equipmentList.toArray(array);
    }

    public int getEquipmentCount() {
        return this._equipmentList.size();
    }

    public String getName() {
        return this._name;
    }

    public Part getPart(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._partList.size()) {
            throw new IndexOutOfBoundsException("getPart: Index value '" + index + "' not in range [0.." + (this._partList.size() - 1) + "]");
        }
        return this._partList.get(index);
    }

    public Part[] getPart() {
        Part[] array = new Part[]{};
        return this._partList.toArray(array);
    }

    public int getPartCount() {
        return this._partList.size();
    }

    public PartPackage getPartPackage(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._partPackageList.size()) {
            throw new IndexOutOfBoundsException("getPartPackage: Index value '" + index + "' not in range [0.." + (this._partPackageList.size() - 1) + "]");
        }
        return this._partPackageList.get(index);
    }

    public PartPackage[] getPartPackage() {
        PartPackage[] array = new PartPackage[]{};
        return this._partPackageList.toArray(array);
    }

    public int getPartPackageCount() {
        return this._partPackageList.size();
    }

    public Resource getResource(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._resourceList.size()) {
            throw new IndexOutOfBoundsException("getResource: Index value '" + index + "' not in range [0.." + (this._resourceList.size() - 1) + "]");
        }
        return this._resourceList.get(index);
    }

    public Resource[] getResource() {
        Resource[] array = new Resource[]{};
        return this._resourceList.toArray(array);
    }

    public int getResourceCount() {
        return this._resourceList.size();
    }

    public Resupply getResupply() {
        return this._resupply;
    }

    public Vehicle getVehicle(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._vehicleList.size()) {
            throw new IndexOutOfBoundsException("getVehicle: Index value '" + index + "' not in range [0.." + (this._vehicleList.size() - 1) + "]");
        }
        return this._vehicleList.get(index);
    }

    public Vehicle[] getVehicle() {
        Vehicle[] array = new Vehicle[]{};
        return this._vehicleList.toArray(array);
    }

    public int getVehicleCount() {
        return this._vehicleList.size();
    }

    public boolean hasDefaultPopulation() {
        return this._has_defaultPopulation;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<? extends Building> iterateBuilding() {
        return this._buildingList.iterator();
    }

    public Iterator<? extends Equipment> iterateEquipment() {
        return this._equipmentList.iterator();
    }

    public Iterator<? extends Part> iteratePart() {
        return this._partList.iterator();
    }

    public Iterator<? extends PartPackage> iteratePartPackage() {
        return this._partPackageList.iterator();
    }

    public Iterator<? extends Resource> iterateResource() {
        return this._resourceList.iterator();
    }

    public Iterator<? extends Vehicle> iterateVehicle() {
        return this._vehicleList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllBuilding() {
        this._buildingList.clear();
    }

    public void removeAllEquipment() {
        this._equipmentList.clear();
    }

    public void removeAllPart() {
        this._partList.clear();
    }

    public void removeAllPartPackage() {
        this._partPackageList.clear();
    }

    public void removeAllResource() {
        this._resourceList.clear();
    }

    public void removeAllVehicle() {
        this._vehicleList.clear();
    }

    public boolean removeBuilding(Building vBuilding) {
        boolean removed = this._buildingList.remove(vBuilding);
        return removed;
    }

    public Building removeBuildingAt(int index) {
        Building obj = this._buildingList.remove(index);
        return obj;
    }

    public boolean removeEquipment(Equipment vEquipment) {
        boolean removed = this._equipmentList.remove(vEquipment);
        return removed;
    }

    public Equipment removeEquipmentAt(int index) {
        Equipment obj = this._equipmentList.remove(index);
        return obj;
    }

    public boolean removePart(Part vPart) {
        boolean removed = this._partList.remove(vPart);
        return removed;
    }

    public Part removePartAt(int index) {
        Part obj = this._partList.remove(index);
        return obj;
    }

    public boolean removePartPackage(PartPackage vPartPackage) {
        boolean removed = this._partPackageList.remove(vPartPackage);
        return removed;
    }

    public PartPackage removePartPackageAt(int index) {
        PartPackage obj = this._partPackageList.remove(index);
        return obj;
    }

    public boolean removeResource(Resource vResource) {
        boolean removed = this._resourceList.remove(vResource);
        return removed;
    }

    public Resource removeResourceAt(int index) {
        Resource obj = this._resourceList.remove(index);
        return obj;
    }

    public boolean removeVehicle(Vehicle vVehicle) {
        boolean removed = this._vehicleList.remove(vVehicle);
        return removed;
    }

    public Vehicle removeVehicleAt(int index) {
        Vehicle obj = this._vehicleList.remove(index);
        return obj;
    }

    public void setBuilding(int index, Building vBuilding) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._buildingList.size()) {
            throw new IndexOutOfBoundsException("setBuilding: Index value '" + index + "' not in range [0.." + (this._buildingList.size() - 1) + "]");
        }
        this._buildingList.set(index, vBuilding);
    }

    public void setBuilding(Building[] vBuildingArray) {
        this._buildingList.clear();
        for (int i = 0; i < vBuildingArray.length; ++i) {
            this._buildingList.add(vBuildingArray[i]);
        }
    }

    public void setDefaultPopulation(long defaultPopulation) {
        this._defaultPopulation = defaultPopulation;
        this._has_defaultPopulation = true;
    }

    public void setEquipment(int index, Equipment vEquipment) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._equipmentList.size()) {
            throw new IndexOutOfBoundsException("setEquipment: Index value '" + index + "' not in range [0.." + (this._equipmentList.size() - 1) + "]");
        }
        this._equipmentList.set(index, vEquipment);
    }

    public void setEquipment(Equipment[] vEquipmentArray) {
        this._equipmentList.clear();
        for (int i = 0; i < vEquipmentArray.length; ++i) {
            this._equipmentList.add(vEquipmentArray[i]);
        }
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setPart(int index, Part vPart) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._partList.size()) {
            throw new IndexOutOfBoundsException("setPart: Index value '" + index + "' not in range [0.." + (this._partList.size() - 1) + "]");
        }
        this._partList.set(index, vPart);
    }

    public void setPart(Part[] vPartArray) {
        this._partList.clear();
        for (int i = 0; i < vPartArray.length; ++i) {
            this._partList.add(vPartArray[i]);
        }
    }

    public void setPartPackage(int index, PartPackage vPartPackage) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._partPackageList.size()) {
            throw new IndexOutOfBoundsException("setPartPackage: Index value '" + index + "' not in range [0.." + (this._partPackageList.size() - 1) + "]");
        }
        this._partPackageList.set(index, vPartPackage);
    }

    public void setPartPackage(PartPackage[] vPartPackageArray) {
        this._partPackageList.clear();
        for (int i = 0; i < vPartPackageArray.length; ++i) {
            this._partPackageList.add(vPartPackageArray[i]);
        }
    }

    public void setResource(int index, Resource vResource) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._resourceList.size()) {
            throw new IndexOutOfBoundsException("setResource: Index value '" + index + "' not in range [0.." + (this._resourceList.size() - 1) + "]");
        }
        this._resourceList.set(index, vResource);
    }

    public void setResource(Resource[] vResourceArray) {
        this._resourceList.clear();
        for (int i = 0; i < vResourceArray.length; ++i) {
            this._resourceList.add(vResourceArray[i]);
        }
    }

    public void setResupply(Resupply resupply) {
        this._resupply = resupply;
    }

    public void setVehicle(int index, Vehicle vVehicle) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._vehicleList.size()) {
            throw new IndexOutOfBoundsException("setVehicle: Index value '" + index + "' not in range [0.." + (this._vehicleList.size() - 1) + "]");
        }
        this._vehicleList.set(index, vVehicle);
    }

    public void setVehicle(Vehicle[] vVehicleArray) {
        this._vehicleList.clear();
        for (int i = 0; i < vVehicleArray.length; ++i) {
            this._vehicleList.add(vVehicleArray[i]);
        }
    }

    public static Template unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Template)Unmarshaller.unmarshal(Template.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

