/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.entity;

import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.imagemap.ToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.URLTagFragmentGenerator;

public class ChartEntity {
    private Shape area;
    private String toolTipText;
    private String urlText;

    public ChartEntity(Shape shape) {
        this(shape, null);
    }

    public ChartEntity(Shape shape, String string) {
        this(shape, string, null);
    }

    public ChartEntity(Shape shape, String string, String string2) {
        this.area = shape;
        this.toolTipText = string;
        this.urlText = string2;
    }

    public Shape getArea() {
        return this.area;
    }

    public void setArea(Shape shape) {
        this.area = shape;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String string) {
        this.toolTipText = string;
    }

    public String getShapeType() {
        if (this.area instanceof Rectangle2D) {
            return "RECT";
        }
        return "POLY";
    }

    public String getShapeCoords() {
        if (this.area instanceof Rectangle2D) {
            return this.getRectCoords((Rectangle2D)this.area);
        }
        return this.getPolyCoords(this.area);
    }

    private String getRectCoords(Rectangle2D rectangle2D) {
        int n = (int)rectangle2D.getX();
        int n2 = (int)rectangle2D.getY();
        int n3 = n + (int)rectangle2D.getWidth();
        int n4 = n2 + (int)rectangle2D.getHeight();
        if (n3 == n) {
            ++n3;
        }
        if (n4 == n2) {
            ++n4;
        }
        return n + "," + n2 + "," + n3 + "," + n4;
    }

    private String getPolyCoords(Shape shape) {
        String string = "";
        boolean bl = true;
        float[] fArray = new float[6];
        PathIterator pathIterator = shape.getPathIterator(null, 1.0);
        while (!pathIterator.isDone()) {
            pathIterator.currentSegment(fArray);
            if (bl) {
                bl = false;
                string = string + (int)fArray[0] + "," + (int)fArray[1];
            } else {
                string = string + "," + (int)fArray[0] + "," + (int)fArray[1];
            }
            pathIterator.next();
        }
        return string;
    }

    public String getImageMapAreaTag(ToolTipTagFragmentGenerator toolTipTagFragmentGenerator, URLTagFragmentGenerator uRLTagFragmentGenerator) {
        boolean bl;
        boolean bl2;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl3 = this.urlText == null ? false : (bl2 = !this.urlText.equals(""));
        boolean bl4 = this.toolTipText == null ? false : (bl = !this.toolTipText.equals(""));
        if (bl2 || bl) {
            stringBuffer.append("<AREA SHAPE=\"" + this.getShapeType() + "\"" + " COORDS=\"" + this.getShapeCoords() + "\"");
            if (bl) {
                stringBuffer.append(toolTipTagFragmentGenerator.generateToolTipFragment(this.toolTipText));
            }
            if (bl2) {
                stringBuffer.append(uRLTagFragmentGenerator.generateURLFragment(this.urlText));
            }
            stringBuffer.append(">");
        }
        return stringBuffer.toString();
    }

    public String getURLText() {
        return this.urlText;
    }

    public void setURLText(String string) {
        this.urlText = string;
    }
}

