/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.data.XYDataset;
import org.jfree.util.PublicCloneable;

public class TimeSeriesToolTipGenerator
implements XYToolTipGenerator,
Cloneable,
PublicCloneable,
Serializable {
    private DateFormat dateFormat;
    private NumberFormat numberFormat;

    public TimeSeriesToolTipGenerator() {
        this(DateFormat.getInstance(), NumberFormat.getNumberInstance());
    }

    public TimeSeriesToolTipGenerator(String string, String string2) {
        this(new SimpleDateFormat(string), new DecimalFormat(string2));
    }

    public TimeSeriesToolTipGenerator(DateFormat dateFormat, NumberFormat numberFormat) {
        this.dateFormat = dateFormat;
        this.numberFormat = numberFormat;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public String generateToolTip(XYDataset xYDataset, int n, int n2) {
        String string = "";
        String string2 = xYDataset.getSeriesName(n);
        if (string2 != null) {
            string = string + string2 + ": ";
        }
        long l = xYDataset.getXValue(n, n2).longValue();
        string = string + "date = " + this.dateFormat.format(new Date(l));
        Number number = xYDataset.getYValue(n, n2);
        string = number != null ? string + ", value = " + this.numberFormat.format(number) : string + ", value = null";
        return string;
    }

    public Object clone() throws CloneNotSupportedException {
        TimeSeriesToolTipGenerator timeSeriesToolTipGenerator = (TimeSeriesToolTipGenerator)super.clone();
        if (this.dateFormat != null) {
            timeSeriesToolTipGenerator.dateFormat = (DateFormat)this.dateFormat.clone();
        }
        if (this.numberFormat != null) {
            timeSeriesToolTipGenerator.numberFormat = (NumberFormat)this.numberFormat.clone();
        }
        return timeSeriesToolTipGenerator;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof TimeSeriesToolTipGenerator) {
            TimeSeriesToolTipGenerator timeSeriesToolTipGenerator = (TimeSeriesToolTipGenerator)object;
            return this.dateFormat.equals(timeSeriesToolTipGenerator.getDateFormat()) && this.numberFormat.equals(timeSeriesToolTipGenerator.getNumberFormat());
        }
        return false;
    }
}

