/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.Marker;
import org.jfree.chart.Spacer;
import org.jfree.chart.annotations.CategoryAnnotation;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisCollection;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.CategoryAnchor;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.axis.ValueTick;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.event.RendererChangeListener;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.renderer.CategoryItemRenderer;
import org.jfree.chart.renderer.CategoryItemRendererState;
import org.jfree.chart.renderer.RangeType;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DatasetChangeEvent;
import org.jfree.data.DatasetUtilities;
import org.jfree.data.Range;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ObjectList;
import org.jfree.util.ObjectUtils;
import org.jfree.util.PublicCloneable;
import org.jfree.util.SortOrder;

public class CategoryPlot
extends Plot
implements ValueAxisPlot,
RendererChangeListener,
Cloneable,
PublicCloneable,
Serializable {
    public static final boolean DEFAULT_DOMAIN_GRIDLINES_VISIBLE = false;
    public static final boolean DEFAULT_RANGE_GRIDLINES_VISIBLE = true;
    public static final Stroke DEFAULT_GRIDLINE_STROKE = new BasicStroke(0.5f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 0.0f);
    public static final Paint DEFAULT_GRIDLINE_PAINT = Color.lightGray;
    public static final Font DEFAULT_VALUE_LABEL_FONT = new Font("SansSerif", 0, 10);
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.plot.LocalizationBundle");
    private PlotOrientation orientation;
    private Spacer axisOffset;
    private CategoryAxis domainAxis;
    private AxisLocation domainAxisLocation;
    private ObjectList secondaryDomainAxes;
    private ObjectList secondaryDomainAxisLocations;
    private boolean drawSharedDomainAxis;
    private ValueAxis rangeAxis;
    private AxisLocation rangeAxisLocation;
    private ObjectList secondaryRangeAxes;
    private ObjectList secondaryRangeAxisLocations;
    private CategoryDataset dataset;
    private ObjectList secondaryDatasets;
    private ObjectList secondaryDatasetDomainAxisMap;
    private ObjectList secondaryDatasetRangeAxisMap;
    private CategoryItemRenderer renderer;
    private ObjectList secondaryRenderers;
    private DatasetRenderingOrder renderingOrder = DatasetRenderingOrder.STANDARD;
    private SortOrder columnRenderingOrder = SortOrder.ASCENDING;
    private SortOrder rowRenderingOrder = SortOrder.ASCENDING;
    private boolean domainGridlinesVisible;
    private CategoryAnchor domainGridlinePosition;
    private transient Stroke domainGridlineStroke;
    private transient Paint domainGridlinePaint;
    private boolean rangeGridlinesVisible;
    private transient Stroke rangeGridlineStroke;
    private transient Paint rangeGridlinePaint;
    private double anchorValue;
    private boolean rangeCrosshairVisible;
    private double rangeCrosshairValue;
    private transient Stroke rangeCrosshairStroke;
    private transient Paint rangeCrosshairPaint;
    private boolean rangeCrosshairLockedOnData = true;
    private transient List foregroundRangeMarkers;
    private transient List backgroundRangeMarkers;
    private transient Map secondaryForegroundRangeMarkers;
    private transient Map secondaryBackgroundRangeMarkers;
    private transient List annotations;
    private int weight;
    private AxisSpace fixedDomainAxisSpace;
    private AxisSpace fixedRangeAxisSpace;

    public CategoryPlot() {
        this(null, null, null, null);
    }

    public CategoryPlot(CategoryDataset categoryDataset, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryItemRenderer categoryItemRenderer) {
        this.orientation = PlotOrientation.VERTICAL;
        this.secondaryDomainAxes = new ObjectList();
        this.secondaryDomainAxisLocations = new ObjectList();
        this.secondaryRangeAxes = new ObjectList();
        this.secondaryRangeAxisLocations = new ObjectList();
        this.secondaryDatasets = new ObjectList();
        this.secondaryDatasetDomainAxisMap = new ObjectList();
        this.secondaryDatasetRangeAxisMap = new ObjectList();
        this.secondaryRenderers = new ObjectList();
        this.dataset = categoryDataset;
        if (categoryDataset != null) {
            categoryDataset.addChangeListener(this);
        }
        this.axisOffset = new Spacer(1, 0.0, 0.0, 0.0, 0.0);
        this.setDomainAxisLocation(AxisLocation.BOTTOM_OR_LEFT, false);
        this.setRangeAxisLocation(AxisLocation.TOP_OR_LEFT, false);
        this.renderer = categoryItemRenderer;
        if (categoryItemRenderer != null) {
            categoryItemRenderer.setPlot(this);
        }
        this.domainAxis = categoryAxis;
        if (categoryAxis != null) {
            categoryAxis.setPlot(this);
            categoryAxis.addChangeListener(this);
        }
        this.drawSharedDomainAxis = false;
        this.rangeAxis = valueAxis;
        if (valueAxis != null) {
            valueAxis.setPlot(this);
            valueAxis.addChangeListener(this);
        }
        this.domainGridlinesVisible = false;
        this.domainGridlinePosition = CategoryAnchor.MIDDLE;
        this.domainGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.domainGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.rangeGridlinesVisible = true;
        this.rangeGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.rangeGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.foregroundRangeMarkers = new ArrayList();
        this.backgroundRangeMarkers = new ArrayList();
        this.secondaryForegroundRangeMarkers = new HashMap();
        this.secondaryBackgroundRangeMarkers = new HashMap();
        Marker marker = new Marker(0.0, new Color(0.8f, 0.8f, 0.8f, 0.5f), new BasicStroke(1.0f), new Color(0.85f, 0.85f, 0.95f, 0.5f), 0.6f);
        this.addRangeMarker(marker, Layer.BACKGROUND);
        this.anchorValue = 0.0;
    }

    public String getPlotType() {
        return localizationResources.getString("Category_Plot");
    }

    public PlotOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(PlotOrientation plotOrientation) {
        if (plotOrientation != this.orientation) {
            this.orientation = plotOrientation;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Spacer getAxisOffset() {
        return this.axisOffset;
    }

    public void setAxisOffset(Spacer spacer) {
        this.axisOffset = spacer;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public CategoryAxis getDomainAxis() {
        Plot plot;
        CategoryAxis categoryAxis = this.domainAxis;
        if (categoryAxis == null && (plot = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            categoryAxis = categoryPlot.getDomainAxis();
        }
        return categoryAxis;
    }

    public void setDomainAxis(CategoryAxis categoryAxis) {
        if (categoryAxis != null) {
            categoryAxis.setPlot(this);
            categoryAxis.addChangeListener(this);
        }
        if (this.domainAxis != null) {
            this.domainAxis.removeChangeListener(this);
        }
        this.domainAxis = categoryAxis;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public AxisLocation getDomainAxisLocation() {
        return this.domainAxisLocation;
    }

    public void setDomainAxisLocation(AxisLocation axisLocation) {
        this.setDomainAxisLocation(axisLocation, true);
    }

    public void setDomainAxisLocation(AxisLocation axisLocation, boolean bl) {
        if (axisLocation != this.domainAxisLocation) {
            this.domainAxisLocation = axisLocation;
            if (bl) {
                this.notifyListeners(new PlotChangeEvent(this));
            }
        }
    }

    public RectangleEdge getDomainAxisEdge() {
        return Plot.resolveDomainAxisLocation(this.domainAxisLocation, this.orientation);
    }

    public CategoryAxis getSecondaryDomainAxis(int n) {
        Plot plot;
        CategoryAxis categoryAxis = null;
        if (n < this.secondaryDomainAxes.size()) {
            categoryAxis = (CategoryAxis)this.secondaryDomainAxes.get(n);
        }
        if (categoryAxis == null && (plot = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            categoryAxis = categoryPlot.getSecondaryDomainAxis(n);
        }
        return categoryAxis;
    }

    public void setSecondaryDomainAxis(int n, CategoryAxis categoryAxis) {
        CategoryAxis categoryAxis2 = this.getSecondaryDomainAxis(n);
        if (categoryAxis2 != null) {
            categoryAxis2.removeChangeListener(this);
        }
        if (categoryAxis != null) {
            categoryAxis.setPlot(this);
        }
        this.secondaryDomainAxes.set(n, (Object)categoryAxis);
        if (categoryAxis != null) {
            categoryAxis.configure();
            categoryAxis.addChangeListener(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearSecondaryDomainAxes() {
        for (int i = 0; i < this.secondaryDomainAxes.size(); ++i) {
            CategoryAxis categoryAxis = (CategoryAxis)this.secondaryDomainAxes.get(i);
            if (categoryAxis == null) continue;
            categoryAxis.removeChangeListener(this);
        }
        this.secondaryDomainAxes.clear();
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void configureSecondaryDomainAxes() {
        for (int i = 0; i < this.secondaryDomainAxes.size(); ++i) {
            CategoryAxis categoryAxis = (CategoryAxis)this.secondaryDomainAxes.get(i);
            if (categoryAxis == null) continue;
            categoryAxis.configure();
        }
    }

    public AxisLocation getSecondaryDomainAxisLocation(int n) {
        Plot plot;
        AxisLocation axisLocation = null;
        if (n < this.secondaryDomainAxisLocations.size()) {
            axisLocation = (AxisLocation)this.secondaryDomainAxisLocations.get(n);
        }
        if (axisLocation == null && (plot = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            axisLocation = categoryPlot.getSecondaryDomainAxisLocation(n);
        }
        return axisLocation;
    }

    public void setSecondaryDomainAxisLocation(int n, AxisLocation axisLocation) {
        this.secondaryDomainAxisLocations.set(n, (Object)axisLocation);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public RectangleEdge getSecondaryDomainAxisEdge(int n) {
        AxisLocation axisLocation = this.getSecondaryDomainAxisLocation(n);
        RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(axisLocation, this.orientation);
        if (rectangleEdge == null) {
            rectangleEdge = RectangleEdge.opposite((RectangleEdge)this.getDomainAxisEdge());
        }
        return rectangleEdge;
    }

    public ValueAxis getRangeAxis() {
        Plot plot;
        ValueAxis valueAxis = this.rangeAxis;
        if (valueAxis == null && (plot = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            valueAxis = categoryPlot.getRangeAxis();
        }
        return valueAxis;
    }

    public void setRangeAxis(ValueAxis valueAxis) {
        if (valueAxis != null) {
            valueAxis.setPlot(this);
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.removeChangeListener(this);
        }
        this.rangeAxis = valueAxis;
        if (valueAxis != null) {
            valueAxis.configure();
            valueAxis.addChangeListener(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public AxisLocation getRangeAxisLocation() {
        return this.rangeAxisLocation;
    }

    public void setRangeAxisLocation(AxisLocation axisLocation) {
        this.setRangeAxisLocation(axisLocation, true);
    }

    public void setRangeAxisLocation(AxisLocation axisLocation, boolean bl) {
        if (axisLocation != this.rangeAxisLocation) {
            this.rangeAxisLocation = axisLocation;
            if (bl) {
                this.notifyListeners(new PlotChangeEvent(this));
            }
        }
    }

    public RectangleEdge getRangeAxisEdge() {
        return Plot.resolveRangeAxisLocation(this.rangeAxisLocation, this.orientation);
    }

    public ValueAxis getSecondaryRangeAxis(int n) {
        Plot plot;
        ValueAxis valueAxis = null;
        if (n < this.secondaryRangeAxes.size()) {
            valueAxis = (ValueAxis)this.secondaryRangeAxes.get(n);
        }
        if (valueAxis == null && (plot = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            valueAxis = categoryPlot.getSecondaryRangeAxis(n);
        }
        return valueAxis;
    }

    public void setSecondaryRangeAxis(int n, ValueAxis valueAxis) {
        ValueAxis valueAxis2 = this.getSecondaryRangeAxis(n);
        if (valueAxis2 != null) {
            valueAxis2.removeChangeListener(this);
        }
        if (valueAxis != null) {
            valueAxis.setPlot(this);
        }
        this.secondaryRangeAxes.set(n, (Object)valueAxis);
        if (valueAxis != null) {
            valueAxis.configure();
            valueAxis.addChangeListener(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearSecondaryRangeAxes() {
        for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
            ValueAxis valueAxis = (ValueAxis)this.secondaryRangeAxes.get(i);
            if (valueAxis == null) continue;
            valueAxis.removeChangeListener(this);
        }
        this.secondaryRangeAxes.clear();
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void configureSecondaryRangeAxes() {
        for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
            ValueAxis valueAxis = (ValueAxis)this.secondaryRangeAxes.get(i);
            if (valueAxis == null) continue;
            valueAxis.configure();
        }
    }

    public AxisLocation getSecondaryRangeAxisLocation(int n) {
        Plot plot;
        AxisLocation axisLocation = null;
        if (n < this.secondaryRangeAxisLocations.size()) {
            axisLocation = (AxisLocation)this.secondaryRangeAxisLocations.get(n);
        }
        if (axisLocation == null && (plot = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            axisLocation = categoryPlot.getSecondaryRangeAxisLocation(n);
        }
        return axisLocation;
    }

    public void setSecondaryRangeAxisLocation(int n, AxisLocation axisLocation) {
        this.secondaryRangeAxisLocations.set(n, (Object)axisLocation);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public RectangleEdge getSecondaryRangeAxisEdge(int n) {
        AxisLocation axisLocation = this.getSecondaryRangeAxisLocation(n);
        RectangleEdge rectangleEdge = Plot.resolveRangeAxisLocation(axisLocation, this.orientation);
        if (rectangleEdge == null) {
            rectangleEdge = RectangleEdge.opposite((RectangleEdge)this.getRangeAxisEdge());
        }
        return rectangleEdge;
    }

    public CategoryDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(CategoryDataset categoryDataset) {
        CategoryDataset categoryDataset2 = this.dataset;
        if (categoryDataset2 != null) {
            categoryDataset2.removeChangeListener(this);
        }
        this.dataset = categoryDataset;
        if (categoryDataset != null) {
            this.setDatasetGroup(categoryDataset.getGroup());
            categoryDataset.addChangeListener(this);
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, categoryDataset);
        this.datasetChanged(datasetChangeEvent);
    }

    public CategoryDataset getSecondaryDataset(int n) {
        CategoryDataset categoryDataset = null;
        if (this.secondaryDatasets.size() > n) {
            categoryDataset = (CategoryDataset)this.secondaryDatasets.get(n);
        }
        return categoryDataset;
    }

    public void setSecondaryDataset(int n, CategoryDataset categoryDataset) {
        CategoryDataset categoryDataset2 = (CategoryDataset)this.secondaryDatasets.get(n);
        if (categoryDataset2 != null) {
            categoryDataset2.removeChangeListener(this);
        }
        this.secondaryDatasets.set(n, (Object)categoryDataset);
        categoryDataset.addChangeListener(this);
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, categoryDataset);
        this.datasetChanged(datasetChangeEvent);
    }

    public void mapSecondaryDatasetToDomainAxis(int n, Integer n2) {
        this.secondaryDatasetDomainAxisMap.set(n, (Object)n2);
        this.datasetChanged(new DatasetChangeEvent(this, this.dataset));
    }

    public void mapSecondaryDatasetToRangeAxis(int n, Integer n2) {
        this.secondaryDatasetRangeAxisMap.set(n, (Object)n2);
        this.datasetChanged(new DatasetChangeEvent(this, this.dataset));
    }

    public ValueAxis getRangeAxisForSecondaryDataset(int n) {
        ValueAxis valueAxis = this.getRangeAxis();
        Integer n2 = (Integer)this.secondaryDatasetRangeAxisMap.get(n);
        if (n2 != null) {
            valueAxis = this.getSecondaryRangeAxis(n2);
        }
        return valueAxis;
    }

    public CategoryItemRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(CategoryItemRenderer categoryItemRenderer) {
        this.setRenderer(categoryItemRenderer, true);
    }

    public void setRenderer(CategoryItemRenderer categoryItemRenderer, boolean bl) {
        if (this.renderer != null) {
            this.renderer.removeChangeListener(this);
        }
        this.renderer = categoryItemRenderer;
        if (categoryItemRenderer != null) {
            categoryItemRenderer.setPlot(this);
            categoryItemRenderer.addChangeListener(this);
        }
        if (bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public CategoryItemRenderer getSecondaryRenderer(int n) {
        CategoryItemRenderer categoryItemRenderer = null;
        if (this.secondaryRenderers.size() > n) {
            categoryItemRenderer = (CategoryItemRenderer)this.secondaryRenderers.get(n);
        }
        return categoryItemRenderer;
    }

    public void setSecondaryRenderer(int n, CategoryItemRenderer categoryItemRenderer) {
        CategoryItemRenderer categoryItemRenderer2 = this.getSecondaryRenderer(n);
        if (categoryItemRenderer2 != null) {
            categoryItemRenderer2.removeChangeListener(this);
        }
        this.secondaryRenderers.set(n, (Object)categoryItemRenderer);
        if (categoryItemRenderer != null) {
            categoryItemRenderer.setPlot(this);
            categoryItemRenderer.addChangeListener(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public DatasetRenderingOrder getDatasetRenderingOrder() {
        return this.renderingOrder;
    }

    public void setDatasetRenderingOrder(DatasetRenderingOrder datasetRenderingOrder) {
        this.renderingOrder = datasetRenderingOrder;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public SortOrder getColumnRenderingOrder() {
        return this.columnRenderingOrder;
    }

    public void setColumnRenderingOrder(SortOrder sortOrder) {
        this.columnRenderingOrder = sortOrder;
    }

    public SortOrder getRowRenderingOrder() {
        return this.rowRenderingOrder;
    }

    public void setRowRenderingOrder(SortOrder sortOrder) {
        this.rowRenderingOrder = sortOrder;
    }

    public boolean isDomainGridlinesVisible() {
        return this.domainGridlinesVisible;
    }

    public void setDomainGridlinesVisible(boolean bl) {
        if (this.domainGridlinesVisible != bl) {
            this.domainGridlinesVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public CategoryAnchor getDomainGridlinePosition() {
        return this.domainGridlinePosition;
    }

    public void setDomainGridlinePosition(CategoryAnchor categoryAnchor) {
        this.domainGridlinePosition = categoryAnchor;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getDomainGridlineStroke() {
        return this.domainGridlineStroke;
    }

    public void setDomainGridlineStroke(Stroke stroke) {
        this.domainGridlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getDomainGridlinePaint() {
        return this.domainGridlinePaint;
    }

    public void setDomainGridlinePaint(Paint paint) {
        this.domainGridlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isRangeGridlinesVisible() {
        return this.rangeGridlinesVisible;
    }

    public void setRangeGridlinesVisible(boolean bl) {
        if (this.rangeGridlinesVisible != bl) {
            this.rangeGridlinesVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getRangeGridlineStroke() {
        return this.rangeGridlineStroke;
    }

    public void setRangeGridlineStroke(Stroke stroke) {
        this.rangeGridlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRangeGridlinePaint() {
        return this.rangeGridlinePaint;
    }

    public void setRangeGridlinePaint(Paint paint) {
        this.rangeGridlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public LegendItemCollection getLegendItems() {
        Object object;
        Object object2;
        int n;
        int n2;
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        CategoryDataset categoryDataset = this.getDataset();
        if (categoryDataset != null) {
            n2 = categoryDataset.getRowCount();
            for (n = 0; n < n2; ++n) {
                object2 = this.getRenderer();
                if (object2 == null) continue;
                object = object2.getLegendItem(0, n);
                legendItemCollection.add((LegendItem)object);
            }
        }
        n2 = this.secondaryDatasets.size();
        for (n = 0; n < n2; ++n) {
            object2 = this.getSecondaryDataset(n);
            if (object2 == null || (object = this.getSecondaryRenderer(n)) == null) continue;
            int n3 = object2.getRowCount();
            for (int i = 0; i < n3; ++i) {
                LegendItem legendItem = object.getLegendItem(n + 1, i);
                legendItemCollection.add(legendItem);
            }
        }
        return legendItemCollection;
    }

    public void handleClick(int n, int n2, PlotRenderingInfo plotRenderingInfo) {
        Rectangle2D rectangle2D = plotRenderingInfo.getDataArea();
        if (rectangle2D.contains(n, n2)) {
            double d = 0.0;
            if (this.orientation == PlotOrientation.HORIZONTAL) {
                d = n;
            } else if (this.orientation == PlotOrientation.VERTICAL) {
                d = n2;
            }
            RectangleEdge rectangleEdge = Plot.resolveRangeAxisLocation(this.getRangeAxisLocation(), this.orientation);
            double d2 = this.rangeAxis.translateJava2DToValue(d, plotRenderingInfo.getDataArea(), rectangleEdge);
            this.setAnchorValue(d2);
            this.setRangeCrosshairValue(d2);
        }
    }

    public void zoom(double d) {
        if (d > 0.0) {
            double d2 = this.rangeAxis.getRange().getLength();
            double d3 = d2 * d;
            this.rangeAxis.setRange(this.anchorValue - d3 / 2.0, this.anchorValue + d3 / 2.0);
        } else {
            this.rangeAxis.setAutoRange(true);
        }
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        if (this.rangeAxis != null) {
            this.rangeAxis.configure();
        }
        int n = this.secondaryRangeAxes.size();
        for (int i = 0; i < n; ++i) {
            ValueAxis valueAxis = this.getSecondaryRangeAxis(i);
            if (valueAxis == null) continue;
            valueAxis.configure();
        }
        if (this.getParent() != null) {
            this.getParent().datasetChanged(datasetChangeEvent);
        } else {
            PlotChangeEvent plotChangeEvent = new PlotChangeEvent(this);
            this.notifyListeners(plotChangeEvent);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rendererChanged(RendererChangeEvent rendererChangeEvent) {
        Plot plot = this.getParent();
        if (plot != null) {
            if (!(plot instanceof RendererChangeListener)) throw new RuntimeException("The renderer has changed and I don't know what to do!");
            RendererChangeListener rendererChangeListener = (RendererChangeListener)((Object)plot);
            rendererChangeListener.rendererChanged(rendererChangeEvent);
            return;
        } else {
            PlotChangeEvent plotChangeEvent = new PlotChangeEvent(this);
            this.notifyListeners(plotChangeEvent);
        }
    }

    public void addRangeMarker(Marker marker) {
        this.addRangeMarker(marker, Layer.FOREGROUND);
    }

    public void addRangeMarker(Marker marker, Layer layer) {
        if (layer == Layer.FOREGROUND) {
            if (this.foregroundRangeMarkers == null) {
                this.foregroundRangeMarkers = new ArrayList();
            }
            this.foregroundRangeMarkers.add(marker);
            this.notifyListeners(new PlotChangeEvent(this));
        } else if (layer == Layer.BACKGROUND) {
            if (this.backgroundRangeMarkers == null) {
                this.backgroundRangeMarkers = new ArrayList();
            }
            this.backgroundRangeMarkers.add(marker);
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void clearRangeMarkers() {
        if (this.foregroundRangeMarkers != null) {
            this.backgroundRangeMarkers.clear();
        }
        if (this.foregroundRangeMarkers != null) {
            this.backgroundRangeMarkers.clear();
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public List getRangeMarkers() {
        return this.getRangeMarkers(Layer.FOREGROUND);
    }

    public List getRangeMarkers(Layer layer) {
        if (layer == Layer.FOREGROUND) {
            return Collections.unmodifiableList(this.foregroundRangeMarkers);
        }
        if (layer == Layer.BACKGROUND) {
            return Collections.unmodifiableList(this.backgroundRangeMarkers);
        }
        throw new IllegalStateException("CategoryPlot.getRangeMarkers(..): layer?");
    }

    public void addSecondaryRangeMarker(Marker marker) {
        this.addSecondaryRangeMarker(0, marker, Layer.FOREGROUND);
    }

    public void addSecondaryRangeMarker(int n, Marker marker, Layer layer) {
        if (layer == Layer.FOREGROUND) {
            ArrayList<Marker> arrayList = (ArrayList<Marker>)this.secondaryForegroundRangeMarkers.get(new Integer(n));
            if (arrayList == null) {
                arrayList = new ArrayList<Marker>();
                this.secondaryForegroundRangeMarkers.put(new Integer(n), arrayList);
            }
            arrayList.add(marker);
        } else if (layer == Layer.BACKGROUND) {
            ArrayList<Marker> arrayList = (ArrayList<Marker>)this.secondaryForegroundRangeMarkers.get(new Integer(n));
            if (arrayList == null) {
                arrayList = new ArrayList<Marker>();
                this.secondaryBackgroundRangeMarkers.put(new Integer(n), arrayList);
            }
            arrayList.add(marker);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearSecondaryRangeMarkers() {
        this.clearSecondaryRangeMarkers(0);
    }

    public void clearSecondaryRangeMarkers(int n) {
        Integer n2 = new Integer(n);
        Collection collection = (Collection)this.secondaryBackgroundRangeMarkers.get(n2);
        if (collection != null) {
            collection.clear();
        }
        if ((collection = (Collection)this.secondaryForegroundRangeMarkers.get(n2)) != null) {
            collection.clear();
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public List getSecondaryRangeMarkers() {
        ArrayList arrayList = null;
        Collection collection = this.getSecondaryRangeMarkers(0, Layer.FOREGROUND);
        if (collection != null) {
            arrayList = new ArrayList(arrayList);
        }
        return arrayList;
    }

    public Collection getSecondaryRangeMarkers(int n, Layer layer) {
        Collection collection = null;
        Integer n2 = new Integer(n);
        if (layer == Layer.FOREGROUND) {
            collection = (Collection)this.secondaryForegroundRangeMarkers.get(n2);
        } else if (layer == Layer.BACKGROUND) {
            collection = (Collection)this.secondaryBackgroundRangeMarkers.get(n2);
        }
        if (collection != null) {
            collection = Collections.unmodifiableCollection(collection);
        }
        return collection;
    }

    public boolean isRangeCrosshairVisible() {
        return this.rangeCrosshairVisible;
    }

    public void setRangeCrosshairVisible(boolean bl) {
        if (this.rangeCrosshairVisible != bl) {
            this.rangeCrosshairVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean isRangeCrosshairLockedOnData() {
        return this.rangeCrosshairLockedOnData;
    }

    public void setRangeCrosshairLockedOnData(boolean bl) {
        if (this.rangeCrosshairLockedOnData != bl) {
            this.rangeCrosshairLockedOnData = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getRangeCrosshairValue() {
        return this.rangeCrosshairValue;
    }

    public void setRangeCrosshairValue(double d) {
        this.setRangeCrosshairValue(d, true);
    }

    public void setRangeCrosshairValue(double d, boolean bl) {
        this.rangeCrosshairValue = d;
        if (this.isRangeCrosshairVisible() && bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getRangeCrosshairStroke() {
        return this.rangeCrosshairStroke;
    }

    public void setRangeCrosshairStroke(Stroke stroke) {
        this.rangeCrosshairStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRangeCrosshairPaint() {
        return this.rangeCrosshairPaint;
    }

    public void setRangeCrosshairPaint(Paint paint) {
        this.rangeCrosshairPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public List getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(CategoryAnnotation categoryAnnotation) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        this.annotations.add(categoryAnnotation);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    protected AxisSpace calculateDomainAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D, AxisSpace axisSpace) {
        block7: {
            block5: {
                block6: {
                    if (axisSpace == null) {
                        axisSpace = new AxisSpace();
                    }
                    if (this.fixedDomainAxisSpace == null) break block5;
                    if (this.orientation != PlotOrientation.HORIZONTAL) break block6;
                    axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getLeft(), RectangleEdge.LEFT);
                    axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getRight(), RectangleEdge.RIGHT);
                    break block7;
                }
                if (this.orientation != PlotOrientation.VERTICAL) break block7;
                axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getTop(), RectangleEdge.TOP);
                axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getBottom(), RectangleEdge.BOTTOM);
                break block7;
            }
            RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(this.getDomainAxisLocation(), this.orientation);
            if (this.domainAxis != null) {
                axisSpace = this.domainAxis.reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            } else if (this.drawSharedDomainAxis) {
                axisSpace = this.getDomainAxis().reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            }
            for (int i = 0; i < this.secondaryDomainAxes.size(); ++i) {
                CategoryAxis categoryAxis = this.getSecondaryDomainAxis(i);
                if (categoryAxis == null) continue;
                RectangleEdge rectangleEdge2 = this.getSecondaryDomainAxisEdge(i);
                axisSpace = ((Axis)categoryAxis).reserveSpace(graphics2D, this, rectangle2D, rectangleEdge2, axisSpace);
            }
        }
        return axisSpace;
    }

    protected AxisSpace calculateRangeAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D, AxisSpace axisSpace) {
        block5: {
            block3: {
                block4: {
                    if (axisSpace == null) {
                        axisSpace = new AxisSpace();
                    }
                    if (this.fixedRangeAxisSpace == null) break block3;
                    if (this.orientation != PlotOrientation.HORIZONTAL) break block4;
                    axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getTop(), RectangleEdge.TOP);
                    axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getBottom(), RectangleEdge.BOTTOM);
                    break block5;
                }
                if (this.orientation != PlotOrientation.VERTICAL) break block5;
                axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getLeft(), RectangleEdge.LEFT);
                axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getRight(), RectangleEdge.RIGHT);
                break block5;
            }
            ValueAxis valueAxis = this.rangeAxis;
            if (valueAxis != null) {
                axisSpace = ((Axis)valueAxis).reserveSpace(graphics2D, this, rectangle2D, this.getRangeAxisEdge(), axisSpace);
            }
            for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
                ValueAxis valueAxis2 = this.getSecondaryRangeAxis(i);
                if (valueAxis2 == null) continue;
                RectangleEdge rectangleEdge = this.getSecondaryRangeAxisEdge(i);
                axisSpace = ((Axis)valueAxis2).reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            }
        }
        return axisSpace;
    }

    protected AxisSpace calculateAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        AxisSpace axisSpace = new AxisSpace();
        axisSpace = this.calculateRangeAxisSpace(graphics2D, rectangle2D, axisSpace);
        axisSpace = this.calculateDomainAxisSpace(graphics2D, rectangle2D, axisSpace);
        return axisSpace;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        Insets insets;
        boolean bl;
        boolean bl2 = rectangle2D.getWidth() <= 10.0;
        boolean bl3 = bl = rectangle2D.getHeight() <= 10.0;
        if (bl2 || bl) {
            return;
        }
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
        }
        if ((insets = this.getInsets()) != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)insets.left, rectangle2D.getY() + (double)insets.top, rectangle2D.getWidth() - (double)insets.left - (double)insets.right, rectangle2D.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        AxisSpace axisSpace = this.calculateAxisSpace(graphics2D, rectangle2D);
        Rectangle2D rectangle2D2 = axisSpace.shrink(rectangle2D, null);
        this.axisOffset.trim(rectangle2D2);
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setDataArea(rectangle2D2);
        }
        if (this.renderer != null) {
            this.renderer.drawBackground(graphics2D, this, rectangle2D2);
        } else {
            this.drawBackground(graphics2D, rectangle2D2);
        }
        Map map = this.drawAxes(graphics2D, rectangle2D, rectangle2D2);
        this.drawDomainGridlines(graphics2D, rectangle2D2);
        AxisState axisState = (AxisState)map.get(this.getRangeAxis());
        if (axisState == null && plotState != null) {
            axisState = (AxisState)plotState.getSharedAxisStates().get(this.getRangeAxis());
        }
        if (axisState != null) {
            this.drawRangeGridlines(graphics2D, rectangle2D2, axisState.getTicks());
        }
        for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
            this.drawSecondaryRangeMarkers(graphics2D, rectangle2D2, i, Layer.BACKGROUND);
        }
        this.drawRangeMarkers(graphics2D, rectangle2D2, Layer.BACKGROUND);
        DatasetRenderingOrder datasetRenderingOrder = this.getDatasetRenderingOrder();
        if (datasetRenderingOrder == DatasetRenderingOrder.STANDARD) {
            this.render2(graphics2D, rectangle2D2, plotRenderingInfo);
            this.render(graphics2D, rectangle2D2, plotRenderingInfo);
        } else if (datasetRenderingOrder == DatasetRenderingOrder.REVERSE) {
            this.render(graphics2D, rectangle2D2, plotRenderingInfo);
            this.render2(graphics2D, rectangle2D2, plotRenderingInfo);
        }
        if (this.isRangeCrosshairVisible()) {
            this.drawRangeLine(graphics2D, rectangle2D2, this.getRangeCrosshairValue(), this.getRangeCrosshairStroke(), this.getRangeCrosshairPaint());
        }
        for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
            this.drawSecondaryRangeMarkers(graphics2D, rectangle2D2, i, Layer.FOREGROUND);
        }
        this.drawRangeMarkers(graphics2D, rectangle2D2, Layer.FOREGROUND);
        this.drawAnnotations(graphics2D, rectangle2D2);
        if (this.renderer != null) {
            this.renderer.drawOutline(graphics2D, this, rectangle2D2);
        } else {
            this.drawOutline(graphics2D, rectangle2D2);
        }
    }

    protected Map drawAxes(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        AxisState axisState;
        Axis axis;
        Axis axis2;
        int n;
        AxisCollection axisCollection = new AxisCollection();
        if (this.domainAxis != null) {
            axisCollection.add(this.domainAxis, this.getDomainAxisEdge());
        }
        if (this.rangeAxis != null) {
            axisCollection.add(this.rangeAxis, this.getRangeAxisEdge());
        }
        for (n = 0; n < this.secondaryDomainAxes.size(); ++n) {
            axis2 = (CategoryAxis)this.secondaryDomainAxes.get(n);
            if (axis2 == null) continue;
            axisCollection.add(axis2, this.getSecondaryDomainAxisEdge(n));
        }
        for (n = 0; n < this.secondaryRangeAxes.size(); ++n) {
            axis2 = (ValueAxis)this.secondaryRangeAxes.get(n);
            if (axis2 == null) continue;
            axisCollection.add(axis2, this.getSecondaryRangeAxisEdge(n));
        }
        HashMap<Axis, AxisState> hashMap = new HashMap<Axis, AxisState>();
        double d = rectangle2D2.getMinY() - this.axisOffset.getTopSpace(rectangle2D2.getHeight());
        Iterator iterator = axisCollection.getAxesAtTop().iterator();
        while (iterator.hasNext()) {
            axis = (Axis)iterator.next();
            if (axis == null) continue;
            axisState = axis.draw(graphics2D, d, rectangle2D, rectangle2D2, RectangleEdge.TOP);
            d = axisState.getCursor();
            hashMap.put(axis, axisState);
        }
        d = rectangle2D2.getMaxY() + this.axisOffset.getBottomSpace(rectangle2D2.getHeight());
        iterator = axisCollection.getAxesAtBottom().iterator();
        while (iterator.hasNext()) {
            axis = (Axis)iterator.next();
            if (axis == null) continue;
            axisState = axis.draw(graphics2D, d, rectangle2D, rectangle2D2, RectangleEdge.BOTTOM);
            d = axisState.getCursor();
            hashMap.put(axis, axisState);
        }
        d = rectangle2D2.getMinX() - this.axisOffset.getLeftSpace(rectangle2D2.getWidth());
        iterator = axisCollection.getAxesAtLeft().iterator();
        while (iterator.hasNext()) {
            axis = (Axis)iterator.next();
            if (axis == null) continue;
            axisState = axis.draw(graphics2D, d, rectangle2D, rectangle2D2, RectangleEdge.LEFT);
            d = axisState.getCursor();
            hashMap.put(axis, axisState);
        }
        d = rectangle2D2.getMaxX() + this.axisOffset.getRightSpace(rectangle2D2.getWidth());
        iterator = axisCollection.getAxesAtRight().iterator();
        while (iterator.hasNext()) {
            axis = (Axis)iterator.next();
            if (axis == null) continue;
            axisState = axis.draw(graphics2D, d, rectangle2D, rectangle2D2, RectangleEdge.RIGHT);
            d = axisState.getCursor();
            hashMap.put(axis, axisState);
        }
        return hashMap;
    }

    public void render(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo) {
        if (this.renderer == null) {
            return;
        }
        CategoryDataset categoryDataset = this.getDataset();
        if (!DatasetUtilities.isEmptyOrNull(categoryDataset)) {
            Shape shape = graphics2D.getClip();
            graphics2D.clip(rectangle2D);
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
            CategoryItemRendererState categoryItemRendererState = this.renderer.initialise(graphics2D, rectangle2D, this, null, plotRenderingInfo);
            int n = categoryDataset.getColumnCount();
            int n2 = categoryDataset.getRowCount();
            if (this.columnRenderingOrder == SortOrder.ASCENDING) {
                for (int i = 0; i < n; ++i) {
                    int n3;
                    if (this.rowRenderingOrder == SortOrder.ASCENDING) {
                        for (n3 = 0; n3 < n2; ++n3) {
                            this.renderer.drawItem(graphics2D, categoryItemRendererState, rectangle2D, this, this.getDomainAxis(), this.getRangeAxis(), categoryDataset, n3, i);
                        }
                        continue;
                    }
                    for (n3 = n2 - 1; n3 >= 0; --n3) {
                        this.renderer.drawItem(graphics2D, categoryItemRendererState, rectangle2D, this, this.getDomainAxis(), this.getRangeAxis(), categoryDataset, n3, i);
                    }
                }
            } else {
                for (int i = n - 1; i >= 0; --i) {
                    int n4;
                    if (this.rowRenderingOrder == SortOrder.ASCENDING) {
                        for (n4 = 0; n4 < n2; ++n4) {
                            this.renderer.drawItem(graphics2D, categoryItemRendererState, rectangle2D, this, this.getDomainAxis(), this.getRangeAxis(), categoryDataset, n4, i);
                        }
                        continue;
                    }
                    for (n4 = n2 - 1; n4 >= 0; --n4) {
                        this.renderer.drawItem(graphics2D, categoryItemRendererState, rectangle2D, this, this.getDomainAxis(), this.getRangeAxis(), categoryDataset, n4, i);
                    }
                }
            }
            graphics2D.setClip(shape);
            graphics2D.setComposite(composite);
        } else {
            this.drawNoDataMessage(graphics2D, rectangle2D);
        }
    }

    public void render2(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo) {
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D);
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        for (int i = 0; i < this.secondaryDatasets.size(); ++i) {
            CategoryItemRenderer categoryItemRenderer;
            CategoryDataset categoryDataset = this.getSecondaryDataset(i);
            if (DatasetUtilities.isEmptyOrNull(categoryDataset)) continue;
            ValueAxis valueAxis = this.getRangeAxisForSecondaryDataset(i);
            if (valueAxis == null) {
                valueAxis = this.getRangeAxis();
            }
            if ((categoryItemRenderer = this.getSecondaryRenderer(i)) == null) continue;
            CategoryItemRendererState categoryItemRendererState = categoryItemRenderer.initialise(graphics2D, rectangle2D, this, new Integer(i), plotRenderingInfo);
            int n = categoryDataset.getColumnCount();
            int n2 = categoryDataset.getRowCount();
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n2; ++k) {
                    categoryItemRenderer.drawItem(graphics2D, categoryItemRendererState, rectangle2D, this, this.getDomainAxis(), valueAxis, categoryDataset, k, j);
                }
            }
        }
        graphics2D.setClip(shape);
        graphics2D.setComposite(composite);
    }

    protected void drawDomainGridlines(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.isDomainGridlinesVisible()) {
            CategoryAxis categoryAxis;
            CategoryDataset categoryDataset;
            CategoryAnchor categoryAnchor = this.getDomainGridlinePosition();
            RectangleEdge rectangleEdge = this.getDomainAxisEdge();
            Stroke stroke = this.getDomainGridlineStroke();
            Paint paint = this.getDomainGridlinePaint();
            if (stroke != null && paint != null && (categoryDataset = this.getDataset()) != null && (categoryAxis = this.getDomainAxis()) != null) {
                int n = categoryDataset.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    double d = categoryAxis.getCategoryJava2DCoordinate(categoryAnchor, i, n, rectangle2D, rectangleEdge);
                    CategoryItemRenderer categoryItemRenderer = this.getRenderer();
                    if (categoryItemRenderer == null) continue;
                    categoryItemRenderer.drawDomainGridline(graphics2D, this, rectangle2D, d);
                }
            }
        }
    }

    protected void drawRangeGridlines(Graphics2D graphics2D, Rectangle2D rectangle2D, List list) {
        if (this.isRangeGridlinesVisible()) {
            ValueAxis valueAxis;
            Stroke stroke = this.getRangeGridlineStroke();
            Paint paint = this.getRangeGridlinePaint();
            if (stroke != null && paint != null && (valueAxis = this.getRangeAxis()) != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ValueTick valueTick = (ValueTick)iterator.next();
                    CategoryItemRenderer categoryItemRenderer = this.getRenderer();
                    if (categoryItemRenderer == null) continue;
                    categoryItemRenderer.drawRangeGridline(graphics2D, this, this.getRangeAxis(), rectangle2D, valueTick.getValue());
                }
            }
        }
    }

    protected void drawAnnotations(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.getAnnotations() != null) {
            Iterator iterator = this.getAnnotations().iterator();
            while (iterator.hasNext()) {
                CategoryAnnotation categoryAnnotation = (CategoryAnnotation)iterator.next();
                categoryAnnotation.draw(graphics2D, this, rectangle2D, this.getDomainAxis(), this.getRangeAxis());
            }
        }
    }

    protected void drawRangeMarkers(Graphics2D graphics2D, Rectangle2D rectangle2D, Layer layer) {
        CategoryItemRenderer categoryItemRenderer = this.getRenderer();
        List list = this.getRangeMarkers(layer);
        if (list != null && categoryItemRenderer != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Marker marker = (Marker)iterator.next();
                categoryItemRenderer.drawRangeMarker(graphics2D, this, this.getRangeAxis(), marker, rectangle2D);
            }
        }
    }

    protected void drawSecondaryRangeMarkers(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        CategoryItemRenderer categoryItemRenderer = this.getSecondaryRenderer(0);
        if (categoryItemRenderer == null) {
            return;
        }
        if (this.getSecondaryRangeMarkers() != null) {
            Iterator iterator = this.getSecondaryRangeMarkers().iterator();
            while (iterator.hasNext()) {
                Marker marker = (Marker)iterator.next();
                this.renderer.drawRangeMarker(graphics2D, this, this.getSecondaryRangeAxis(0), marker, rectangle2D);
            }
        }
    }

    protected void drawSecondaryRangeMarkers(Graphics2D graphics2D, Rectangle2D rectangle2D, int n, Layer layer) {
        CategoryItemRenderer categoryItemRenderer = this.getSecondaryRenderer(n);
        if (categoryItemRenderer == null) {
            return;
        }
        Collection collection = this.getSecondaryRangeMarkers(n, layer);
        ValueAxis valueAxis = this.getSecondaryRangeAxis(n);
        if (collection != null && valueAxis != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Marker marker = (Marker)iterator.next();
                this.renderer.drawRangeMarker(graphics2D, this, valueAxis, marker, rectangle2D);
            }
        }
    }

    protected void drawRangeLine(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, Stroke stroke, Paint paint) {
        double d2 = this.getRangeAxis().translateValueToJava2D(d, rectangle2D, this.getRangeAxisEdge());
        Line2D.Double double_ = null;
        if (this.orientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        } else if (this.orientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        }
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
    }

    public Range getDataRange(ValueAxis valueAxis) {
        Range range = null;
        ArrayList<CategoryDataset> arrayList = new ArrayList<CategoryDataset>();
        if (valueAxis == this.getRangeAxis()) {
            arrayList.add(this.dataset);
            arrayList.addAll(this.getSecondaryDatasetsMappedToRangeAxis(null));
        } else {
            int n = this.secondaryRangeAxes.indexOf((Object)valueAxis);
            if (n >= 0) {
                arrayList.addAll(this.getSecondaryDatasetsMappedToRangeAxis(new Integer(n)));
            }
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            CategoryDataset categoryDataset = (CategoryDataset)iterator.next();
            RangeType rangeType = RangeType.STANDARD;
            if (this.renderer != null) {
                rangeType = this.renderer.getRangeType();
            }
            if (rangeType == RangeType.STACKED) {
                range = Range.combine(range, DatasetUtilities.getStackedRangeExtent(categoryDataset));
                continue;
            }
            if (rangeType == RangeType.SERIES_CUMULATIVE) {
                range = Range.combine(range, DatasetUtilities.getCumulativeRangeExtent(categoryDataset));
                continue;
            }
            range = Range.combine(range, DatasetUtilities.getRangeExtent(categoryDataset));
        }
        return range;
    }

    private List getSecondaryDatasetsMappedToRangeAxis(Integer n) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.secondaryDatasetRangeAxisMap.size(); ++i) {
            Integer n2 = (Integer)this.secondaryDatasetRangeAxisMap.get(i);
            if (n2 == null) {
                if (n != null) continue;
                arrayList.add(this.secondaryDatasets.get(i));
                continue;
            }
            if (!n2.equals(n)) continue;
            arrayList.add(this.secondaryDatasets.get(i));
        }
        return arrayList;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int n) {
        this.weight = n;
    }

    public AxisSpace getFixedDomainAxisSpace() {
        return this.fixedDomainAxisSpace;
    }

    public void setFixedDomainAxisSpace(AxisSpace axisSpace) {
        this.fixedDomainAxisSpace = axisSpace;
    }

    public AxisSpace getFixedRangeAxisSpace() {
        return this.fixedRangeAxisSpace;
    }

    public void setFixedRangeAxisSpace(AxisSpace axisSpace) {
        this.fixedRangeAxisSpace = axisSpace;
    }

    public List getCategories() {
        List list = null;
        if (this.dataset != null) {
            list = Collections.unmodifiableList(this.dataset.getColumnKeys());
        }
        return list;
    }

    public boolean getDrawSharedDomainAxis() {
        return this.drawSharedDomainAxis;
    }

    public void zoomHorizontalAxes(double d) {
        if (this.orientation == PlotOrientation.HORIZONTAL) {
            if (this.rangeAxis != null) {
                this.rangeAxis.resizeRange(d);
            }
            for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
                ValueAxis valueAxis = (ValueAxis)this.secondaryRangeAxes.get(i);
                if (valueAxis == null) continue;
                valueAxis.resizeRange(d);
            }
        }
    }

    public void zoomHorizontalAxes(double d, double d2) {
        if (this.orientation == PlotOrientation.HORIZONTAL) {
            if (this.rangeAxis != null) {
                this.rangeAxis.zoomRange(d, d2);
            }
            for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
                ValueAxis valueAxis = (ValueAxis)this.secondaryRangeAxes.get(i);
                if (valueAxis == null) continue;
                valueAxis.zoomRange(d, d2);
            }
        }
    }

    public void zoomVerticalAxes(double d) {
        if (this.orientation == PlotOrientation.VERTICAL) {
            if (this.rangeAxis != null) {
                this.rangeAxis.resizeRange(d);
            }
            for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
                ValueAxis valueAxis = (ValueAxis)this.secondaryRangeAxes.get(i);
                if (valueAxis == null) continue;
                valueAxis.resizeRange(d);
            }
        }
    }

    public void zoomVerticalAxes(double d, double d2) {
        if (this.orientation == PlotOrientation.VERTICAL) {
            if (this.rangeAxis != null) {
                this.rangeAxis.zoomRange(d, d2);
            }
            for (int i = 0; i < this.secondaryRangeAxes.size(); ++i) {
                ValueAxis valueAxis = (ValueAxis)this.secondaryRangeAxes.get(i);
                if (valueAxis == null) continue;
                valueAxis.zoomRange(d, d2);
            }
        }
    }

    public double getAnchorValue() {
        return this.anchorValue;
    }

    public void setAnchorValue(double d) {
        this.setAnchorValue(d, true);
    }

    public void setAnchorValue(double d, boolean bl) {
        this.anchorValue = d;
        if (bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (super.equals(object) && object instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)object;
            boolean bl = this.orientation == categoryPlot.orientation;
            boolean bl2 = ObjectUtils.equal((Object)this.axisOffset, (Object)categoryPlot.axisOffset);
            boolean bl3 = ObjectUtils.equal((Object)this.domainAxis, (Object)categoryPlot.domainAxis);
            boolean bl4 = this.domainAxisLocation == categoryPlot.domainAxisLocation;
            boolean bl5 = this.secondaryDomainAxes.equals((Object)categoryPlot.secondaryDomainAxes);
            boolean bl6 = this.secondaryDomainAxisLocations.equals((Object)categoryPlot.secondaryDomainAxisLocations);
            boolean bl7 = ObjectUtils.equal((Object)this.rangeAxis, (Object)categoryPlot.rangeAxis);
            boolean bl8 = this.rangeAxisLocation == categoryPlot.rangeAxisLocation;
            boolean bl9 = this.secondaryRangeAxes.equals((Object)categoryPlot.secondaryRangeAxes);
            boolean bl10 = this.secondaryRangeAxisLocations.equals((Object)categoryPlot.secondaryRangeAxisLocations);
            boolean bl11 = ObjectUtils.equal((Object)this.secondaryDatasetDomainAxisMap, (Object)categoryPlot.secondaryDatasetDomainAxisMap);
            boolean bl12 = ObjectUtils.equal((Object)this.secondaryDatasetRangeAxisMap, (Object)categoryPlot.secondaryDatasetRangeAxisMap);
            boolean bl13 = ObjectUtils.equal((Object)this.renderer, (Object)categoryPlot.renderer);
            boolean bl14 = ObjectUtils.equal((Object)this.secondaryRenderers, (Object)categoryPlot.secondaryRenderers);
            boolean bl15 = this.renderingOrder == categoryPlot.renderingOrder;
            boolean bl16 = this.domainGridlinesVisible == categoryPlot.domainGridlinesVisible;
            boolean bl17 = this.domainGridlinePosition == categoryPlot.domainGridlinePosition;
            boolean bl18 = ObjectUtils.equal((Object)this.domainGridlineStroke, (Object)categoryPlot.domainGridlineStroke);
            boolean bl19 = ObjectUtils.equal((Object)this.domainGridlinePaint, (Object)categoryPlot.domainGridlinePaint);
            boolean bl20 = this.anchorValue == categoryPlot.anchorValue;
            boolean bl21 = this.rangeGridlinesVisible == categoryPlot.rangeGridlinesVisible;
            boolean bl22 = ObjectUtils.equal((Object)this.rangeGridlineStroke, (Object)categoryPlot.rangeGridlineStroke);
            boolean bl23 = ObjectUtils.equal((Object)this.rangeGridlinePaint, (Object)categoryPlot.rangeGridlinePaint);
            boolean bl24 = this.rangeCrosshairVisible == categoryPlot.rangeCrosshairVisible;
            boolean bl25 = this.rangeCrosshairValue == categoryPlot.rangeCrosshairValue;
            boolean bl26 = ObjectUtils.equal((Object)this.rangeCrosshairStroke, (Object)categoryPlot.rangeCrosshairStroke);
            boolean bl27 = ObjectUtils.equal((Object)this.rangeCrosshairPaint, (Object)categoryPlot.rangeCrosshairPaint);
            boolean bl28 = this.rangeCrosshairLockedOnData == categoryPlot.rangeCrosshairLockedOnData;
            boolean bl29 = ObjectUtils.equal((Object)this.foregroundRangeMarkers, (Object)categoryPlot.foregroundRangeMarkers);
            boolean bl30 = ObjectUtils.equal((Object)this.backgroundRangeMarkers, (Object)categoryPlot.backgroundRangeMarkers);
            boolean bl31 = ObjectUtils.equal((Object)this.secondaryForegroundRangeMarkers, (Object)categoryPlot.secondaryForegroundRangeMarkers);
            boolean bl32 = ObjectUtils.equal((Object)this.secondaryBackgroundRangeMarkers, (Object)categoryPlot.secondaryBackgroundRangeMarkers);
            boolean bl33 = ObjectUtils.equal((Object)this.annotations, (Object)categoryPlot.annotations);
            boolean bl34 = this.weight == categoryPlot.weight;
            return bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl7 && bl8 && bl9 && bl10 && bl11 && bl12 && bl13 && bl14 && bl15 && bl16 && bl17 && bl18 && bl19 && bl20 && bl21 && bl22 && bl23 && bl24 && bl25 && bl26 && bl27 && bl28 && bl29 && bl30 && bl31 && bl32 && bl33 && bl34;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        int n;
        CategoryPlot categoryPlot = (CategoryPlot)super.clone();
        if (this.domainAxis != null) {
            categoryPlot.domainAxis = (CategoryAxis)this.domainAxis.clone();
            categoryPlot.domainAxis.setPlot(categoryPlot);
            categoryPlot.domainAxis.addChangeListener(categoryPlot);
        }
        categoryPlot.secondaryDomainAxes = (ObjectList)this.secondaryDomainAxes.clone();
        for (n = 0; n < categoryPlot.secondaryDomainAxes.size(); ++n) {
            ((CategoryAxis)categoryPlot.secondaryDomainAxes.get(n)).setPlot(categoryPlot);
            ((CategoryAxis)categoryPlot.secondaryDomainAxes.get(n)).addChangeListener(categoryPlot);
        }
        categoryPlot.secondaryDomainAxisLocations = (ObjectList)this.secondaryDomainAxisLocations.clone();
        if (this.rangeAxis != null) {
            categoryPlot.rangeAxis = (ValueAxis)this.rangeAxis.clone();
            categoryPlot.rangeAxis.setPlot(categoryPlot);
            categoryPlot.rangeAxis.addChangeListener(categoryPlot);
        }
        categoryPlot.secondaryRangeAxes = (ObjectList)this.secondaryRangeAxes.clone();
        for (n = 0; n < categoryPlot.secondaryRangeAxes.size(); ++n) {
            ((CategoryAxis)categoryPlot.secondaryRangeAxes.get(n)).setPlot(categoryPlot);
            ((CategoryAxis)categoryPlot.secondaryRangeAxes.get(n)).addChangeListener(categoryPlot);
        }
        categoryPlot.secondaryRangeAxisLocations = (ObjectList)this.secondaryRangeAxisLocations.clone();
        if (categoryPlot.dataset != null) {
            categoryPlot.dataset.addChangeListener(categoryPlot);
        }
        categoryPlot.secondaryDatasets = (ObjectList)this.secondaryDatasets.clone();
        for (n = 0; n < categoryPlot.secondaryDatasets.size(); ++n) {
            ((CategoryDataset)categoryPlot.secondaryDatasets.get(n)).addChangeListener(categoryPlot);
        }
        categoryPlot.secondaryDatasetDomainAxisMap = (ObjectList)this.secondaryDatasetDomainAxisMap.clone();
        categoryPlot.secondaryDatasetRangeAxisMap = (ObjectList)this.secondaryDatasetRangeAxisMap.clone();
        if (this.renderer != null) {
            if (this.renderer instanceof PublicCloneable) {
                PublicCloneable publicCloneable = (PublicCloneable)this.renderer;
                categoryPlot.renderer = (CategoryItemRenderer)publicCloneable.clone();
            } else {
                throw new CloneNotSupportedException("CategoryPlot: renderer doesn't implement PublicCloneable.");
            }
        }
        categoryPlot.secondaryRenderers = (ObjectList)this.secondaryRenderers.clone();
        categoryPlot.fixedDomainAxisSpace = (AxisSpace)ObjectUtils.clone((Object)this.fixedDomainAxisSpace);
        categoryPlot.fixedRangeAxisSpace = (AxisSpace)ObjectUtils.clone((Object)this.fixedRangeAxisSpace);
        return categoryPlot;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeStroke((Stroke)this.domainGridlineStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.domainGridlinePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.rangeGridlineStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.rangeGridlinePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.rangeCrosshairStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.rangeCrosshairPaint, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.domainGridlineStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.domainGridlinePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.rangeGridlineStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.rangeGridlinePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.rangeCrosshairStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.rangeCrosshairPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        if (this.domainAxis != null) {
            this.domainAxis.setPlot(this);
            this.domainAxis.addChangeListener(this);
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.setPlot(this);
            this.rangeAxis.addChangeListener(this);
        }
        this.foregroundRangeMarkers = new ArrayList();
        this.backgroundRangeMarkers = new ArrayList();
        this.secondaryForegroundRangeMarkers = new HashMap();
        this.secondaryBackgroundRangeMarkers = new HashMap();
        Marker marker = new Marker(0.0, new Color(0.8f, 0.8f, 0.8f, 0.5f), new BasicStroke(1.0f), new Color(0.85f, 0.85f, 0.95f, 0.5f), 0.6f);
        this.addRangeMarker(marker, Layer.BACKGROUND);
    }
}

