/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Stack;
import org.jfree.chart.CrosshairInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AreaXYRenderer;
import org.jfree.chart.renderer.RangeType;
import org.jfree.chart.renderer.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.TableXYDataset;
import org.jfree.data.XYDataset;
import org.jfree.util.PublicCloneable;

public class StackedAreaXYRenderer
extends AreaXYRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private transient Stack lastSeriesPoints = null;
    private transient Stack thisSeriesPoints = null;
    private Paint shapePaint = null;
    private Stroke shapeStroke = null;

    public StackedAreaXYRenderer() {
        this(4);
    }

    public StackedAreaXYRenderer(int n) {
        this(n, null, null);
    }

    public StackedAreaXYRenderer(int n, XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        super(n, xYToolTipGenerator, xYURLGenerator);
    }

    public RangeType getRangeType() {
        return RangeType.STACKED;
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        return super.initialise(graphics2D, rectangle2D, xYPlot, xYDataset, plotRenderingInfo);
    }

    public int getPassCount() {
        return 2;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairInfo crosshairInfo, int n3) {
        TableXYDataset tableXYDataset = (TableXYDataset)xYDataset;
        int n4 = tableXYDataset.getItemCount();
        Number number = xYDataset.getXValue(n, n2);
        Number number2 = xYDataset.getYValue(n, n2);
        boolean bl = false;
        if (number2 == null) {
            number2 = new Double(0.0);
            bl = true;
        }
        double d = this.getPreviousHeight(xYDataset, n, n2);
        double d2 = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D, xYPlot.getDomainAxisEdge());
        double d3 = valueAxis2.translateValueToJava2D(number2.doubleValue() + d, rectangle2D, xYPlot.getRangeAxisEdge());
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        if (n3 == 0) {
            if (n2 == 0) {
                this.pArea = new Polygon();
                this.lastSeriesPoints = this.thisSeriesPoints;
                this.thisSeriesPoints = new Stack();
                double d4 = valueAxis2.translateValueToJava2D(d, rectangle2D, xYPlot.getRangeAxisEdge());
                if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                    this.pArea.addPoint((int)d2, (int)d4);
                } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                    this.pArea.addPoint((int)d4, (int)d2);
                }
            }
            if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                Point point = new Point((int)d2, (int)d3);
                this.pArea.addPoint((int)point.getX(), (int)point.getY());
                this.thisSeriesPoints.push(point);
            } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                this.pArea.addPoint((int)d3, (int)d2);
            }
            if (this.getPlotLines() && n2 > 0) {
                Number number3 = xYDataset.getXValue(n, n2 - 1);
                Number number4 = xYDataset.getYValue(n, n2 - 1);
                double d5 = this.getPreviousHeight(xYDataset, n, n2 - 1);
                double d6 = valueAxis.translateValueToJava2D(number3.doubleValue(), rectangle2D, xYPlot.getDomainAxisEdge());
                double d7 = valueAxis2.translateValueToJava2D(number4.doubleValue() + d5, rectangle2D, xYPlot.getRangeAxisEdge());
                if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                    this.line.setLine(d6, d7, d2, d3);
                } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                    this.line.setLine(d7, d6, d3, d2);
                }
                graphics2D.draw(this.line);
            }
            if (this.getPlotArea() && n2 > 0 && n2 == n4 - 1) {
                double d8 = valueAxis2.translateValueToJava2D(d, rectangle2D, xYPlot.getRangeAxisEdge());
                if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                    this.pArea.addPoint((int)d2, (int)d8);
                } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                    this.pArea.addPoint((int)d8, (int)d2);
                }
                if (n != 0) {
                    while (!this.lastSeriesPoints.empty()) {
                        Point point = (Point)this.lastSeriesPoints.pop();
                        this.pArea.addPoint((int)point.getX(), (int)point.getY());
                    }
                }
                graphics2D.setPaint(paint);
                graphics2D.setStroke(stroke);
                graphics2D.fill(this.pArea);
                if (this.isOutline()) {
                    graphics2D.setStroke(xYPlot.getOutlineStroke());
                    graphics2D.setPaint(xYPlot.getOutlinePaint());
                    graphics2D.draw(this.pArea);
                }
            }
            if (xYPlot.isDomainCrosshairLockedOnData()) {
                if (xYPlot.isRangeCrosshairLockedOnData()) {
                    crosshairInfo.updateCrosshairPoint(number.doubleValue(), number2.doubleValue(), d2, d3);
                } else {
                    crosshairInfo.updateCrosshairX(number.doubleValue());
                }
            } else if (xYPlot.isRangeCrosshairLockedOnData()) {
                crosshairInfo.updateCrosshairY(number2.doubleValue());
            }
        } else if (n3 == 1) {
            EntityCollection entityCollection;
            Shape shape = null;
            if (this.getPlotShapes()) {
                shape = this.getItemShape(n, n2);
                if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                    shape = this.createTransformedShape(shape, d2, d3);
                } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                    shape = this.createTransformedShape(shape, d3, d2);
                }
                if (!bl) {
                    if (this.shapePaint != null) {
                        graphics2D.setPaint(this.shapePaint);
                    } else {
                        graphics2D.setPaint(paint);
                    }
                    if (this.shapeStroke != null) {
                        graphics2D.setStroke(this.shapeStroke);
                    } else {
                        graphics2D.setStroke(stroke);
                    }
                    graphics2D.draw(shape);
                }
            } else if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                shape = new Rectangle2D.Double(d2 - 3.0, d3 - 3.0, 6.0, 6.0);
            } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                shape = new Rectangle2D.Double(d3 - 3.0, d2 - 3.0, 6.0, 6.0);
            }
            if (xYItemRendererState.getInfo() != null && (entityCollection = xYItemRendererState.getInfo().getOwner().getEntityCollection()) != null && shape != null && !bl) {
                String string = null;
                if (this.getToolTipGenerator() != null) {
                    string = this.getToolTipGenerator().generateToolTip(xYDataset, n, n2);
                }
                String string2 = null;
                if (this.getURLGenerator() != null) {
                    string2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
                }
                XYItemEntity xYItemEntity = new XYItemEntity(shape, xYDataset, n, n2, string, string2);
                entityCollection.addEntity(xYItemEntity);
            }
        }
    }

    protected double getPreviousHeight(XYDataset xYDataset, int n, int n2) {
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            Number number = xYDataset.getYValue(i, n2);
            if (number == null) continue;
            d += number.doubleValue();
        }
        return d;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Paint getShapePaint() {
        return this.shapePaint;
    }

    public Stroke getShapeStroke() {
        return this.shapeStroke;
    }

    public void setShapePaint(Paint paint) {
        this.shapePaint = paint;
    }

    public void setShapeStroke(Stroke stroke) {
        this.shapeStroke = stroke;
    }
}

