/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.BarRenderer;
import org.jfree.chart.renderer.CategoryItemRendererState;
import org.jfree.chart.renderer.ItemLabelAnchor;
import org.jfree.chart.renderer.ItemLabelPosition;
import org.jfree.chart.renderer.RangeType;
import org.jfree.data.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import org.jfree.util.PublicCloneable;

public class StackedBarRenderer
extends BarRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private boolean linkingLines = false;
    private transient double[] pointsRegister = null;

    public StackedBarRenderer() {
        ItemLabelPosition itemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER, TextAnchor.CENTER, 0.0);
        this.setBasePositiveItemLabelPosition(itemLabelPosition);
        this.setBaseNegativeItemLabelPosition(itemLabelPosition);
        this.setPositiveItemLabelPositionFallback(null);
        this.setNegativeItemLabelPositionFallback(null);
    }

    public RangeType getRangeType() {
        return RangeType.STACKED;
    }

    public boolean hasLinkingLines() {
        return this.linkingLines;
    }

    public void setLinkingLines(boolean bl) {
        this.linkingLines = bl;
    }

    protected void calculateBarWidth(CategoryPlot categoryPlot, Rectangle2D rectangle2D, Integer n, CategoryItemRendererState categoryItemRendererState) {
        CategoryAxis categoryAxis = this.getDomainAxis(categoryPlot, n);
        CategoryDataset categoryDataset = this.getDataset(categoryPlot, n);
        if (categoryDataset != null) {
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            double d = 0.0;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d = rectangle2D.getHeight();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                d = rectangle2D.getWidth();
            }
            int n2 = categoryDataset.getColumnCount();
            double d2 = 0.0;
            if (n2 > 1) {
                d2 = categoryAxis.getCategoryMargin();
            }
            double d3 = d * (1.0 - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin() - d2);
            if (n2 > 0) {
                categoryItemRendererState.setBarWidth(d3 / (double)n2);
            } else {
                categoryItemRendererState.setBarWidth(d3);
            }
        }
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            this.drawHorizontalItem(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n, n2);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            this.drawVerticalItem(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n, n2);
        }
    }

    public void drawHorizontalItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            Number number = categoryDataset.getValue(i, n2);
            if (number == null) continue;
            double d3 = number.doubleValue();
            if (d3 > 0.0) {
                d += d3;
                continue;
            }
            d2 += d3;
        }
        Number number = categoryDataset.getValue(n, n2);
        if (number != null) {
            EntityCollection entityCollection;
            CategoryItemLabelGenerator categoryItemLabelGenerator;
            double d4;
            double d5;
            double d6;
            double d7 = number.doubleValue();
            RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
            if (d7 > 0.0) {
                d6 = valueAxis.translateValueToJava2D(d, rectangle2D, rectangleEdge);
                d5 = valueAxis.translateValueToJava2D(d + d7, rectangle2D, rectangleEdge);
                d4 = Math.min(d6, d5);
            } else {
                d6 = valueAxis.translateValueToJava2D(d2, rectangle2D, rectangleEdge);
                d5 = valueAxis.translateValueToJava2D(d2 + d7, rectangle2D, rectangleEdge);
                d4 = Math.min(d6, d5);
            }
            double d8 = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
            double d9 = Math.abs(d5 - d6);
            double d10 = categoryItemRendererState.getBarWidth();
            Rectangle2D.Double double_ = new Rectangle2D.Double(d4, d8, d9, d10);
            Paint paint = this.getItemPaint(n, n2);
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
            if (this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0) {
                graphics2D.setStroke(this.getItemStroke(n, n2));
                graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
                graphics2D.draw(double_);
            }
            if ((categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2)) != null && this.isItemLabelVisible(n, n2)) {
                this.drawItemLabel(graphics2D, categoryDataset, n, n2, categoryPlot, categoryItemLabelGenerator, double_, d7 < 0.0);
            }
            if (categoryItemRendererState.getInfo() != null && (entityCollection = categoryItemRendererState.getInfo().getOwner().getEntityCollection()) != null) {
                String string = null;
                if (categoryItemLabelGenerator != null) {
                    string = categoryItemLabelGenerator.generateToolTip(categoryDataset, n, n2);
                }
                String string2 = null;
                if (this.getItemURLGenerator(n, n2) != null) {
                    string2 = this.getItemURLGenerator(n, n2).generateURL(categoryDataset, n, n2);
                }
                CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, string, string2, categoryDataset, n, categoryDataset.getColumnKey(n2), n2);
                entityCollection.addEntity(categoryItemEntity);
            }
        }
    }

    public void drawVerticalItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        double d;
        Number number;
        int n3;
        Paint paint = this.getItemPaint(n, n2);
        if (this.hasLinkingLines() && this.pointsRegister == null) {
            this.pointsRegister = new double[categoryDataset.getColumnCount() * categoryDataset.getRowCount() * 2];
        }
        double d2 = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d3 = 0.0;
        double d4 = 0.0;
        for (n3 = 0; n3 < n; ++n3) {
            number = categoryDataset.getValue(n3, n2);
            if (number == null) continue;
            d = number.doubleValue();
            if (d > 0.0) {
                d3 += d;
                continue;
            }
            d4 += d;
        }
        n3 = 0;
        number = categoryDataset.getValue(n, n2);
        if (number != null) {
            EntityCollection entityCollection;
            Object object;
            CategoryItemLabelGenerator categoryItemLabelGenerator;
            double d5;
            double d6;
            double d7;
            d = number.doubleValue();
            RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
            if (d > 0.0) {
                d7 = valueAxis.translateValueToJava2D(d3, rectangle2D, rectangleEdge);
                d6 = valueAxis.translateValueToJava2D(d3 + d, rectangle2D, rectangleEdge);
                d5 = Math.min(d7, d6);
                n3 = 1;
            } else {
                d7 = valueAxis.translateValueToJava2D(d4, rectangle2D, rectangleEdge);
                d6 = valueAxis.translateValueToJava2D(d4 + d, rectangle2D, rectangleEdge);
                d5 = Math.min(d7, d6);
            }
            double d8 = categoryItemRendererState.getBarWidth();
            double d9 = Math.abs(d6 - d7);
            Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d5, d8, d9);
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
            if (this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0) {
                graphics2D.setStroke(this.getItemStroke(n, n2));
                graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
                graphics2D.draw(double_);
            }
            if ((categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2)) != null && this.isItemLabelVisible(n, n2)) {
                this.drawItemLabel(graphics2D, categoryDataset, n, n2, categoryPlot, categoryItemLabelGenerator, double_, d < 0.0);
            }
            if (this.hasLinkingLines()) {
                if (n2 == 0) {
                    this.pointsRegister[2 * n] = d2 + d8;
                    this.pointsRegister[2 * n + 1] = n3 != 0 ? d5 : d5 + d9;
                } else {
                    double d10;
                    int n4 = n2 * categoryDataset.getRowCount() * 2 + 2 * n;
                    this.pointsRegister[n4] = d2 + d8;
                    if (n3 != 0) {
                        d10 = this.pointsRegister[n4 - 2 * categoryDataset.getRowCount()];
                        if (d10 > 0.0) {
                            object = new Line2D.Double(d2, d5, d10, this.pointsRegister[n4 - 2 * categoryDataset.getRowCount() + 1]);
                            graphics2D.setPaint(Color.black);
                            graphics2D.draw((Shape)object);
                        }
                        this.pointsRegister[n4 + 1] = d5;
                    } else {
                        d10 = this.pointsRegister[n4 - 2 * categoryDataset.getRowCount()];
                        if (d10 > 0.0) {
                            object = new Line2D.Double(d2, d5 + d9, d10, this.pointsRegister[n4 - 2 * categoryDataset.getRowCount() + 1]);
                            graphics2D.setPaint(Color.black);
                            graphics2D.draw((Shape)object);
                        }
                        this.pointsRegister[n4 + 1] = d5 + d9;
                    }
                }
            }
            if (categoryItemRendererState.getInfo() != null && (entityCollection = categoryItemRendererState.getInfo().getOwner().getEntityCollection()) != null) {
                String string = null;
                if (categoryItemLabelGenerator != null) {
                    string = categoryItemLabelGenerator.generateToolTip(categoryDataset, n, n2);
                }
                String string2 = null;
                if (this.getItemURLGenerator(n, n2) != null) {
                    string2 = this.getItemURLGenerator(n, n2).generateURL(categoryDataset, n, n2);
                }
                object = new CategoryItemEntity(double_, string, string2, categoryDataset, n, categoryDataset.getColumnKey(n2), n2);
                entityCollection.addEntity((ChartEntity)object);
            }
        }
    }
}

