/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.BarRenderer3D;
import org.jfree.chart.renderer.CategoryItemRendererState;
import org.jfree.chart.renderer.RangeType;
import org.jfree.data.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class StackedBarRenderer3D
extends BarRenderer3D
implements Cloneable,
PublicCloneable,
Serializable {
    public RangeType getRangeType() {
        return RangeType.STACKED;
    }

    protected void calculateBarWidth(CategoryPlot categoryPlot, Rectangle2D rectangle2D, Integer n, CategoryItemRendererState categoryItemRendererState) {
        CategoryAxis categoryAxis = this.getDomainAxis(categoryPlot, n);
        CategoryDataset categoryDataset = this.getDataset(categoryPlot, n);
        if (categoryDataset != null) {
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            double d = 0.0;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d = rectangle2D.getHeight();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                d = rectangle2D.getWidth();
            }
            int n2 = categoryDataset.getColumnCount();
            double d2 = 0.0;
            if (n2 > 1) {
                d2 = categoryAxis.getCategoryMargin();
            }
            double d3 = d * (1.0 - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin() - d2);
            if (n2 > 0) {
                categoryItemRendererState.setBarWidth(d3 / (double)n2);
            } else {
                categoryItemRendererState.setBarWidth(d3);
            }
        }
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            this.drawHorizontalItem(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n, n2);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            this.drawVerticalItem(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n, n2);
        }
    }

    protected void drawHorizontalItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        Paint paint = this.getItemPaint(n, n2);
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + this.getYOffset(), rectangle2D.getWidth() - this.getXOffset(), rectangle2D.getHeight() - this.getYOffset());
        double d = categoryAxis.getCategoryStart(n2, this.getColumnCount(), double_, categoryPlot.getDomainAxisEdge());
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            Number number = categoryDataset.getValue(i, n2);
            if (number == null) continue;
            double d4 = number.doubleValue();
            if (d4 > 0.0) {
                d2 += d4;
                continue;
            }
            d3 += d4;
        }
        Number number = categoryDataset.getValue(n, n2);
        if (number != null) {
            EntityCollection entityCollection;
            double d5;
            double d6;
            double d7 = number.doubleValue();
            RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
            if (d7 > 0.0) {
                d6 = valueAxis.translateValueToJava2D(d2, double_, rectangleEdge);
                d5 = valueAxis.translateValueToJava2D(d2 + d7, double_, rectangleEdge);
            } else {
                d6 = valueAxis.translateValueToJava2D(d3, double_, rectangleEdge);
                d5 = valueAxis.translateValueToJava2D(d3 + d7, double_, rectangleEdge);
            }
            double d8 = Math.min(d6, d5);
            double d9 = Math.max(d6, d5);
            double d10 = d + categoryItemRendererState.getBarWidth();
            double d11 = d10 - this.getYOffset();
            double d12 = d - this.getYOffset();
            double d13 = d8 + this.getXOffset();
            double d14 = d9 + this.getXOffset();
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d8, d, d9 - d8, d10 - d);
            graphics2D.setPaint(paint);
            graphics2D.fill(double_2);
            GeneralPath generalPath = null;
            GeneralPath generalPath2 = null;
            if (d - d8 != 0.0) {
                if (d7 > 0.0) {
                    generalPath = new GeneralPath();
                    generalPath.moveTo((float)d9, (float)d10);
                    generalPath.lineTo((float)d9, (float)d);
                    generalPath.lineTo((float)d14, (float)d12);
                    generalPath.lineTo((float)d14, (float)d11);
                    generalPath.closePath();
                    if (paint instanceof Color) {
                        graphics2D.setPaint(((Color)paint).darker());
                    }
                    graphics2D.fill(generalPath);
                }
                generalPath2 = new GeneralPath();
                generalPath2.moveTo((float)d8, (float)d);
                generalPath2.lineTo((float)d13, (float)d12);
                generalPath2.lineTo((float)d14, (float)d12);
                generalPath2.lineTo((float)d9, (float)d);
                generalPath2.closePath();
                graphics2D.fill(generalPath2);
            }
            if (d10 - d > 3.0) {
                graphics2D.setStroke(this.getItemStroke(n, n2));
                graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
                graphics2D.draw(double_2);
                if (generalPath != null) {
                    graphics2D.draw(generalPath);
                }
                if (generalPath2 != null) {
                    graphics2D.draw(generalPath2);
                }
            }
            if (categoryItemRendererState.getInfo() != null && (entityCollection = categoryItemRendererState.getInfo().getOwner().getEntityCollection()) != null) {
                String string = null;
                CategoryItemLabelGenerator categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2);
                if (categoryItemLabelGenerator != null) {
                    string = categoryItemLabelGenerator.generateToolTip(categoryDataset, n, n2);
                }
                String string2 = null;
                if (this.getItemURLGenerator(n, n2) != null) {
                    string2 = this.getItemURLGenerator(n, n2).generateURL(categoryDataset, n, n2);
                }
                CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_2, string, string2, categoryDataset, n, categoryDataset.getColumnKey(n2), n2);
                entityCollection.addEntity(categoryItemEntity);
            }
        }
    }

    protected void drawVerticalItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        Paint paint = this.getItemPaint(n, n2);
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + this.getYOffset(), rectangle2D.getWidth() - this.getXOffset(), rectangle2D.getHeight() - this.getYOffset());
        double d = categoryAxis.getCategoryStart(n2, this.getColumnCount(), double_, categoryPlot.getDomainAxisEdge());
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            Number number = categoryDataset.getValue(i, n2);
            if (number == null) continue;
            double d4 = number.doubleValue();
            if (d4 > 0.0) {
                d2 += d4;
                continue;
            }
            d3 += d4;
        }
        Number number = categoryDataset.getValue(n, n2);
        if (number != null) {
            EntityCollection entityCollection;
            double d5;
            double d6;
            double d7 = number.doubleValue();
            RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
            if (d7 > 0.0) {
                d6 = valueAxis.translateValueToJava2D(d2, double_, rectangleEdge);
                d5 = valueAxis.translateValueToJava2D(d2 + d7, double_, rectangleEdge);
            } else {
                d6 = valueAxis.translateValueToJava2D(d3, double_, rectangleEdge);
                d5 = valueAxis.translateValueToJava2D(d3 + d7, double_, rectangleEdge);
            }
            double d8 = Math.max(d6, d5);
            double d9 = Math.min(d6, d5);
            double d10 = d + categoryItemRendererState.getBarWidth();
            double d11 = d + this.getXOffset();
            double d12 = d10 + this.getXOffset();
            double d13 = d8 - this.getYOffset();
            double d14 = d9 - this.getYOffset();
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d, d9, d10 - d, d8 - d9);
            graphics2D.setPaint(paint);
            graphics2D.fill(double_2);
            GeneralPath generalPath = null;
            GeneralPath generalPath2 = null;
            if (d8 - d9 != 0.0) {
                generalPath = new GeneralPath();
                generalPath.moveTo((float)d10, (float)d8);
                generalPath.lineTo((float)d10, (float)d9);
                generalPath.lineTo((float)d12, (float)d14);
                generalPath.lineTo((float)d12, (float)d13);
                generalPath.closePath();
                if (paint instanceof Color) {
                    graphics2D.setPaint(((Color)paint).darker());
                }
                graphics2D.fill(generalPath);
                if (d7 > 0.0) {
                    generalPath2 = new GeneralPath();
                    generalPath2.moveTo((float)d, (float)d9);
                    generalPath2.lineTo((float)d10, (float)d9);
                    generalPath2.lineTo((float)d12, (float)d14);
                    generalPath2.lineTo((float)d11, (float)d14);
                    generalPath2.closePath();
                    graphics2D.fill(generalPath2);
                }
            }
            if (d10 - d > 3.0) {
                graphics2D.setStroke(this.getItemStroke(n, n2));
                graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
                graphics2D.draw(double_2);
                if (generalPath != null) {
                    graphics2D.draw(generalPath);
                }
                if (generalPath2 != null) {
                    graphics2D.draw(generalPath2);
                }
            }
            if (categoryItemRendererState.getInfo() != null && (entityCollection = categoryItemRendererState.getInfo().getOwner().getEntityCollection()) != null) {
                String string = null;
                CategoryItemLabelGenerator categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2);
                if (categoryItemLabelGenerator != null) {
                    string = categoryItemLabelGenerator.generateToolTip(categoryDataset, n, n2);
                }
                String string2 = null;
                if (this.getItemURLGenerator(n, n2) != null) {
                    string2 = this.getItemURLGenerator(n, n2).generateURL(categoryDataset, n, n2);
                }
                CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_2, string, string2, categoryDataset, n, categoryDataset.getColumnKey(n2), n2);
                entityCollection.addEntity(categoryItemEntity);
            }
        }
    }
}

