/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues2D;

public class DefaultKeyedValues2D
implements KeyedValues2D,
Cloneable,
Serializable {
    private List rowKeys = new ArrayList();
    private List columnKeys = new ArrayList();
    private List rows = new ArrayList();

    public int getRowCount() {
        return this.rowKeys.size();
    }

    public int getColumnCount() {
        return this.columnKeys.size();
    }

    public Number getValue(int n, int n2) {
        Comparable comparable;
        Number number = null;
        DefaultKeyedValues defaultKeyedValues = (DefaultKeyedValues)this.rows.get(n);
        if (defaultKeyedValues != null && (comparable = (Comparable)this.columnKeys.get(n2)) != null) {
            number = defaultKeyedValues.getValue(comparable);
        }
        return number;
    }

    public Comparable getRowKey(int n) {
        return (Comparable)this.rowKeys.get(n);
    }

    public int getRowIndex(Comparable comparable) {
        return this.rowKeys.indexOf(comparable);
    }

    public List getRowKeys() {
        return Collections.unmodifiableList(this.rowKeys);
    }

    public Comparable getColumnKey(int n) {
        return (Comparable)this.columnKeys.get(n);
    }

    public int getColumnIndex(Comparable comparable) {
        return this.columnKeys.indexOf(comparable);
    }

    public List getColumnKeys() {
        return Collections.unmodifiableList(this.columnKeys);
    }

    public Number getValue(Comparable comparable, Comparable comparable2) {
        Number number = null;
        int n = this.rowKeys.indexOf(comparable);
        if (n >= 0) {
            DefaultKeyedValues defaultKeyedValues = (DefaultKeyedValues)this.rows.get(n);
            number = defaultKeyedValues.getValue(comparable2);
        }
        return number;
    }

    public void addValue(Number number, Comparable comparable, Comparable comparable2) {
        this.setValue(number, comparable, comparable2);
    }

    public void setValue(Number number, Comparable comparable, Comparable comparable2) {
        DefaultKeyedValues defaultKeyedValues = null;
        int n = this.rowKeys.indexOf(comparable);
        if (n >= 0) {
            defaultKeyedValues = (DefaultKeyedValues)this.rows.get(n);
        } else {
            this.rowKeys.add(comparable);
            defaultKeyedValues = new DefaultKeyedValues();
            this.rows.add(defaultKeyedValues);
        }
        defaultKeyedValues.setValue(comparable2, number);
        int n2 = this.columnKeys.indexOf(comparable2);
        if (n2 < 0) {
            this.columnKeys.add(comparable2);
        }
    }

    public void removeValue(Comparable comparable, Comparable comparable2) {
        this.setValue(null, comparable, comparable2);
    }

    public void removeRow(int n) {
        this.rowKeys.remove(n);
        this.rows.remove(n);
    }

    public void removeRow(Comparable comparable) {
        this.removeRow(this.getRowIndex(comparable));
    }

    public void removeColumn(int n) {
        Comparable comparable = this.getColumnKey(n);
        this.removeColumn(comparable);
    }

    public void removeColumn(Comparable comparable) {
        Iterator iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            DefaultKeyedValues defaultKeyedValues = (DefaultKeyedValues)iterator.next();
            defaultKeyedValues.removeValue(comparable);
        }
        this.columnKeys.remove(comparable);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof KeyedValues2D) {
            KeyedValues2D keyedValues2D = (KeyedValues2D)object;
            boolean bl = ((Object)this.getRowKeys()).equals(keyedValues2D.getRowKeys());
            boolean bl2 = ((Object)this.getColumnKeys()).equals(keyedValues2D.getColumnKeys());
            if (bl && bl2) {
                for (int i = 0; i < this.getRowCount(); ++i) {
                    for (int j = 0; j < this.getColumnCount(); ++j) {
                        Number number = this.getValue(i, j);
                        Number number2 = keyedValues2D.getValue(i, j);
                        if (!(number == null ? number2 != null : !number.equals(number2))) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

