/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.jfree.data.AbstractSeriesDataset;
import org.jfree.data.DatasetChangeEvent;
import org.jfree.data.DomainInfo;
import org.jfree.data.IntervalXYDataset;
import org.jfree.data.Range;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriodAnchor;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.util.ObjectUtils;

public class TimeSeriesCollection
extends AbstractSeriesDataset
implements IntervalXYDataset,
DomainInfo,
Serializable {
    public static final int START = 0;
    public static final int MIDDLE = 1;
    public static final int END = 2;
    private List data = new ArrayList();
    private Calendar workingCalendar;
    private TimePeriodAnchor xPosition;
    private boolean domainIsPointsInTime;

    public TimeSeriesCollection() {
        this(null, TimeZone.getDefault());
    }

    public TimeSeriesCollection(TimeZone timeZone) {
        this(null, timeZone);
    }

    public TimeSeriesCollection(TimeSeries timeSeries) {
        this(timeSeries, TimeZone.getDefault());
    }

    public TimeSeriesCollection(TimeSeries timeSeries, TimeZone timeZone) {
        this.workingCalendar = Calendar.getInstance(timeZone);
        this.xPosition = TimePeriodAnchor.MIDDLE;
        this.domainIsPointsInTime = true;
        if (timeSeries != null) {
            this.data.add(timeSeries);
            timeSeries.addChangeListener(this);
        }
    }

    public int getPosition() {
        int n = 1;
        TimePeriodAnchor timePeriodAnchor = this.getXPosition();
        if (timePeriodAnchor == TimePeriodAnchor.START) {
            n = 0;
        } else if (timePeriodAnchor == TimePeriodAnchor.MIDDLE) {
            n = 1;
        } else if (timePeriodAnchor == TimePeriodAnchor.END) {
            n = 2;
        }
        return n;
    }

    public void setPosition(int n) {
        if (n == 0) {
            this.setXPosition(TimePeriodAnchor.START);
        } else if (n == 1) {
            this.setXPosition(TimePeriodAnchor.MIDDLE);
        } else if (n == 2) {
            this.setXPosition(TimePeriodAnchor.END);
        }
    }

    public TimePeriodAnchor getXPosition() {
        return this.xPosition;
    }

    public void setXPosition(TimePeriodAnchor timePeriodAnchor) {
        this.xPosition = timePeriodAnchor;
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    public boolean getDomainIsPointsInTime() {
        return this.domainIsPointsInTime;
    }

    public void setDomainIsPointsInTime(boolean bl) {
        this.domainIsPointsInTime = bl;
    }

    public List getSeries() {
        return Collections.unmodifiableList(this.data);
    }

    public int getSeriesCount() {
        return this.data.size();
    }

    public TimeSeries getSeries(int n) {
        if (n < 0 || n > this.getSeriesCount()) {
            throw new IllegalArgumentException("TimeSeriesDataset.getSeries(...): index outside valid range.");
        }
        TimeSeries timeSeries = (TimeSeries)this.data.get(n);
        return timeSeries;
    }

    public TimeSeries getSeries(String string) {
        TimeSeries timeSeries = null;
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            TimeSeries timeSeries2 = (TimeSeries)iterator.next();
            String string2 = timeSeries2.getName();
            if (string2 == null || !string2.equals(string)) continue;
            timeSeries = timeSeries2;
        }
        return timeSeries;
    }

    public String getSeriesName(int n) {
        return this.getSeries(n).getName();
    }

    public void addSeries(TimeSeries timeSeries) {
        if (timeSeries == null) {
            throw new IllegalArgumentException("TimeSeriesDataset.addSeries(...): cannot add null series.");
        }
        this.data.add(timeSeries);
        timeSeries.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public void removeSeries(TimeSeries timeSeries) {
        if (timeSeries == null) {
            throw new IllegalArgumentException("TimeSeriesDataset.addSeries(...): cannot remove null series.");
        }
        this.data.remove(timeSeries);
        timeSeries.removeChangeListener(this);
        this.fireDatasetChanged();
    }

    public void removeSeries(int n) {
        TimeSeries timeSeries = this.getSeries(n);
        if (timeSeries != null) {
            this.removeSeries(timeSeries);
        }
    }

    public void removeAllSeries() {
        for (int i = 0; i < this.data.size(); ++i) {
            TimeSeries timeSeries = (TimeSeries)this.data.get(i);
            timeSeries.removeChangeListener(this);
        }
        this.data.clear();
        this.fireDatasetChanged();
    }

    public int getItemCount(int n) {
        return this.getSeries(n).getItemCount();
    }

    public Number getXValue(int n, int n2) {
        TimeSeries timeSeries = (TimeSeries)this.data.get(n);
        TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataItem(n2);
        RegularTimePeriod regularTimePeriod = timeSeriesDataItem.getPeriod();
        return new Long(this.getX(regularTimePeriod));
    }

    public int[] getSurroundingItems(int n, long l) {
        int[] nArray = new int[]{-1, -1};
        TimeSeries timeSeries = this.getSeries(n);
        for (int i = 0; i < timeSeries.getItemCount(); ++i) {
            Number number = this.getXValue(n, i);
            long l2 = number.longValue();
            if (l2 <= l) {
                nArray[0] = i;
            }
            if (l2 < l) continue;
            nArray[1] = i;
            break;
        }
        return nArray;
    }

    private long getX(RegularTimePeriod regularTimePeriod) {
        long l = 0L;
        if (this.xPosition == TimePeriodAnchor.START) {
            l = regularTimePeriod.getFirstMillisecond(this.workingCalendar);
        } else if (this.xPosition == TimePeriodAnchor.MIDDLE) {
            l = regularTimePeriod.getMiddleMillisecond(this.workingCalendar);
        } else if (this.xPosition == TimePeriodAnchor.END) {
            l = regularTimePeriod.getLastMillisecond(this.workingCalendar);
        }
        return l;
    }

    public Number getStartXValue(int n, int n2) {
        TimeSeries timeSeries = (TimeSeries)this.data.get(n);
        TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataItem(n2);
        return new Long(timeSeriesDataItem.getPeriod().getFirstMillisecond(this.workingCalendar));
    }

    public Number getEndXValue(int n, int n2) {
        TimeSeries timeSeries = (TimeSeries)this.data.get(n);
        TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataItem(n2);
        return new Long(timeSeriesDataItem.getPeriod().getLastMillisecond(this.workingCalendar));
    }

    public Number getYValue(int n, int n2) {
        TimeSeries timeSeries = (TimeSeries)this.data.get(n);
        TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataItem(n2);
        return timeSeriesDataItem.getValue();
    }

    public Number getStartYValue(int n, int n2) {
        return this.getYValue(n, n2);
    }

    public Number getEndYValue(int n, int n2) {
        return this.getYValue(n, n2);
    }

    public Number getMinimumDomainValue() {
        Range range = this.getDomainRange();
        return new Double(range.getLowerBound());
    }

    public Number getMaximumDomainValue() {
        Range range = this.getDomainRange();
        return new Double(range.getUpperBound());
    }

    public Range getDomainRange() {
        Range range = null;
        Range range2 = null;
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            TimeSeries timeSeries = (TimeSeries)iterator.next();
            int n = timeSeries.getItemCount();
            if (n <= 0) continue;
            RegularTimePeriod regularTimePeriod = timeSeries.getTimePeriod(0);
            RegularTimePeriod regularTimePeriod2 = timeSeries.getTimePeriod(n - 1);
            range2 = this.domainIsPointsInTime ? new Range(this.getX(regularTimePeriod), this.getX(regularTimePeriod2)) : new Range(regularTimePeriod.getFirstMillisecond(this.workingCalendar), regularTimePeriod2.getLastMillisecond(this.workingCalendar));
            range = Range.combine(range, range2);
        }
        return range;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof TimeSeriesCollection) {
            TimeSeriesCollection timeSeriesCollection = (TimeSeriesCollection)object;
            boolean bl = ObjectUtils.equal((Object)this.data, (Object)timeSeriesCollection.data);
            boolean bl2 = this.xPosition == timeSeriesCollection.xPosition;
            boolean bl3 = this.domainIsPointsInTime == timeSeriesCollection.domainIsPointsInTime;
            return bl && bl2 && bl3;
        }
        return false;
    }
}

