/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.mapdata;

import java.awt.Color;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.mapdata.MapData;

abstract class IntegerMapData
implements MapData {
    private static Logger logger = Logger.getLogger(IntegerMapData.class.getName());
    private static int IMAGE_WIDTH = 300;
    private static int IMAGE_HEIGHT = 300;
    public static final double HALF_MAP_ANGLE = 0.48587;
    public static final int MAP_HEIGHT = 1440;
    public static final int MAP_WIDTH = 2880;
    public static final double PIXEL_RHO = 458.3662361046586;
    private static final double TWO_PI = Math.PI * 2;
    private List<int[]> mapColors = null;

    public IntegerMapData(String indexFileName, String mapFileName) {
        try {
            int[] index = this.loadIndexData(indexFileName);
            this.mapColors = this.loadMapData(mapFileName, index);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Could not find map data files.", e);
        }
    }

    private int[] loadIndexData(String filename) throws IOException {
        ClassLoader loader = this.getClass().getClassLoader();
        InputStream indexStream = loader.getResourceAsStream(filename);
        if (indexStream == null) {
            throw new IOException("Can not load " + filename);
        }
        BufferedInputStream indexBuff = new BufferedInputStream(indexStream);
        DataInputStream indexReader = new DataInputStream(indexBuff);
        int[] index = new int[1440];
        for (int x = 0; x < index.length; ++x) {
            index[x] = indexReader.readInt();
        }
        indexReader.close();
        indexBuff.close();
        return index;
    }

    private ArrayList<int[]> loadMapData(String filename, int[] index) throws IOException {
        ClassLoader loader = this.getClass().getClassLoader();
        InputStream mapStream = loader.getResourceAsStream(filename);
        if (mapStream == null) {
            throw new IOException("Can not load " + filename);
        }
        BufferedInputStream mapBuff = new BufferedInputStream(mapStream);
        DataInputStream mapReader = new DataInputStream(mapBuff);
        ArrayList<int[]> mapColors = new ArrayList<int[]>(1440);
        for (int x = 0; x < 1440; ++x) {
            int[] colors = new int[index[x]];
            for (int y = 0; y < colors.length; ++y) {
                int red = mapReader.readByte();
                red <<= 16;
                int green = mapReader.readByte();
                green <<= 8;
                int blue = mapReader.readByte();
                int totalColor = 0xFF000000 | (red &= 0xFF0000) | (green &= 0xFF00) | (blue &= 0xFF);
                colors[y] = new Color(totalColor).getRGB();
            }
            mapColors.add(colors);
        }
        return mapColors;
    }

    @Override
    public Image getMapImage(double centerPhi, double centerTheta) {
        double endPhi;
        double correctedTheta;
        BufferedImage result = new BufferedImage(IMAGE_WIDTH, IMAGE_HEIGHT, 2);
        for (correctedTheta = centerTheta - Math.PI; correctedTheta < 0.0; correctedTheta += Math.PI * 2) {
        }
        while (correctedTheta > Math.PI * 2) {
            correctedTheta -= Math.PI * 2;
        }
        int[] mapArray = new int[IMAGE_WIDTH * IMAGE_HEIGHT];
        double phiIterationPadding = 1.26;
        double phiIterationAngle = Math.PI / (1440.0 * phiIterationPadding);
        double phiPadding = 1.46;
        double phiRange = (double)IMAGE_HEIGHT / 1440.0 * Math.PI * phiPadding;
        double startPhi = centerPhi - phiRange / 2.0;
        if (startPhi < 0.0) {
            startPhi = 0.0;
        }
        if ((endPhi = centerPhi + phiRange / 2.0) > Math.PI) {
            endPhi = Math.PI;
        }
        for (double x = startPhi; x <= endPhi; x += phiIterationAngle) {
            double thetaIterationPadding = 1.46;
            double thetaIterationAngle = Math.PI * 2 / (2880.0 * Math.sin(x) * thetaIterationPadding + 1.0);
            double minThetaPadding = 1.02;
            double minThetaDisplay = Math.PI * 2 * ((double)IMAGE_WIDTH / 2880.0) * minThetaPadding;
            double thetaRange = (1.0 - Math.sin(x)) * (Math.PI * 2) + minThetaDisplay;
            double polarCapRange = 0.4803658491727512;
            if (x < polarCapRange || x > Math.PI - polarCapRange) {
                thetaRange = Math.PI * 2;
            }
            if (thetaRange > Math.PI * 2) {
                thetaRange = Math.PI * 2;
            }
            double startTheta = centerTheta - thetaRange / 2.0;
            double endTheta = centerTheta + thetaRange / 2.0;
            for (double y = startTheta; y <= endTheta; y += thetaIterationAngle) {
                int index;
                boolean bottomBounds;
                double yCorrected;
                for (yCorrected = y; yCorrected < 0.0; yCorrected += Math.PI * 2) {
                }
                while (yCorrected > Math.PI * 2) {
                    yCorrected -= Math.PI * 2;
                }
                Point location = this.findRectPosition(centerPhi, centerTheta, x, yCorrected, 458.3662361046586, 720, 570);
                int displayX = IMAGE_WIDTH - location.x;
                int displayY = IMAGE_HEIGHT - location.y;
                boolean leftBounds = displayX >= 0;
                boolean rightBounds = displayX < IMAGE_WIDTH;
                boolean topBounds = displayY >= 0;
                boolean bl = bottomBounds = displayY < IMAGE_HEIGHT;
                if (!leftBounds || !rightBounds || !topBounds || !bottomBounds || (index = IMAGE_WIDTH - displayX + (IMAGE_HEIGHT - displayY) * IMAGE_WIDTH) < 0 || index >= mapArray.length) continue;
                mapArray[index] = this.getRGBColorInt(x, yCorrected);
            }
        }
        result.setRGB(0, 0, IMAGE_WIDTH, IMAGE_HEIGHT, mapArray, 0, IMAGE_WIDTH);
        return result;
    }

    @Override
    public Color getRGBColor(double phi, double theta) {
        return new Color(this.getRGBColorInt(phi, theta));
    }

    private int getRGBColorInt(double phi, double theta) {
        int[] colorRow;
        int column;
        while (phi > Math.PI) {
            phi -= Math.PI;
        }
        while (phi < 0.0) {
            phi += Math.PI;
        }
        theta += Math.PI;
        while (theta > Math.PI * 2) {
            theta -= Math.PI * 2;
        }
        while (theta < 0.0) {
            theta += Math.PI * 2;
        }
        int row = (int)Math.round(phi * 458.3662361046586);
        if (row == this.mapColors.size()) {
            --row;
        }
        if ((column = (int)Math.round(theta * ((double)(colorRow = this.mapColors.get(row)).length / (Math.PI * 2)))) == colorRow.length) {
            --column;
        }
        return colorRow[column];
    }

    public Point findRectPosition(double oldPhi, double oldTheta, double newPhi, double newTheta, double rho, int half_map, int low_edge) {
        double temp_col = newTheta + (-1.5707963267948966 - oldTheta);
        double temp_buff_x = rho * Math.sin(newPhi);
        int buff_x = (int)Math.round(temp_buff_x * Math.cos(temp_col)) + half_map - low_edge;
        int buff_y = (int)Math.round(temp_buff_x * (0.0 - Math.cos(oldPhi)) * Math.sin(temp_col) + rho * Math.cos(newPhi) * (0.0 - Math.sin(oldPhi))) + half_map - low_edge;
        return new Point(buff_x, buff_y);
    }
}

