/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.mapdata;

import org.mars_sim.msp.mapdata.MapData;
import org.mars_sim.msp.mapdata.SurfaceMapData;
import org.mars_sim.msp.mapdata.TopoMapData;

class MapDataFactory {
    static final String SURFACE_MAP_DATA = "surface map data";
    static final String TOPO_MAP_DATA = "topographical map data";
    private MapData surfaceMapData;
    private MapData topoMapData;

    MapDataFactory() {
    }

    MapData getMapData(String mapType) {
        MapData result = null;
        if (mapType.equals(SURFACE_MAP_DATA)) {
            result = this.getSurfaceMapData();
        } else if (mapType.equals(TOPO_MAP_DATA)) {
            result = this.getTopoMapData();
        } else {
            throw new IllegalArgumentException("mapType: " + mapType + " not a valid type.");
        }
        return result;
    }

    private MapData getSurfaceMapData() {
        if (this.surfaceMapData == null) {
            this.surfaceMapData = new SurfaceMapData();
        }
        return this.surfaceMapData;
    }

    private MapData getTopoMapData() {
        if (this.topoMapData == null) {
            this.topoMapData = new TopoMapData();
        }
        return this.topoMapData;
    }
}

