/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.ui.swing.MainWindow;
import org.mars_sim.msp.ui.swing.SplashWindow;
import org.mars_sim.msp.ui.swing.configeditor.TempSimulationConfigEditor;

public class MarsProject {
    private static Logger logger = Logger.getLogger(MarsProject.class.getName());
    private boolean useGUI = true;

    public MarsProject(String[] args) {
        logger.info("Starting Mars Simulation");
        List<String> argList = Arrays.asList(args);
        boolean bl = this.useGUI = !argList.contains("-headless");
        if (this.useGUI) {
            SplashWindow splashWindow = new SplashWindow();
            splashWindow.show();
            boolean newSim = this.initializeSimulation(args);
            MainWindow w = new MainWindow(newSim);
            w.getFrame().setVisible(true);
            this.startSimulation();
            splashWindow.hide();
        } else {
            this.initializeSimulation(args);
            this.startSimulation();
        }
    }

    private boolean initializeSimulation(String[] args) {
        boolean result = false;
        List<String> argList = Arrays.asList(args);
        if (argList.contains("-new")) {
            this.handleNewSimulation();
            result = true;
        } else if (argList.contains("-load")) {
            try {
                this.handleLoadSimulation(argList);
            }
            catch (Exception e) {
                this.showError("Could not load the desired simulation, trying to create a new Simulation...", e);
                this.handleNewSimulation();
                result = true;
            }
        } else {
            try {
                this.handleLoadDefaultSimulation();
            }
            catch (Exception e) {
                this.handleNewSimulation();
                result = true;
            }
        }
        return result;
    }

    private void exitWithError(String message, Exception e) {
        this.showError(message, e);
        System.exit(1);
    }

    private void showError(String message, Exception e) {
        if (e != null) {
            logger.log(Level.SEVERE, message, e);
        } else {
            logger.log(Level.SEVERE, message);
        }
        if (this.useGUI) {
            JOptionPane.showMessageDialog(null, message, "Error", 0);
        }
    }

    private void handleLoadDefaultSimulation() throws Exception {
        try {
            Simulation.instance().loadSimulation(null);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could not load default simulation", e);
            throw e;
        }
    }

    private void handleLoadSimulation(List<String> argList) throws Exception {
        try {
            int index = argList.indexOf("-load");
            File loadFile = new File(argList.get(index + 1));
            if (loadFile.exists() && loadFile.canRead()) {
                Simulation.instance().loadSimulation(loadFile);
            } else {
                this.exitWithError("Problem loading simulation. " + argList.get(index + 1) + " not found.", null);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Problem loading existing simulation", e);
            throw e;
        }
    }

    private void handleNewSimulation() {
        try {
            SimulationConfig.loadConfig();
            if (this.useGUI) {
                TempSimulationConfigEditor editor = new TempSimulationConfigEditor(null, SimulationConfig.instance());
                editor.setVisible(true);
            }
            Simulation.createNewSimulation();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.exitWithError("Could not create a new simulation, startup cannot continue", e);
        }
    }

    public void startSimulation() {
        Simulation.instance().start();
    }

    public static void main(String[] args) {
        new File(System.getProperty("user.home"), ".mars-sim" + File.separator + "logs").mkdirs();
        try {
            LogManager.getLogManager().readConfiguration(MarsProject.class.getResourceAsStream("/logging.properties"));
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not load logging properties", e);
            try {
                LogManager.getLogManager().readConfiguration();
            }
            catch (IOException e1) {
                logger.log(Level.WARNING, "Could read logging default config", e);
            }
        }
        System.setProperty("swing.aatext", "true");
        new MarsProject(args);
    }
}

