/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.text;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.text.TextFragment;
import org.jfree.ui.TextAnchor;

public class TextLine {
    private List fragments = new ArrayList();

    public TextLine() {
    }

    public TextLine(String string) {
        this(string, TextFragment.DEFAULT_FONT);
    }

    public TextLine(String string, Font font) {
        TextFragment textFragment = new TextFragment(string, font);
        this.fragments.add(textFragment);
    }

    public void addFragment(TextFragment textFragment) {
        this.fragments.add(textFragment);
    }

    public Dimension calculateDimensions(Graphics2D graphics2D) {
        Dimension dimension = new Dimension();
        double d = 0.0;
        double d2 = 0.0;
        Iterator iterator = this.fragments.iterator();
        while (iterator.hasNext()) {
            TextFragment textFragment = (TextFragment)iterator.next();
            Dimension dimension2 = textFragment.calculateDimensions(graphics2D);
            d += dimension2.getWidth();
            d2 = Math.max(d2, dimension2.getHeight());
        }
        dimension.setSize(d, d2);
        return dimension;
    }

    public void draw(Graphics2D graphics2D, float f, float f2, TextAnchor textAnchor, float f3, float f4, double d) {
        float f5 = f;
        float f6 = this.calculateBaselineOffset(graphics2D, textAnchor);
        Iterator iterator = this.fragments.iterator();
        while (iterator.hasNext()) {
            TextFragment textFragment = (TextFragment)iterator.next();
            Dimension dimension = textFragment.calculateDimensions(graphics2D);
            textFragment.draw(graphics2D, f5, f2 + f6, TextAnchor.BASELINE_LEFT, f3, f4, d);
            f5 += (float)dimension.getWidth();
        }
    }

    public TextFragment getFirstTextFragment() {
        TextFragment textFragment = null;
        if (this.fragments.size() > 0) {
            textFragment = (TextFragment)this.fragments.get(0);
        }
        return textFragment;
    }

    private float calculateBaselineOffset(Graphics2D graphics2D, TextAnchor textAnchor) {
        float f = 0.0f;
        TextFragment textFragment = this.getFirstTextFragment();
        if (textFragment != null) {
            f = textFragment.calculateBaselineOffset(graphics2D, textAnchor);
        }
        return f;
    }
}

