/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.generator;

import java.io.IOException;
import java.io.Writer;
import org.jfree.xml.generator.model.ClassDescription;
import org.jfree.xml.generator.model.DescriptionModel;
import org.jfree.xml.generator.model.IgnoredPropertyInfo;
import org.jfree.xml.generator.model.PropertyInfo;
import org.jfree.xml.generator.model.PropertyType;
import org.jfree.xml.generator.model.TypeInfo;
import org.jfree.xml.writer.AttributeList;
import org.jfree.xml.writer.SafeTagList;
import org.jfree.xml.writer.XMLWriterSupport;

public class ModelWriter {
    private static SafeTagList safeTags;
    private XMLWriterSupport writerSupport = new XMLWriterSupport(ModelWriter.getSafeTags(), 0);
    private DescriptionModel model;

    public static SafeTagList getSafeTags() {
        if (safeTags == null) {
            safeTags = new SafeTagList();
            safeTags.add("objects");
            safeTags.add("object");
            safeTags.add("constructor");
            safeTags.add("property");
            safeTags.add("parameter");
            safeTags.add("include");
            safeTags.add("ignore");
        }
        return safeTags;
    }

    public DescriptionModel getModel() {
        return this.model;
    }

    public void setModel(DescriptionModel descriptionModel) {
        this.model = descriptionModel;
    }

    public void write(Writer writer) throws IOException {
        this.writerSupport.writeTag(writer, "objects");
        for (int i = 0; i < this.model.size(); ++i) {
            ClassDescription classDescription = this.model.get(i);
            this.writeClassDescription(writer, classDescription);
        }
        this.writerSupport.writeCloseTag(writer, "objects");
    }

    protected void writeClassDescription(Writer writer, ClassDescription classDescription) throws IOException {
        AttributeList attributeList = new AttributeList();
        attributeList.setAttribute("class", classDescription.getName());
        if (classDescription.getRegisterKey() != null) {
            attributeList.setAttribute("register-key", classDescription.getRegisterKey());
        }
        this.writerSupport.writeTag(writer, "object", attributeList, false);
        TypeInfo[] typeInfoArray = classDescription.getConstructorDescription();
        if (typeInfoArray != null && typeInfoArray.length != 0) {
            this.writerSupport.writeTag(writer, "constructor");
            for (int i = 0; i < typeInfoArray.length; ++i) {
                AttributeList attributeList2 = new AttributeList();
                attributeList2.setAttribute("class", typeInfoArray[i].getType().getName());
                attributeList2.setAttribute("property", typeInfoArray[i].getName());
            }
            this.writerSupport.writeCloseTag(writer, "constructor");
        }
        PropertyInfo[] propertyInfoArray = classDescription.getProperties();
        for (int i = 0; i < propertyInfoArray.length; ++i) {
            this.writePropertyInfo(writer, propertyInfoArray[i]);
        }
        this.writerSupport.writeCloseTag(writer, "object");
    }

    private void writePropertyInfo(Writer writer, PropertyInfo propertyInfo) throws IOException {
        AttributeList attributeList = new AttributeList();
        attributeList.setAttribute("name", propertyInfo.getName());
        if (propertyInfo instanceof IgnoredPropertyInfo) {
            this.writerSupport.writeTag(writer, "ignore", attributeList, true);
            return;
        }
        if (propertyInfo.getPropertyType().equals(PropertyType.ATTRIBUTE)) {
            attributeList.setAttribute("attribute", propertyInfo.getXmlName());
            attributeList.setAttribute("handler", propertyInfo.getXmlHandler());
        } else if (propertyInfo.getPropertyType().equals(PropertyType.ELEMENT)) {
            writer.write("        <!-- property type is " + propertyInfo.getType() + " -->");
            writer.write(System.getProperty("line.separator", "\n"));
            attributeList.setAttribute("element", propertyInfo.getXmlName());
        } else {
            attributeList.setAttribute("lookup", propertyInfo.getXmlName());
        }
        this.writerSupport.writeTag(writer, "property", attributeList, true);
    }

    public XMLWriterSupport getWriterSupport() {
        return this.writerSupport;
    }
}

