/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jfree.util.Log;
import org.jfree.xml.util.ObjectDescriptionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractModelReader {
    public static final String INCLUDE_TAG = "include";
    public static final String SOURCE_ATTR = "src";
    public static final String OBJECT_TAG = "object";
    public static final String CLASS_ATTR = "class";
    public static final String REGISTER_NAMES_ATTR = "register-name";
    public static final String PROPERTY_TAG = "property";
    public static final String NAME_ATTR = "name";
    public static final String ELEMENT_ATTR = "element";
    public static final String ATTRIBUTE_ATTR = "attribute";
    public static final String LOOKUP_ATTR = "lookup";
    public static final String CONSTRUCTOR_TAG = "constructor";
    public static final String PARAMETER_TAG = "parameter";
    public static final String PROPERTY_ATTR = "property";
    public static final String ATTRIBUTE_HANDLER_ATTR = "handler";
    public static final String IGNORED_PROPERTY_TAG = "ignore";

    protected void parseXml(URL uRL) throws ObjectDescriptionException {
        try {
            Object object;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            Document document = AbstractModelReader.parseInputStream(bufferedInputStream);
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName(INCLUDE_TAG);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                object = element2.getAttribute(SOURCE_ATTR);
                if (object == null) {
                    throw new ObjectDescriptionException("attribute 'src' is missing in element 'include'");
                }
                System.out.println("Including: " + new URL(uRL, (String)object));
                this.parseXml(new URL(uRL, (String)object));
                System.out.println("Done: " + new URL(uRL, (String)object));
            }
            NodeList nodeList2 = element.getElementsByTagName(OBJECT_TAG);
            Log.debug("Starting with " + nodeList2.getLength() + " objects.");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Object object2;
                Object object3;
                Object object4;
                object = (Element)nodeList2.item(i);
                String string = object.getAttribute(CLASS_ATTR);
                String string2 = object.getAttribute(REGISTER_NAMES_ATTR);
                if (string2 != null && string2.length() == 0) {
                    string2 = null;
                }
                if (!this.startObjectDefinition(string, string2)) continue;
                NodeList nodeList3 = object.getElementsByTagName("property");
                for (int j = 0; j < nodeList3.getLength(); ++j) {
                    object4 = (Element)nodeList3.item(j);
                    object3 = object4.getAttribute(NAME_ATTR);
                    if (object4.hasAttribute(ELEMENT_ATTR)) {
                        object2 = object4.getAttribute(ELEMENT_ATTR);
                        this.handleElementDefinition((String)object3, (String)object2);
                        continue;
                    }
                    if (object4.hasAttribute(ATTRIBUTE_ATTR)) {
                        object2 = object4.getAttribute(ATTRIBUTE_ATTR);
                        String string3 = object4.getAttribute(ATTRIBUTE_HANDLER_ATTR);
                        this.handleAttributeDefinition((String)object3, (String)object2, string3);
                        continue;
                    }
                    if (!object4.hasAttribute(LOOKUP_ATTR)) continue;
                    object2 = object4.getAttribute(LOOKUP_ATTR);
                    this.handleLookupDefinition((String)object3, (String)object2);
                }
                NodeList nodeList4 = object.getElementsByTagName(IGNORED_PROPERTY_TAG);
                for (int j = 0; j < nodeList4.getLength(); ++j) {
                    object3 = (Element)nodeList4.item(j);
                    object2 = object3.getAttribute(NAME_ATTR);
                    this.handleIgnoredProperty((String)object2);
                }
                object4 = object.getElementsByTagName(CONSTRUCTOR_TAG);
                if (object4.getLength() > 1) {
                    throw new ObjectDescriptionException("Only one constructor definition allowed");
                }
                if (object4.getLength() == 1) {
                    object3 = (Element)object4.item(0);
                    object2 = object3.getElementsByTagName(PARAMETER_TAG);
                    for (int j = 0; j < object2.getLength(); ++j) {
                        Element element3 = (Element)object2.item(j);
                        String string4 = element3.getAttribute(CLASS_ATTR);
                        String string5 = element3.getAttribute("property");
                        this.handleConstructorDefinition(string5, string4);
                    }
                }
                this.endObjectDefinition();
            }
            ((InputStream)bufferedInputStream).close();
        }
        catch (ObjectDescriptionException objectDescriptionException) {
            throw objectDescriptionException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ObjectDescriptionException("Unable to load object factory specs.", exception);
        }
    }

    protected void handleIgnoredProperty(String string) {
    }

    protected abstract boolean startObjectDefinition(String var1, String var2);

    protected abstract void handleAttributeDefinition(String var1, String var2, String var3) throws ObjectDescriptionException;

    protected abstract void handleElementDefinition(String var1, String var2) throws ObjectDescriptionException;

    protected abstract void handleLookupDefinition(String var1, String var2) throws ObjectDescriptionException;

    protected abstract void endObjectDefinition() throws ObjectDescriptionException;

    protected abstract void handleConstructorDefinition(String var1, String var2) throws ObjectDescriptionException;

    public static Document parseInputStream(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(new InputSource(inputStream));
    }

    protected Class loadClass(String string) {
        if (string == null) {
            return null;
        }
        try {
            return this.getClass().getClassLoader().loadClass(string);
        }
        catch (Exception exception) {
            System.out.println("Unable to handle " + string);
            return null;
        }
    }
}

